/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class PlotGrowthRecord
extends Record {
    public static final short sid = 4196;
    private int field_1_horizontalScale;
    private int field_2_verticalScale;

    public PlotGrowthRecord() {
    }

    public PlotGrowthRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PlotGrowthRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4196) {
            throw new RecordFormatException("Not a PlotGrowth record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_horizontalScale = LittleEndian.getInt(data, 0 + offset);
        this.field_2_verticalScale = LittleEndian.getInt(data, 4 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PlotGrowth]\n");
        buffer.append("    .horizontalScale      = ").append("0x").append(HexDump.toHex(this.getHorizontalScale())).append(" (").append(this.getHorizontalScale()).append(" )\n");
        buffer.append("    .verticalScale        = ").append("0x").append(HexDump.toHex(this.getVerticalScale())).append(" (").append(this.getVerticalScale()).append(" )\n");
        buffer.append("[/PlotGrowth]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4196);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(data, 4 + offset, this.field_1_horizontalScale);
        LittleEndian.putInt(data, 8 + offset, this.field_2_verticalScale);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 4196;
    }

    public int getHorizontalScale() {
        return this.field_1_horizontalScale;
    }

    public void setHorizontalScale(int field_1_horizontalScale) {
        this.field_1_horizontalScale = field_1_horizontalScale;
    }

    public int getVerticalScale() {
        return this.field_2_verticalScale;
    }

    public void setVerticalScale(int field_2_verticalScale) {
        this.field_2_verticalScale = field_2_verticalScale;
    }
}

