/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.ValueReferencePtg;
import org.apache.poi.hssf.record.formula.ValueVariableFunctionPtg;

public abstract class Ptg {
    public static Ptg createPtg(byte[] data, int offset) {
        byte id = data[offset + 0];
        Ptg retval = null;
        System.out.println("PTG = " + Integer.toHexString(id) + " (" + id + ")");
        switch (id) {
            case 3: {
                retval = new AddPtg(data, offset);
                break;
            }
            case 4: {
                retval = new SubtractPtg(data, offset);
                break;
            }
            case 30: {
                retval = new IntPtg(data, offset);
                break;
            }
            case 6: {
                retval = new DividePtg(data, offset);
                break;
            }
            case 5: {
                retval = new MultiplyPtg(data, offset);
                break;
            }
            case 7: {
                retval = new PowerPtg(data, offset);
                break;
            }
            case 37: {
                retval = new AreaPtg(data, offset);
                break;
            }
            case 39: {
                retval = new MemErrPtg(data, offset);
                break;
            }
            case 25: {
                retval = new AttrPtg(data, offset);
                break;
            }
            case 68: {
                retval = new ValueReferencePtg(data, offset);
                break;
            }
            case 66: {
                retval = new ValueVariableFunctionPtg(data, offset);
                break;
            }
            case 35: {
                retval = new NamePtg(data, offset);
                break;
            }
            case 1: {
                retval = new ExpPtg(data, offset);
                break;
            }
            default: {
                throw new RuntimeException("Unknown PTG = " + Integer.toHexString(id) + " (" + id + ")");
            }
        }
        return retval;
    }

    public abstract int getSize();

    public final byte[] getBytes() {
        int size = this.getSize();
        byte[] bytes = new byte[size];
        this.writeBytes(bytes, 0);
        return bytes;
    }

    public abstract void writeBytes(byte[] var1, int var2);

    public abstract String toFormulaString();

    public int getPrecedence() {
        return 100;
    }

    public int getStringLength() {
        return 0;
    }
}

