/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.ArrayList;
import java.util.List;

public class HSSFDataFormat {
    private static ArrayList formats;

    private static synchronized void populateFormats() {
        formats = new ArrayList();
        formats.add(0, "General");
        formats.add(1, "0");
        formats.add(2, "0.00");
        formats.add(3, "#,##0");
        formats.add(4, "#,##0.00");
        formats.add(5, "($#,##0_);($#,##0)");
        formats.add(6, "($#,##0_);[Red]($#,##0)");
        formats.add(7, "($#,##0.00);($#,##0.00)");
        formats.add(8, "($#,##0.00_);[Red]($#,##0.00)");
        formats.add(9, "0%");
        formats.add(10, "0.00%");
        formats.add(11, "0.00E+00");
        formats.add(12, "# ?/?");
        formats.add(13, "# ??/??");
        formats.add(14, "m/d/yy");
        formats.add(15, "d-mmm-yy");
        formats.add(16, "d-mmm");
        formats.add(17, "mmm-yy");
        formats.add(18, "h:mm AM/PM");
        formats.add(19, "h:mm:ss AM/PM");
        formats.add(20, "h:mm");
        formats.add(21, "h:mm:ss");
        formats.add(22, "m/d/yy h:mm");
        formats.add(23, "0x17");
        formats.add(24, "0x18");
        formats.add(25, "0x19");
        formats.add(26, "0x1a");
        formats.add(27, "0x1b");
        formats.add(28, "0x1c");
        formats.add(29, "0x1d");
        formats.add(30, "0x1e");
        formats.add(31, "0x1f");
        formats.add(32, "0x20");
        formats.add(33, "0x21");
        formats.add(34, "0x22");
        formats.add(35, "0x23");
        formats.add(36, "0x24");
        formats.add(37, "(#,##0_);(#,##0)");
        formats.add(38, "(#,##0_);[Red](#,##0)");
        formats.add(39, "(#,##0.00_);(#,##0.00)");
        formats.add(40, "(#,##0.00_);[Red](#,##0.00)");
        formats.add(41, "_(*#,##0_);_(*(#,##0);_(* \"-\"_);_(@_)");
        formats.add(42, "_($*#,##0_);_($*(#,##0);_($* \"-\"_);_(@_)");
        formats.add(43, "_(*#,##0.00_);_(*(#,##0.00);_(*\"-\"??_);_(@_)");
        formats.add(44, "_($*#,##0.00_);_($*(#,##0.00);_($*\"-\"??_);_(@_)");
        formats.add(45, "mm:ss");
        formats.add(46, "[h]:mm:ss");
        formats.add(47, "mm:ss.0");
        formats.add(48, "##0.0E+0");
        formats.add(49, "@");
    }

    public static List getFormats() {
        if (formats == null) {
            HSSFDataFormat.populateFormats();
        }
        return formats;
    }

    public static short getFormat(String format) {
        if (formats == null) {
            HSSFDataFormat.populateFormats();
        }
        int retval = -1;
        int k = 0;
        while (k < 49) {
            String nformat = (String)formats.get(k);
            if (nformat != null && nformat.equals(format)) {
                retval = k;
                break;
            }
            k = (short)(k + 1);
        }
        return (short)retval;
    }

    public static String getFormat(short index) {
        if (formats == null) {
            HSSFDataFormat.populateFormats();
        }
        return (String)formats.get(index);
    }

    public static int getNumberOfBuiltinFormats() {
        if (formats == null) {
            HSSFDataFormat.populateFormats();
        }
        return formats.size();
    }
}

