/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.threads;

import java.util.Enumeration;
import java.util.Vector;
import org.jfree.threads.ReaderWriterNode;

public class ReaderWriterLock {
    private Vector waiters = new Vector();

    public synchronized void lockRead() {
        ReaderWriterNode readerWriterNode;
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            readerWriterNode = new ReaderWriterNode(thread, 0);
            this.waiters.addElement(readerWriterNode);
        } else {
            readerWriterNode = (ReaderWriterNode)this.waiters.elementAt(n);
        }
        while (this.getIndex(thread) > this.firstWriter()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                System.err.println("ReaderWriterLock.lockRead(): exception.");
                System.err.print(exception.getMessage());
            }
        }
        ++readerWriterNode.nAcquires;
    }

    public synchronized void lockWrite() {
        ReaderWriterNode readerWriterNode;
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n == -1) {
            readerWriterNode = new ReaderWriterNode(thread, 1);
            this.waiters.addElement(readerWriterNode);
        } else {
            readerWriterNode = (ReaderWriterNode)this.waiters.elementAt(n);
            if (readerWriterNode.state == 0) {
                throw new IllegalArgumentException("Upgrade lock");
            }
            readerWriterNode.state = 1;
        }
        while (this.getIndex(thread) != 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                System.err.println("ReaderWriterLock.lockWrite(): exception.");
                System.err.print(exception.getMessage());
            }
        }
        ++readerWriterNode.nAcquires;
    }

    public synchronized void unlock() {
        Thread thread = Thread.currentThread();
        int n = this.getIndex(thread);
        if (n > this.firstWriter()) {
            throw new IllegalArgumentException("Lock not held");
        }
        ReaderWriterNode readerWriterNode = (ReaderWriterNode)this.waiters.elementAt(n);
        --readerWriterNode.nAcquires;
        if (readerWriterNode.nAcquires == 0) {
            this.waiters.removeElementAt(n);
        }
        this.notifyAll();
    }

    private int firstWriter() {
        int n = 0;
        Enumeration enumeration = this.waiters.elements();
        while (enumeration.hasMoreElements()) {
            ReaderWriterNode readerWriterNode = (ReaderWriterNode)enumeration.nextElement();
            if (readerWriterNode.state == 1) {
                return n;
            }
            ++n;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread thread) {
        int n = 0;
        Enumeration enumeration = this.waiters.elements();
        while (enumeration.hasMoreElements()) {
            ReaderWriterNode readerWriterNode = (ReaderWriterNode)enumeration.nextElement();
            if (readerWriterNode.t == thread) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

