/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FontChooserPanel
extends JPanel {
    public static final String[] SIZES = new String[]{"9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "28", "36", "48", "72"};
    private JList fontlist;
    private JList sizelist;
    private JCheckBox bold;
    private JCheckBox italic;

    public FontChooserPanel(Font font) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Font:"));
        this.fontlist = new JList<String>(stringArray);
        JScrollPane jScrollPane = new JScrollPane(this.fontlist);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add(jScrollPane);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Size:"));
        this.sizelist = new JList<String>(SIZES);
        JScrollPane jScrollPane2 = new JScrollPane(this.sizelist);
        jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.add(jScrollPane2);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        this.bold = new JCheckBox("Bold");
        this.italic = new JCheckBox("Italic");
        jPanel4.add(this.bold);
        jPanel4.add(this.italic);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Attributes:"));
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.add((Component)jPanel, "East");
    }

    public Font getSelectedFont() {
        return new Font(this.getSelectedName(), this.getSelectedStyle(), this.getSelectedSize());
    }

    public String getSelectedName() {
        return (String)this.fontlist.getSelectedValue();
    }

    public int getSelectedStyle() {
        if (this.bold.isSelected() && this.italic.isSelected()) {
            return 3;
        }
        if (this.bold.isSelected()) {
            return 1;
        }
        if (this.italic.isSelected()) {
            return 2;
        }
        return 0;
    }

    public int getSelectedSize() {
        String string = (String)this.sizelist.getSelectedValue();
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 10;
    }
}

