/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Png
extends Image
implements Element {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";

    Png(Image image) {
        super(image);
    }

    public Png(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Png(URL uRL, float f, float f2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    public Png(String string) throws MalformedURLException, BadElementException, IOException {
        this(Image.toURL(string));
    }

    public Png(String string, float f, float f2) throws MalformedURLException, BadElementException, IOException {
        this(Image.toURL(string), f, f2);
    }

    public Png(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.processParameters();
    }

    public Png(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    public static final int getInt(InputStream inputStream) throws IOException {
        return (inputStream.read() << 24) + (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    public static final int getWord(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    public static final String getString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            stringBuffer.append((char)inputStream.read());
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        this.type = 33;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            int n = 0;
            while (n < PNGID.length) {
                if (PNGID[n] != inputStream.read()) {
                    throw new BadElementException(string + " is not a valid PNG-file.");
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (inputStream != null) {
                inputStream.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
            throw throwable;
        }
        while (true) {
            int n = Png.getInt(inputStream);
            String string = Png.getString(inputStream);
            if (IHDR.equals(string)) {
                this.scaledWidth = Png.getInt(inputStream);
                this.setRight(this.scaledWidth);
                this.scaledHeight = Png.getInt(inputStream);
                this.setTop(this.scaledHeight);
                Image.skip(inputStream, n + 4 - 8);
                continue;
            }
            if (pHYs.equals(string)) {
                int n2 = Png.getInt(inputStream);
                int n3 = Png.getInt(inputStream);
                int n4 = inputStream.read();
                if (n4 == 1) {
                    this.dpiX = (int)((float)n2 * 0.0254f + 0.5f);
                    this.dpiY = (int)((float)n3 * 0.0254f + 0.5f);
                }
                Image.skip(inputStream, n + 4 - 9);
                continue;
            }
            if (IDAT.equals(string) || IEND.equals(string)) break;
            Image.skip(inputStream, n + 4);
        }
        Object var10_9 = null;
        if (inputStream != null) {
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }
}

