/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintEllipse;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRDesignReportFont;
import dori.jasper.engine.export.JRExporterGridCell;
import dori.jasper.engine.export.JRHtmlExporterParameter;
import dori.jasper.engine.export.JRXmlExporterParameter;
import dori.jasper.engine.util.JRImageLoader;
import dori.jasper.engine.util.JRLoader;
import dori.jasper.engine.util.JRStringUtil;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class JRHtmlExporter
extends JRAbstractExporter {
    public static final String CSS_TEXT_ALIGN_LEFT = "left";
    public static final String CSS_TEXT_ALIGN_RIGHT = "right";
    public static final String CSS_TEXT_ALIGN_CENTER = "center";
    public static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    public static final String HTML_VERTICAL_ALIGN_TOP = "top";
    public static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    public static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    private JasperPrint jasperPrint = null;
    private Writer writer = null;
    private Map loadedImagesMap = null;
    private Map imagesMap = null;
    private JRReportFont defaultFont = null;
    private File imagesDir = null;
    private String imagesURI = null;
    private boolean isOutputImagesToDir = false;
    private boolean isRemoveEmptySpace = false;
    private int startPageIndex = 0;
    private int endPageIndex = 0;
    private String htmlHeader = null;
    private String betweenPagesHtml = null;
    private String htmlFooter = null;
    private static final int colorMask;
    private JRExporterGridCell[][] grid = null;
    private boolean[] isRowNotEmpty = null;
    private List xCuts = null;
    private List yCuts = null;

    private JRReportFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignReportFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        String encoding;
        String uri;
        Boolean isOutputImagesToDirParameter;
        Boolean isRemoveEmptySpaceParameter;
        String dir;
        Integer start;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < 0 || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " of " + lastPageIndex);
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
        this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
        this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
        this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
        this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
        if (this.imagesDir == null && (dir = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
            this.imagesDir = new File(dir);
        }
        if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        if ((isOutputImagesToDirParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR)) != null) {
            this.isOutputImagesToDir = isOutputImagesToDirParameter;
        }
        if ((uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
            this.imagesURI = uri;
        }
        this.imagesMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
        if (this.imagesMap == null) {
            this.imagesMap = new HashMap();
        }
        if ((encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            encoding = "ISO-8859-1";
        }
        this.loadedImagesMap = new HashMap();
        byte[] pxBytes = JRImageLoader.loadImageDataFromLocation("dori/jasper/engine/images/pixel.GIF");
        this.loadedImagesMap.put(pxBytes, "px");
        this.imagesMap.put("px", pxBytes);
        StringBuffer sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
                this.writer.close();
            }
            catch (IOException e) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            this.writer = new FileWriter(destFile);
        }
        catch (IOException e) {
            throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
        }
        if (this.imagesDir == null) {
            this.imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
        }
        if (isOutputImagesToDirParameter == null) {
            this.isOutputImagesToDir = true;
        }
        if (this.imagesURI == null) {
            this.imagesURI = this.imagesDir.getName() + "/";
        }
        try {
            this.exportReportToWriter();
            this.writer.close();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
        }
        if (this.isOutputImagesToDir) {
            if (this.imagesDir == null) {
                throw new JRException("The images directory was not specified for the exporter.");
            }
            Set imageKeys = this.loadedImagesMap.keySet();
            if (imageKeys != null && imageKeys.size() > 0) {
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                byte[] imageData = null;
                File imageFile = null;
                FileOutputStream fos = null;
                Iterator it = imageKeys.iterator();
                while (it.hasNext()) {
                    imageData = (byte[])it.next();
                    imageFile = new File(this.imagesDir, (String)this.loadedImagesMap.get(imageData));
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                        fos.close();
                    }
                    catch (Exception e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                }
            }
        }
    }

    private void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            this.writer.write("<head>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        List pages = this.jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            int i = this.startPageIndex;
            while (i <= this.endPageIndex) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + (i + 1) + "\">\n");
                this.exportPage(page);
                if (this.betweenPagesHtml == null) {
                    this.writer.write("<br>\n<br>\n");
                } else {
                    this.writer.write(this.betweenPagesHtml);
                }
                this.writer.write("\n");
                ++i;
            }
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        this.writer.flush();
    }

    private void exportPage(JRPrintPage page) throws JRException, IOException {
        this.writer.write("<table width=" + this.jasperPrint.getPageWidth() + " cellpadding=0 cellspacing=0 border=0 bgcolor=white>\n");
        this.layoutGrid(page);
        this.writer.write("<tr>\n");
        int width = 0;
        int i = 1;
        while (i < this.xCuts.size()) {
            width = (Integer)this.xCuts.get(i) - (Integer)this.xCuts.get(i - 1);
            this.writer.write("  <td><img src=\"" + this.imagesURI + "px\" width=" + width + " height=1></td>\n");
            ++i;
        }
        this.writer.write("</tr>\n");
        JRPrintElement element = null;
        int y = 0;
        while (y < this.grid.length) {
            if (this.isRowNotEmpty[y] || !this.isRemoveEmptySpace) {
                this.writer.write("<tr valign=top>\n");
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                int lastRowHeight = this.grid[y][0].height;
                int x = 0;
                while (x < this.grid[y].length) {
                    if (this.grid[y][x].element != null) {
                        if (emptyCellColSpan > 0) {
                            this.writer.write("  <td");
                            if (emptyCellColSpan > 1) {
                                this.writer.write(" colspan=" + emptyCellColSpan);
                            }
                            this.writer.write("><img src=\"" + this.imagesURI + "px\" width=" + emptyCellWidth + " height=" + lastRowHeight + "></td>\n");
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = this.grid[y][x].element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, this.grid[y][x]);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, this.grid[y][x]);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, this.grid[y][x]);
                        } else if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, this.grid[y][x]);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, this.grid[y][x]);
                        }
                        x += this.grid[y][x].colSpan - 1;
                    } else {
                        ++emptyCellColSpan;
                        emptyCellWidth += this.grid[y][x].width;
                    }
                    ++x;
                }
                if (emptyCellColSpan > 0) {
                    this.writer.write("  <td");
                    if (emptyCellColSpan > 1) {
                        this.writer.write(" colspan=" + emptyCellColSpan);
                    }
                    this.writer.write("><img src=\"" + this.imagesURI + "px\" width=" + emptyCellWidth + " height=" + lastRowHeight + "></td>\n");
                }
                this.writer.write("</tr>\n");
            }
            ++y;
        }
        this.writer.write("</table>\n");
    }

    private void exportLine(JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        if (line.getForecolor().getRGB() != Color.white.getRGB()) {
            this.writer.write(" bgcolor=#");
            String hexa = Integer.toHexString(line.getForecolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
        }
        this.writer.write(">");
        this.writer.write("<img src=\"" + this.imagesURI + "px\" border=0>");
        this.writer.write("</td>\n");
    }

    private void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell) throws IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB() && element.getMode() == 1) {
            this.writer.write(" bgcolor=#");
            String hexa = Integer.toHexString(element.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
        }
        this.writer.write(">");
        this.writer.write("<img src=\"" + this.imagesURI + "px\" border=0>");
        this.writer.write("</td>\n");
    }

    private void exportText(JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        JRFont font;
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (text.getVerticalAlignment()) {
            case 3: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        if (text.getBackcolor().getRGB() != Color.white.getRGB() && text.getMode() == 1) {
            styleBuffer.append("background-color: #");
            String hexa = Integer.toHexString(text.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            styleBuffer.append(hexa);
            styleBuffer.append("; ");
        }
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        if (text.getText() != null && text.getText().length() > 0) {
            switch (text.getTextAlignment()) {
                case 3: {
                    horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 2: {
                    horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 4: {
                    horizontalAlignment = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\">");
        }
        String href = null;
        switch (text.getHyperlinkType()) {
            case 2: {
                if (text.getHyperlinkReference() == null) break;
                href = text.getHyperlinkReference();
                break;
            }
            case 3: {
                if (text.getHyperlinkAnchor() == null) break;
                href = "#" + text.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (text.getHyperlinkPage() == null) break;
                href = "#JR_PAGE_ANCHOR_" + text.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkAnchor() == null) break;
                href = text.getHyperlinkReference() + "#" + text.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkPage() == null) break;
                href = text.getHyperlinkReference() + "#JR_PAGE_ANCHOR_" + text.getHyperlinkPage().toString();
                break;
            }
        }
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\">");
        }
        if ((font = text.getFont()) == null) {
            font = this.getDefaultFont();
        }
        if (text.getText() != null && text.getText().length() > 0) {
            this.writer.write("<font face=\"");
            this.writer.write(font.getFontName());
            this.writer.write("\" style=\"");
            if (text.getForecolor().getRGB() != Color.black.getRGB()) {
                this.writer.write("color: #");
                String hexa = Integer.toHexString(text.getForecolor().getRGB() & colorMask).toUpperCase();
                hexa = ("000000" + hexa).substring(hexa.length());
                this.writer.write(hexa);
                this.writer.write("; ");
            }
            this.writer.write("font-size: ");
            this.writer.write(String.valueOf(font.getSize()));
            this.writer.write("px;");
            if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
                this.writer.write(" text-align: ");
                this.writer.write(horizontalAlignment);
                this.writer.write(";");
            }
            if (font.isUnderline()) {
                this.writer.write(" text-decoration: underline;");
            }
            if (font.isStrikeThrough()) {
                this.writer.write(" text-decoration: line-through;");
            }
            this.writer.write("\">");
            if (font.isBold()) {
                this.writer.write("<b>");
            }
            if (font.isItalic()) {
                this.writer.write("<i>");
            }
            this.writer.write(JRHtmlExporter.replaceNewLineWithBR(JRStringUtil.xmlEncode(text.getText())));
            if (font.isItalic()) {
                this.writer.write("</i>");
            }
            if (font.isBold()) {
                this.writer.write("</b>");
            }
            this.writer.write("</font>");
        } else {
            this.writer.write("<img src=\"" + this.imagesURI + "px\" border=0>");
        }
        if (href != null) {
            this.writer.write("</a>");
        }
        this.writer.write("</td>\n");
    }

    private void exportImage(JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        this.writer.write("  <td");
        if (gridCell.colSpan > 1) {
            this.writer.write(" colspan=" + gridCell.colSpan);
        }
        if (gridCell.rowSpan > 1) {
            this.writer.write(" rowspan=" + gridCell.rowSpan);
        }
        if (image.getBackcolor().getRGB() != Color.white.getRGB() && image.getMode() == 1) {
            this.writer.write(" bgcolor=#");
            String hexa = Integer.toHexString(image.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.writer.write(hexa);
        }
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                break;
            }
            case 2: {
                horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                break;
            }
            default: {
                horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
            }
        }
        if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
            this.writer.write(" align=\"");
            this.writer.write(horizontalAlignment);
            this.writer.write("\"");
        }
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (image.getVerticalAlignment()) {
            case 3: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\">");
        }
        String href = null;
        switch (image.getHyperlinkType()) {
            case 2: {
                if (image.getHyperlinkReference() == null) break;
                href = image.getHyperlinkReference();
                break;
            }
            case 3: {
                if (image.getHyperlinkAnchor() == null) break;
                href = "#" + image.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (image.getHyperlinkPage() == null) break;
                href = "#JR_PAGE_ANCHOR_" + image.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (image.getHyperlinkReference() == null || image.getHyperlinkAnchor() == null) break;
                href = image.getHyperlinkReference() + "#" + image.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (image.getHyperlinkReference() == null || image.getHyperlinkPage() == null) break;
                href = image.getHyperlinkReference() + "#JR_PAGE_ANCHOR_" + image.getHyperlinkPage().toString();
                break;
            }
        }
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\">");
        }
        this.writer.write("<img");
        String imageSource = "";
        int scaleImage = image.getScaleImage();
        byte[] imageData = image.getImageData();
        if (imageData != null) {
            if (this.loadedImagesMap.containsKey(imageData)) {
                imageSource = this.imagesURI + (String)this.loadedImagesMap.get(imageData);
            } else {
                imageSource = "img_" + String.valueOf(this.loadedImagesMap.size());
                this.loadedImagesMap.put(imageData, imageSource);
                this.imagesMap.put(imageSource, imageData);
                imageSource = this.imagesURI + imageSource;
            }
        } else {
            imageSource = this.imagesURI + "px";
            scaleImage = 2;
        }
        this.writer.write(" src=\"");
        this.writer.write(imageSource);
        this.writer.write("\"");
        int borderWidth = 0;
        switch (image.getPen()) {
            case 4: {
                borderWidth = 1;
                break;
            }
            case 3: {
                borderWidth = 4;
                break;
            }
            case 2: {
                borderWidth = 2;
                break;
            }
            case 0: {
                borderWidth = 0;
                break;
            }
            case 5: {
                borderWidth = 1;
                break;
            }
            default: {
                borderWidth = 1;
            }
        }
        this.writer.write(" border=");
        this.writer.write(String.valueOf(borderWidth));
        switch (scaleImage) {
            case 2: {
                this.writer.write(" width=");
                this.writer.write(String.valueOf(image.getWidth()));
                this.writer.write(" height=");
                this.writer.write(String.valueOf(image.getHeight()));
                break;
            }
            default: {
                Image awtImage = JRImageLoader.loadImage(imageData);
                if (image.getHeight() <= 0) break;
                double ratio = (double)awtImage.getWidth(null) / (double)awtImage.getHeight(null);
                if (ratio > (double)image.getWidth() / (double)image.getHeight()) {
                    this.writer.write(" width=");
                    this.writer.write(String.valueOf(image.getWidth()));
                    break;
                }
                this.writer.write(" height=");
                this.writer.write(String.valueOf(image.getHeight()));
            }
        }
        this.writer.write(">");
        if (href != null) {
            this.writer.write("</a>");
        }
        this.writer.write("</td>\n");
    }

    private void layoutGrid(JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.jasperPrint.getPageHeight()));
        Integer x = null;
        Integer y = null;
        JRPrintElement element = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            element = (JRPrintElement)it.next();
            x = new Integer(element.getX());
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(element.getY()))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowNotEmpty = new boolean[yCellCount];
        int j = 0;
        while (j < yCellCount) {
            int i = 0;
            while (i < xCellCount) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
                ++i;
            }
            ++j;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int xi = 0;
        int yi = 0;
        boolean isOverlap = false;
        int i = elems.size() - 1;
        while (i >= 0) {
            element = (JRPrintElement)elems.get(i);
            x1 = this.xCuts.indexOf(new Integer(element.getX()));
            y1 = this.yCuts.indexOf(new Integer(element.getY()));
            x2 = this.xCuts.indexOf(new Integer(element.getX() + element.getWidth()));
            y2 = this.yCuts.indexOf(new Integer(element.getY() + element.getHeight()));
            isOverlap = false;
            yi = y1;
            while (yi < y2 && !isOverlap) {
                xi = x1;
                while (xi < x2 && !isOverlap) {
                    if (this.grid[yi][xi].element != null) {
                        isOverlap = true;
                    }
                    ++xi;
                }
                ++yi;
            }
            if (!isOverlap) {
                yi = y1;
                while (yi < y2) {
                    xi = x1;
                    while (xi < x2) {
                        this.grid[yi][xi] = JRExporterGridCell.OCCUPIED_CELL;
                        ++xi;
                    }
                    this.isRowNotEmpty[yi] = true;
                    ++yi;
                }
                this.grid[y1][x1] = new JRExporterGridCell(element, element.getWidth(), element.getHeight(), x2 - x1, y2 - y1);
            }
            --i;
        }
    }

    private static String replaceNewLineWithBR(String source) {
        String str = null;
        if (source != null) {
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, "\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    sbuffer.append("<br>");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
        }
        return str;
    }

    static {
        CSS_TEXT_ALIGN_LEFT = CSS_TEXT_ALIGN_LEFT;
        CSS_TEXT_ALIGN_RIGHT = CSS_TEXT_ALIGN_RIGHT;
        CSS_TEXT_ALIGN_CENTER = CSS_TEXT_ALIGN_CENTER;
        CSS_TEXT_ALIGN_JUSTIFY = CSS_TEXT_ALIGN_JUSTIFY;
        HTML_VERTICAL_ALIGN_TOP = HTML_VERTICAL_ALIGN_TOP;
        HTML_VERTICAL_ALIGN_MIDDLE = HTML_VERTICAL_ALIGN_MIDDLE;
        HTML_VERTICAL_ALIGN_BOTTOM = HTML_VERTICAL_ALIGN_BOTTOM;
        colorMask = Integer.parseInt("FFFFFF", 16);
    }
}

