/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintEllipse;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.base.JRBasePrintPage;
import dori.jasper.engine.design.JRDesignReportFont;
import dori.jasper.engine.export.JRExporterGridCell;
import dori.jasper.engine.export.JRXlsExporterParameter;
import dori.jasper.engine.util.JRLoader;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public class JRXlsExporter
extends JRAbstractExporter {
    private JasperPrint jasperPrint = null;
    private int pageHeight = 0;
    private HSSFWorkbook workbook = null;
    private HSSFSheet sheet = null;
    private HSSFRow row = null;
    private HSSFCell cell = null;
    private HSSFCellStyle emptyCellStyle = null;
    private JRReportFont defaultFont = null;
    private List loadedFonts = new ArrayList();
    private List loadedCellStyles = new ArrayList();
    private boolean isOnePagePerSheet = false;
    private boolean isRemoveEmptySpace = false;
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private short whiteIndex = new HSSFColor.WHITE().getIndex();
    private JRExporterGridCell[][] grid = null;
    private boolean[] isRowNotEmpty = null;
    private List xCuts = null;
    private List yCuts = null;

    private JRReportFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignReportFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        Boolean isRemoveEmptySpaceParameter;
        Boolean isOnePagePerSheetParameter;
        OutputStream os;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        if ((os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM)) == null) {
            File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (file != null) {
                try {
                    os = new FileOutputStream(file);
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + file, e);
                }
            } else {
                String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    try {
                        os = new FileOutputStream(fileName);
                    }
                    catch (FileNotFoundException e) {
                        throw new JRException("Error trying to export to file : " + fileName, e);
                    }
                } else {
                    throw new JRException("No output specified for the exporter.");
                }
            }
        }
        if ((isOnePagePerSheetParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET)) != null) {
            this.isOnePagePerSheet = isOnePagePerSheetParameter;
        }
        if ((isRemoveEmptySpaceParameter = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = isRemoveEmptySpaceParameter;
        }
        this.exportReportToStream(os);
    }

    private void exportReportToStream(OutputStream os) throws JRException {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern((short)1);
        try {
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRPrintPage page = null;
                if (this.isOnePagePerSheet) {
                    this.pageHeight = this.jasperPrint.getPageHeight();
                    int i = 0;
                    while (i < pages.size()) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(i);
                        this.sheet = this.workbook.createSheet("Page " + (i + 1));
                        this.exportPage(page);
                        ++i;
                    }
                } else {
                    this.pageHeight = this.jasperPrint.getPageHeight() * pages.size();
                    JRBasePrintPage allPages = new JRBasePrintPage();
                    List elements = null;
                    JRPrintElement element = null;
                    int i = 0;
                    while (i < pages.size()) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(i);
                        elements = page.getElements();
                        if (elements != null && elements.size() > 0) {
                            Iterator it = elements.iterator();
                            while (it.hasNext()) {
                                element = (JRPrintElement)it.next();
                                element.setY(element.getY() + this.jasperPrint.getPageHeight() * i);
                                allPages.addElement(element);
                            }
                        }
                        ++i;
                    }
                    this.sheet = this.workbook.createSheet("Sheet1");
                    this.exportPage(allPages);
                }
            }
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void exportPage(JRPrintPage page) throws JRException {
        this.layoutGrid(page);
        width = 0;
        i = 1;
        while (i < this.xCuts.size()) {
            width = (Integer)this.xCuts.get(i) - (Integer)this.xCuts.get(i - 1);
            this.sheet.setColumnWidth((short)(i - 1), (short)(width * 43));
            ++i;
        }
        element = null;
        emptyCell = null;
        y = 0;
        while (y < this.grid.length) {
            if (this.isRowNotEmpty[y] || !this.isRemoveEmptySpace) {
                this.row = this.sheet.createRow((short)y);
                emptyCellColSpan = 0;
                emptyCellWidth = 0;
                lastRowHeight = this.grid[y][0].height;
                this.row.setHeight((short)(lastRowHeight * 19));
                x = 0;
                x = 0;
                while (x < this.grid[y].length) {
                    emptyCell = this.row.createCell((short)x);
                    emptyCell.setCellStyle(this.emptyCellStyle);
                    if (this.grid[y][x].element != null) {
                        if (emptyCellColSpan > 0) {
                            if (emptyCellColSpan > 1) {
                                // empty if block
                            }
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = this.grid[y][x].element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, this.grid[y][x], x, y);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, this.grid[y][x], x, y);
                        }
                        x += this.grid[y][x].colSpan - 1;
                    } else {
                        ++emptyCellColSpan;
                        emptyCellWidth += this.grid[y][x].width;
                    }
                    ++x;
                }
                ** if (emptyCellColSpan > 0 && emptyCellColSpan <= 1) goto lbl57
            }
            this.row = this.sheet.createRow((short)y);
            this.row.setHeight((short)0);
            x = 0;
            while (x < this.grid[y].length) {
                emptyCell = this.row.createCell((short)x);
                emptyCell.setCellStyle(this.emptyCellStyle);
                ++x;
            }
lbl-1000:
            // 1 sources

            {
                // empty if block
            }
lbl57:
            // 3 sources

            ++y;
        }
    }

    private void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        short forecolor = JRXlsExporter.getNearestColor(line.getForecolor()).getIndex();
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(forecolor, (short)1, (short)0, cellFont);
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    private void exportRectangle(JRPrintElement element, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        short forecolor = JRXlsExporter.getNearestColor(element.getForecolor()).getIndex();
        short backcolor = this.whiteIndex;
        if (element.getMode() == 1) {
            backcolor = JRXlsExporter.getNearestColor(element.getBackcolor()).getIndex();
        }
        HSSFFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor);
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(backcolor, (short)1, (short)0, cellFont);
        this.cell = this.row.createCell((short)x);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(cellStyle);
    }

    private void exportText(JRPrintText text, JRExporterGridCell gridCell, int x, int y) {
        if (gridCell.colSpan > 1 || gridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(y, (short)x, y + gridCell.rowSpan - 1, (short)(x + gridCell.colSpan - 1)));
        }
        if (text.getText() != null) {
            JRFont font = text.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            short forecolor = JRXlsExporter.getNearestColor(text.getForecolor()).getIndex();
            HSSFFont cellFont = this.getLoadedFont(font, forecolor);
            short horizontalAlignment = 1;
            switch (text.getTextAlignment()) {
                case 1: {
                    horizontalAlignment = 1;
                    break;
                }
                case 2: {
                    horizontalAlignment = 2;
                    break;
                }
                case 3: {
                    horizontalAlignment = 3;
                    break;
                }
                case 4: {
                    horizontalAlignment = 5;
                    break;
                }
                default: {
                    horizontalAlignment = 1;
                }
            }
            short verticalAlignment = 1;
            switch (text.getVerticalAlignment()) {
                case 1: {
                    verticalAlignment = 0;
                    break;
                }
                case 2: {
                    verticalAlignment = 1;
                    break;
                }
                case 3: {
                    verticalAlignment = 2;
                    break;
                }
                default: {
                    verticalAlignment = 0;
                }
            }
            short backcolor = this.whiteIndex;
            if (text.getMode() == 1) {
                backcolor = JRXlsExporter.getNearestColor(text.getBackcolor()).getIndex();
            }
            HSSFCellStyle cellStyle = this.getLoadedCellStyle(backcolor, horizontalAlignment, verticalAlignment, cellFont);
            this.cell = this.row.createCell((short)x);
            this.cell.setEncoding((short)1);
            this.cell.setCellValue(text.getText());
            this.cell.setCellStyle(cellStyle);
        }
    }

    private void layoutGrid(JRPrintPage page) {
        this.xCuts = new ArrayList();
        this.yCuts = new ArrayList();
        this.xCuts.add(new Integer(0));
        this.xCuts.add(new Integer(this.jasperPrint.getPageWidth()));
        this.yCuts.add(new Integer(0));
        this.yCuts.add(new Integer(this.pageHeight));
        Integer x = null;
        Integer y = null;
        JRPrintElement element = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            element = (JRPrintElement)it.next();
            if (element instanceof JRPrintImage) continue;
            x = new Integer(element.getX());
            if (!this.xCuts.contains(x)) {
                this.xCuts.add(x);
            }
            if (!this.xCuts.contains(x = new Integer(element.getX() + element.getWidth()))) {
                this.xCuts.add(x);
            }
            if (!this.yCuts.contains(y = new Integer(element.getY()))) {
                this.yCuts.add(y);
            }
            if (this.yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            this.yCuts.add(y);
        }
        Collections.sort(this.xCuts);
        Collections.sort(this.yCuts);
        int xCellCount = this.xCuts.size() - 1;
        int yCellCount = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[yCellCount][xCellCount];
        this.isRowNotEmpty = new boolean[yCellCount];
        int j = 0;
        while (j < yCellCount) {
            int i = 0;
            while (i < xCellCount) {
                this.grid[j][i] = new JRExporterGridCell(null, (Integer)this.xCuts.get(i + 1) - (Integer)this.xCuts.get(i), (Integer)this.yCuts.get(j + 1) - (Integer)this.yCuts.get(j), 1, 1);
                ++i;
            }
            ++j;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int xi = 0;
        int yi = 0;
        boolean isOverlap = false;
        int i = elems.size() - 1;
        while (i >= 0) {
            element = (JRPrintElement)elems.get(i);
            if (!(element instanceof JRPrintImage)) {
                x1 = this.xCuts.indexOf(new Integer(element.getX()));
                y1 = this.yCuts.indexOf(new Integer(element.getY()));
                x2 = this.xCuts.indexOf(new Integer(element.getX() + element.getWidth()));
                y2 = this.yCuts.indexOf(new Integer(element.getY() + element.getHeight()));
                isOverlap = false;
                yi = y1;
                while (yi < y2 && !isOverlap) {
                    xi = x1;
                    while (xi < x2 && !isOverlap) {
                        if (this.grid[yi][xi].element != null) {
                            isOverlap = true;
                        }
                        ++xi;
                    }
                    ++yi;
                }
                if (!isOverlap) {
                    yi = y1;
                    while (yi < y2) {
                        xi = x1;
                        while (xi < x2) {
                            this.grid[yi][xi] = JRExporterGridCell.OCCUPIED_CELL;
                            ++xi;
                        }
                        this.isRowNotEmpty[yi] = true;
                        ++yi;
                    }
                    this.grid[y1][x1] = new JRExporterGridCell(element, element.getWidth(), element.getHeight(), x2 - x1, y2 - y1);
                }
            }
            --i;
        }
    }

    private static HSSFColor getNearestColor(Color awtColor) {
        Set keys;
        HSSFColor color = null;
        Hashtable triplets = HSSFColor.getTripletHash();
        if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
            Object key = null;
            HSSFColor crtColor = null;
            short[] rgb = null;
            int diff = 0;
            int minDiff = 999;
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                key = it.next();
                crtColor = (HSSFColor)triplets.get(key);
                rgb = crtColor.getTriplet();
                diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
        }
        return color;
    }

    private HSSFFont getLoadedFont(JRFont font, short forecolor) {
        HSSFFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            HSSFFont cf = null;
            int i = 0;
            while (i < this.loadedFonts.size()) {
                cf = (HSSFFont)this.loadedFonts.get(i);
                if (cf.getFontName().equals(font.getFontName()) && cf.getColor() == forecolor && cf.getFontHeight() == (short)(font.getSize() * 19) && (cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) && cf.getStrikeout() == font.isStrikeThrough() && (cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) && cf.getItalic() == font.isItalic()) {
                    cellFont = cf;
                    break;
                }
                ++i;
            }
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(font.getFontName());
            cellFont.setColor(forecolor);
            cellFont.setFontHeight((short)(font.getSize() * 19));
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    private HSSFCellStyle getLoadedCellStyle(short backcolor, short horizontalAlignment, short verticalAlignment, HSSFFont font) {
        HSSFCellStyle cellStyle = null;
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0) {
            HSSFCellStyle cs = null;
            int i = 0;
            while (i < this.loadedCellStyles.size()) {
                cs = (HSSFCellStyle)this.loadedCellStyles.get(i);
                if (cs.getFillForegroundColor() == backcolor && cs.getAlignment() == horizontalAlignment && cs.getVerticalAlignment() == verticalAlignment && cs.getFontIndex() == font.getIndex()) {
                    cellStyle = cs;
                    break;
                }
                ++i;
            }
        }
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(backcolor);
            cellStyle.setFillPattern((short)1);
            cellStyle.setAlignment(horizontalAlignment);
            cellStyle.setVerticalAlignment(verticalAlignment);
            cellStyle.setFont(font);
            cellStyle.setWrapText(true);
            this.loadedCellStyles.add(cellStyle);
        }
        return cellStyle;
    }
}

