/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.util;

import dori.jasper.engine.JRException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class JRLoader {
    static /* synthetic */ Class class$dori$jasper$engine$util$JRLoader;

    public static Object loadObject(String fileName) throws JRException {
        return JRLoader.loadObject(new File(fileName));
    }

    public static Object loadObject(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        Object obj = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            obj = ois.readObject();
            ois.close();
            fis.close();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from file : " + file, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from file : " + file, e);
        }
        return obj;
    }

    public static Object loadObject(URL url) throws JRException {
        Object obj = null;
        try {
            InputStream is = url.openStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            obj = ois.readObject();
            ois.close();
            is.close();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from URL : " + url, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from URL : " + url, e);
        }
        return obj;
    }

    public static Object loadObject(InputStream is) throws JRException {
        Object obj = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            obj = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from InputStream", e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from InputStream", e);
        }
        return obj;
    }

    public static Object loadObjectFromLocation(String location) throws JRException {
        try {
            URL url = new URL(location);
            return JRLoader.loadObject(url);
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists() && file.isFile()) {
                return JRLoader.loadObject(file);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(location);
            if (url == null) {
                classLoader = (class$dori$jasper$engine$util$JRLoader == null ? (class$dori$jasper$engine$util$JRLoader = JRLoader.class$("dori.jasper.engine.util.JRLoader")) : class$dori$jasper$engine$util$JRLoader).getClassLoader();
                url = classLoader.getResource(location);
            }
            if (url != null) {
                return JRLoader.loadObject(url);
            }
            throw new JRException("Could not load object from location : " + location);
        }
    }

    public static byte[] loadBytes(File file) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = fis.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
            baos.close();
            fis.close();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data : " + file, e);
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(URL url) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            InputStream is = url.openStream();
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
            baos.close();
            is.close();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data : " + url, e);
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(InputStream is) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data from input stream.", e);
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytesFromLocation(String location) throws JRException {
        try {
            URL url = new URL(location);
            return JRLoader.loadBytes(url);
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists() && file.isFile()) {
                return JRLoader.loadBytes(file);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(location);
            if (url == null) {
                classLoader = (class$dori$jasper$engine$util$JRLoader == null ? (class$dori$jasper$engine$util$JRLoader = JRLoader.class$("dori.jasper.engine.util.JRLoader")) : class$dori$jasper$engine$util$JRLoader).getClassLoader();
                url = classLoader.getResource(location);
            }
            if (url != null) {
                return JRLoader.loadBytes(url);
            }
            throw new JRException("Byte data not found at location : " + location);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

