/*
 * Band.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 12 febbraio 2003, 20.26
 */

package it.businesslogic.ireport;

public class Band
{
	private Report parent;
	private String name="";
	private String printWhenExpression="";
	private int height=0;
	
	public Band( Report parent, String name, int height)
	{
		this.parent = parent;
		this.name = name;
		this.height = height;
	}
	
	public String toString()
	{
		return this.name;
	}
	public int getBandYLocation()
	{
		return parent.getBandYLocation(this);
	}
	public int getUsableWidth()
	{
		return parent.getWidth() - parent.getLeftMargin() - parent.getRightMargin();
	}
        
        /** Getter for property height.
         * @return Value of property height.
         *
         */
        public int getHeight() {
            return height;
        }
        
        /** Setter for property height.
         * @param height New value of property height.
         *
         */
        public void setHeight(int height) {
            this.height = height;
        }
        
        /** Getter for property name.
         * @return Value of property name.
         *
         */
        public java.lang.String getName() {
            return name;
        }
        
        /** Setter for property name.
         * @param name New value of property name.
         *
         */
        public void setName(java.lang.String name) {
            this.name = name;
        }
        
        /** Getter for property parent.
         * @return Value of property parent.
         *
         */
        public it.businesslogic.ireport.Report getParent() {
            return parent;
        }
        
        /** Setter for property parent.
         * @param parent New value of property parent.
         *
         */
        public void setParent(it.businesslogic.ireport.Report parent) {
            this.parent = parent;
        }
        
        /** Getter for property printWhenExpression.
         * @return Value of property printWhenExpression.
         *
         */
        public java.lang.String getPrintWhenExpression() {
            return printWhenExpression;
        }
        
        /** Setter for property printWhenExpression.
         * @param printWhenExpression New value of property printWhenExpression.
         *
         */
        public void setPrintWhenExpression(java.lang.String printWhenExpression) {
            this.printWhenExpression = printWhenExpression;
        }
        
}
