/*
 * ReportListenerElementsSelectionEvent.java
 *
 * Created on 17 giugno 2003, 1.12
 */

package it.businesslogic.ireport.gui.event;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;
/**
 * Save all info required by a ReportElementChangedEvent
 * Return the band changed/removed/added
 * @author  Administrator
 */
public class ReportBandChangedEvent {
    
    private JReportFrame jReportFrame;
    /**
     *  The band was removed
     */
    public static final int REMOVED = 1;
    /**
     *  An band was added
     */
    public static final int ADDED   = 2;
    /**
     *  The band was changed
     */
    public static final int CHANGED = 3;

    /**
     *  The band that is changed/removed/added
     */
    private Band band;
    
    /**
     *  The type of the element
     */
    private int type = 0;
    /** Creates a new instance of ReportBandChangedEvent */
    public ReportBandChangedEvent(JReportFrame jReportFrame, Band band, int type) {
        this.jReportFrame =jReportFrame;
        this.band = band;
        this.type = type;
    }
    
    /** Getter for property band.
     * @return Value of property band.
     *
     */
    public Band getBand() {
        return band;
    }
    
    /** Setter for property selectedElements.
     * @param selectedElements New value of property selectedElements.
     *
     */
    public void setBand(Band band) {
        this.band = band;
    }
    
    /** Getter for property type.
     *  Type can assume 3 values:
     *  REMOVED, ADDED, CHANGED 
     *  @return Value of property type.
     *  
     */
    public int getType() {
        return type;
    }
    
    /** Setter for property type.
     * @param type New value of property type.
     *
     */
    public void setType(int type) {
        this.type = type;
    }
    
    /** Getter for property jReportFrame.
     * @return Value of property jReportFrame.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame() {
        return jReportFrame;
    }
    
    /** Setter for property jReportFrame.
     * @param jReportFrame New value of property jReportFrame.
     *
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }
    
}
