/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;

public class RowRecordsAggregate
extends Record {
    int firstrow = -1;
    int lastrow = -1;
    Map records = new TreeMap();
    int size = 0;

    public void insertRow(RowRecord row) {
        this.size += row.getRecordSize();
        this.records.put(row, row);
        if (row.getRowNumber() < this.firstrow || this.firstrow == -1) {
            this.firstrow = row.getRowNumber();
        }
        if (row.getRowNumber() > this.lastrow || this.lastrow == -1) {
            this.lastrow = row.getRowNumber();
        }
    }

    public void removeRow(RowRecord row) {
        this.size -= row.getRecordSize();
        this.records.remove(row);
    }

    public RowRecord getRow(int rownum) {
        RowRecord row = new RowRecord();
        row.setRowNumber((short)rownum);
        return (RowRecord)this.records.get(row);
    }

    public int getPhysicalNumberOfRows() {
        return this.records.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public int serialize(int offset, byte[] data) {
        Iterator itr = this.records.values().iterator();
        int pos = offset;
        while (itr.hasNext()) {
            pos += ((Record)itr.next()).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        return this.size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }

    public Object clone() {
        RowRecordsAggregate rec = new RowRecordsAggregate();
        Iterator rowIter = this.getIterator();
        while (rowIter.hasNext()) {
            RowRecord row = (RowRecord)((RowRecord)rowIter.next()).clone();
            rec.insertRow(row);
        }
        return rec;
    }
}

