/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import org.jfree.util.UnitType;

public class RectangleInsets {
    private UnitType unitType;
    private double top;
    private double bottom;
    private double left;
    private double right;

    public RectangleInsets(UnitType unitType, double top, double bottom, double left, double right) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'unitType' argument.");
        }
        this.unitType = unitType;
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public Rectangle2D createInsetRectangle(Rectangle2D base) {
        return this.createInsetRectangle(base, true, true);
    }

    public Rectangle2D createInsetRectangle(Rectangle2D base, boolean horizontal, boolean vertical) {
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (vertical) {
            topMargin = this.calculateTopMargin(base.getHeight());
            bottomMargin = this.calculateBottomMargin(base.getHeight());
        }
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        if (horizontal) {
            leftMargin = this.calculateLeftMargin(base.getWidth());
            rightMargin = this.calculateRightMargin(base.getWidth());
        }
        return new Rectangle2D.Double(base.getX() + leftMargin, base.getY() + topMargin, base.getWidth() - leftMargin - rightMargin, base.getHeight() - topMargin - bottomMargin);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D base) {
        return this.createOutsetRectangle(base, true, true);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D base, boolean horizontal, boolean vertical) {
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (vertical) {
            topMargin = this.calculateTopMargin(base.getHeight());
            bottomMargin = this.calculateBottomMargin(base.getHeight());
        }
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        if (horizontal) {
            leftMargin = this.calculateLeftMargin(base.getWidth());
            rightMargin = this.calculateRightMargin(base.getWidth());
        }
        return new Rectangle2D.Double(base.getX() - leftMargin, base.getY() - topMargin, base.getWidth() + leftMargin + rightMargin, base.getHeight() + topMargin + bottomMargin);
    }

    public double calculateTopMargin(double height) {
        double result = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.top * height;
        }
        return result;
    }

    public double calculateBottomMargin(double height) {
        double result = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.bottom * height;
        }
        return result;
    }

    public double calculateLeftMargin(double width) {
        double result = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.left * width;
        }
        return result;
    }

    public double calculateRightMargin(double width) {
        double result = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.right * width;
        }
        return result;
    }
}

