/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.fill.JRComparableIncrementerFactory;
import dori.jasper.engine.fill.JRDefaultIncrementerFactory;
import dori.jasper.engine.fill.JRDoubleAverageIncrementer;
import dori.jasper.engine.fill.JRDoubleCountIncrementer;
import dori.jasper.engine.fill.JRDoubleStandardDeviationIncrementer;
import dori.jasper.engine.fill.JRDoubleSumIncrementer;
import dori.jasper.engine.fill.JRDoubleVarianceIncrementer;
import dori.jasper.engine.fill.JRIncrementer;
import dori.jasper.engine.fill.JRIncrementerFactory;

public class JRDoubleIncrementerFactory
implements JRIncrementerFactory {
    protected static final Double ZERO = new Double(0.0);
    private static JRDoubleIncrementerFactory mainInstance = new JRDoubleIncrementerFactory();

    private JRDoubleIncrementerFactory() {
    }

    public static JRDoubleIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRDoubleCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRDoubleSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRDoubleAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRDoubleStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRDoubleVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

