/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.Image;

public class BarcodePostnet
extends Barcode {
    static byte[][] BARS = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String string) {
        int n;
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            n = string.charAt(i) - 48;
            n2 += n;
        }
        string = string + (char)((10 - n2 % 10) % 10 + 48);
        byte[] byArray = new byte[string.length() * 5 + 2];
        byArray[0] = 1;
        byArray[byArray.length - 1] = 1;
        for (n = 0; n < string.length(); ++n) {
            int n3 = string.charAt(n) - 48;
            System.arraycopy(BARS[n3], 0, byArray, n * 5 + 1, 5);
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f, this.barHeight);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        float f = 0.0f;
        for (int i = 0; i < byArray.length; ++i) {
            pdfContentByte.rectangle(f, 0.0f, this.x - this.inkSpreading, byArray[i] == by ? this.barHeight : this.size);
            f += this.n;
        }
        pdfContentByte.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        throw new UnsupportedOperationException("Not supported with postnet.");
    }
}

