/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.data.XYDataset;
import org.jfree.util.ObjectUtils;

public class AbstractXYItemLabelGenerator
implements Cloneable,
Serializable {
    public static final String DEFAULT_TOOLTIP_FORMAT = "{0}: ({1}, {2})";
    public static final String DEFAULT_ITEM_LABEL_FORMAT = "{2}";
    private String toolTipFormat;
    private String itemLabelFormat;
    private NumberFormat xFormat;
    private DateFormat xDateFormat;
    private NumberFormat yFormat;

    public AbstractXYItemLabelGenerator() {
        this(DEFAULT_TOOLTIP_FORMAT, DEFAULT_ITEM_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public AbstractXYItemLabelGenerator(String toolTipFormat, String itemLabelFormat, NumberFormat xFormat, NumberFormat yFormat) {
        if (toolTipFormat == null) {
            throw new IllegalArgumentException("Null 'toolTipFormat' argument.");
        }
        if (itemLabelFormat == null) {
            throw new IllegalArgumentException("Null 'itemLabelFormat' argument.");
        }
        if (xFormat == null) {
            throw new IllegalArgumentException("Null 'xFormat' argument.");
        }
        if (yFormat == null) {
            throw new IllegalArgumentException("Null 'yFormat' argument.");
        }
        this.toolTipFormat = toolTipFormat;
        this.itemLabelFormat = itemLabelFormat;
        this.xFormat = xFormat;
        this.yFormat = yFormat;
    }

    public AbstractXYItemLabelGenerator(String toolTipFormat, String itemLabelFormat, DateFormat xFormat, NumberFormat yFormat) {
        this(toolTipFormat, itemLabelFormat, NumberFormat.getInstance(), yFormat);
        this.xDateFormat = xFormat;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public DateFormat getXDateFormat() {
        return this.xDateFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        String result = null;
        if (dataset != null) {
            Object[] items = this.createItemArray(dataset, series, item);
            result = MessageFormat.format(this.toolTipFormat, items);
        }
        return result;
    }

    public String generateItemLabel(XYDataset dataset, int series, int item) {
        String result = null;
        if (dataset != null) {
            Object[] items = this.createItemArray(dataset, series, item);
            result = MessageFormat.format(this.itemLabelFormat, items);
        }
        return result;
    }

    protected Object[] createItemArray(XYDataset dataset, int series, int item) {
        Object[] result = new Object[3];
        result[0] = dataset.getSeriesName(series);
        Number x = dataset.getXValue(series, item);
        result[1] = this.xDateFormat != null ? this.xDateFormat.format(new Date(x.longValue())) : this.xFormat.format(x);
        Number y = dataset.getYValue(series, item);
        result[2] = this.yFormat.format(y);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractXYItemLabelGenerator) {
            AbstractXYItemLabelGenerator generator = (AbstractXYItemLabelGenerator)obj;
            if (!this.toolTipFormat.equals(generator.toolTipFormat)) {
                return false;
            }
            if (!this.itemLabelFormat.equals(generator.itemLabelFormat)) {
                return false;
            }
            if (!this.xFormat.equals(generator.xFormat)) {
                return false;
            }
            if (!ObjectUtils.equal((Object)this.xDateFormat, (Object)generator.xDateFormat)) {
                return false;
            }
            return this.yFormat.equals(generator.yFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXYItemLabelGenerator clone = (AbstractXYItemLabelGenerator)super.clone();
        if (this.xFormat != null) {
            clone.xFormat = (NumberFormat)this.xFormat.clone();
        }
        if (this.yFormat != null) {
            clone.yFormat = (NumberFormat)this.yFormat.clone();
        }
        return clone;
    }
}

