/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Spacer;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class XYPlot
extends Plot
implements ValueAxisPlot,
RendererChangeListener,
Cloneable,
Serializable {
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private Spacer axisOffset;
    private ValueAxis domainAxis;
    private AxisLocation domainAxisLocation;
    private ObjectList secondaryDomainAxes;
    private ObjectList secondaryDomainAxisLocations;
    private ValueAxis rangeAxis;
    private AxisLocation rangeAxisLocation;
    private ObjectList secondaryRangeAxes;
    private ObjectList secondaryRangeAxisLocations;
    private XYDataset dataset;
    private ObjectList secondaryDatasets;
    private ObjectList secondaryDatasetDomainAxisMap;
    private ObjectList secondaryDatasetRangeAxisMap;
    private XYItemRenderer renderer;
    private ObjectList secondaryRenderers;
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private transient List foregroundDomainMarkers;
    private transient List backgroundDomainMarkers;
    private transient Map secondaryForegroundDomainMarkers;
    private transient Map secondaryBackgroundDomainMarkers;
    private transient List foregroundRangeMarkers;
    private transient List backgroundRangeMarkers;
    private transient Map secondaryForegroundRangeMarkers;
    private transient Map secondaryBackgroundRangeMarkers;
    private List annotations;
    private transient Paint domainTickBandPaint;
    private transient Paint rangeTickBandPaint;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.STANDARD;
    private int weight = 1;
    static Logger logger = Logger.getLogger((Class)(class$org$jfree$chart$plot$XYPlot == null ? (class$org$jfree$chart$plot$XYPlot = XYPlot.class$("org.jfree.chart.plot.XYPlot")) : class$org$jfree$chart$plot$XYPlot));
    static /* synthetic */ Class class$org$jfree$chart$plot$XYPlot;

    public XYPlot() {
        this(null, null, null, null);
    }

    public XYPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.axisOffset = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
        this.secondaryDomainAxes = new ObjectList();
        this.secondaryDomainAxisLocations = new ObjectList();
        this.secondaryRangeAxes = new ObjectList();
        this.secondaryRangeAxisLocations = new ObjectList();
        this.secondaryDatasets = new ObjectList();
        this.secondaryDatasetDomainAxisMap = new ObjectList();
        this.secondaryDatasetRangeAxisMap = new ObjectList();
        this.secondaryRenderers = new ObjectList();
        this.dataset = dataset;
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.renderer = renderer;
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.domainAxis = domainAxis;
        if (domainAxis != null) {
            domainAxis.setPlot(this);
            domainAxis.addChangeListener(this);
        }
        this.domainAxisLocation = AxisLocation.BOTTOM_OR_LEFT;
        this.rangeAxis = rangeAxis;
        if (rangeAxis != null) {
            rangeAxis.setPlot(this);
            rangeAxis.addChangeListener(this);
        }
        this.rangeAxisLocation = AxisLocation.TOP_OR_LEFT;
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundDomainMarkers = new ArrayList();
        this.backgroundDomainMarkers = new ArrayList();
        this.secondaryForegroundDomainMarkers = new HashMap();
        this.secondaryBackgroundDomainMarkers = new HashMap();
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
    }

    public String getPlotType() {
        return localizationResources.getString("XY_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("XYPlot.setOrientation(...): null not allowed.");
        }
        if (orientation != this.orientation) {
            this.orientation = orientation;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Spacer getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(Spacer offset) {
        this.axisOffset = offset;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueAxis getDomainAxis() {
        Plot parent;
        ValueAxis result = this.domainAxis;
        if (result == null && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot xy = (XYPlot)parent;
            result = xy.getDomainAxis();
        }
        return result;
    }

    public void setDomainAxis(ValueAxis axis) {
        if (axis != null) {
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        if (this.domainAxis != null) {
            this.domainAxis.removeChangeListener(this);
        }
        this.domainAxis = axis;
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public void setDomainAxisLocation(AxisLocation location) {
        this.setDomainAxisLocation(location, true);
    }

    public void setDomainAxisLocation(AxisLocation location, boolean notify) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (location != this.domainAxisLocation) {
            this.domainAxisLocation = location;
            if (notify) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.domainAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryDomainAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.secondaryDomainAxes.size()) {
            result = (ValueAxis)this.secondaryDomainAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot xy = (XYPlot)parent;
            result = xy.getSecondaryDomainAxis(index);
        }
        return result;
    }

    public void setSecondaryDomainAxis(int index, ValueAxis axis) {
        ValueAxis existing = this.getSecondaryDomainAxis(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.secondaryDomainAxes.set(index, (Object)axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getSecondaryDomainAxisCount() {
        return this.secondaryDomainAxes.size();
    }

    public void clearSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            ValueAxis axis = (ValueAxis)this.secondaryDomainAxes.get(i);
            if (axis == null) continue;
            axis.removeChangeListener(this);
        }
        this.secondaryDomainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            ValueAxis axis = (ValueAxis)this.secondaryDomainAxes.get(i);
            if (axis == null) continue;
            axis.configure();
        }
    }

    public AxisLocation getSecondaryDomainAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.secondaryDomainAxisLocations.size()) {
            result = (AxisLocation)this.secondaryDomainAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.domainAxisLocation);
        }
        return result;
    }

    public void setSecondaryDomainAxisLocation(int index, AxisLocation location) {
        this.secondaryDomainAxisLocations.set(index, (Object)location);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryDomainAxisEdge(int index) {
        AxisLocation location = this.getSecondaryDomainAxisLocation(index);
        RectangleEdge result = Plot.resolveDomainAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite((RectangleEdge)this.getDomainAxisEdge());
        }
        return result;
    }

    public ValueAxis getRangeAxis() {
        Plot parent;
        ValueAxis result = this.rangeAxis;
        if (result == null && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot xy = (XYPlot)parent;
            result = xy.getRangeAxis();
        }
        return result;
    }

    public void setRangeAxis(ValueAxis axis) {
        if (axis != null) {
            axis.setPlot(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.removeChangeListener(this);
        }
        this.rangeAxis = axis;
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public void setRangeAxisLocation(AxisLocation location) {
        this.setRangeAxisLocation(location, true);
    }

    public void setRangeAxisLocation(AxisLocation location, boolean notify) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        if (location != this.rangeAxisLocation) {
            this.rangeAxisLocation = location;
            if (notify) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.rangeAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryRangeAxis(int index) {
        Plot parent;
        ValueAxis result = null;
        if (index < this.secondaryRangeAxes.size()) {
            result = (ValueAxis)this.secondaryRangeAxes.get(index);
        }
        if (result == null && (parent = this.getParent()) instanceof XYPlot) {
            XYPlot xy = (XYPlot)parent;
            result = xy.getSecondaryRangeAxis(index);
        }
        return result;
    }

    public void setSecondaryRangeAxis(int index, ValueAxis axis) {
        ValueAxis existing = this.getSecondaryRangeAxis(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.secondaryRangeAxes.set(index, (Object)axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getSecondaryRangeAxisCount() {
        return this.secondaryRangeAxes.size();
    }

    public void clearSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis axis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (axis == null) continue;
            axis.removeChangeListener(this);
        }
        this.secondaryRangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis axis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (axis == null) continue;
            axis.configure();
        }
    }

    public AxisLocation getSecondaryRangeAxisLocation(int index) {
        AxisLocation result = null;
        if (index < this.secondaryRangeAxisLocations.size()) {
            result = (AxisLocation)this.secondaryRangeAxisLocations.get(index);
        }
        if (result == null) {
            result = AxisLocation.getOpposite(this.rangeAxisLocation);
        }
        return result;
    }

    public void setSecondaryRangeAxisLocation(int index, AxisLocation location) {
        this.secondaryRangeAxisLocations.set(index, (Object)location);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryRangeAxisEdge(int index) {
        AxisLocation location = this.getSecondaryRangeAxisLocation(index);
        RectangleEdge result = Plot.resolveRangeAxisLocation(location, this.orientation);
        if (result == null) {
            result = RectangleEdge.opposite((RectangleEdge)this.getRangeAxisEdge());
        }
        return result;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset dataset) {
        XYDataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public XYDataset getSecondaryDataset(int index) {
        XYDataset result = null;
        if (this.secondaryDatasets.size() > index) {
            result = (XYDataset)this.secondaryDatasets.get(index);
        }
        return result;
    }

    public int getSecondaryDatasetCount() {
        return this.secondaryDatasets.size();
    }

    public void setSecondaryDataset(int index, XYDataset dataset) {
        XYDataset existing = (XYDataset)this.secondaryDatasets.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.secondaryDatasets.set(index, (Object)dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        if (index >= this.secondaryDatasetRangeAxisMap.size()) {
            this.secondaryDatasetRangeAxisMap.set(index, null);
        }
        if (index >= this.secondaryDatasetDomainAxisMap.size()) {
            this.secondaryDatasetDomainAxisMap.set(index, null);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public void mapSecondaryDatasetToDomainAxis(int index, Integer key) {
        this.secondaryDatasetDomainAxisMap.set(index, (Object)key);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public void mapSecondaryDatasetToRangeAxis(int index, Integer key) {
        this.secondaryDatasetRangeAxisMap.set(index, (Object)key);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public XYItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(XYItemRenderer renderer) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = renderer;
        if (renderer != null) {
            renderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public XYItemRenderer getSecondaryRenderer(int index) {
        XYItemRenderer result = null;
        if (this.secondaryRenderers.size() > index) {
            result = (XYItemRenderer)this.secondaryRenderers.get(index);
        }
        return result;
    }

    public void setSecondaryRenderer(int index, XYItemRenderer renderer) {
        XYItemRenderer existing = this.getSecondaryRenderer(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.secondaryRenderers.set(index, (Object)renderer);
        if (renderer != null) {
            renderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = order;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public XYItemRenderer getRendererForDataset(XYDataset d) {
        XYItemRenderer result = null;
        if (this.dataset == d) {
            result = this.renderer;
        } else {
            for (int i = 0; i < this.secondaryDatasets.size(); ++i) {
                if (this.secondaryDatasets.get(i) != d) continue;
                result = (XYItemRenderer)this.secondaryRenderers.get(i);
                break;
            }
        }
        return result;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean visible) {
        if (this.domainGridlinesVisible != visible) {
            this.domainGridlinesVisible = visible;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean visible) {
        if (this.rangeGridlinesVisible != visible) {
            this.rangeGridlinesVisible = visible;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainTickBandPaint() {
        return this.domainTickBandPaint;
    }

    public void setDomainTickBandPaint(Paint paint) {
        this.domainTickBandPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeTickBandPaint() {
        return this.rangeTickBandPaint;
    }

    public void setRangeTickBandPaint(Paint paint) {
        this.rangeTickBandPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(Marker marker, Layer layer) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        if (layer == Layer.FOREGROUND) {
            if (this.foregroundDomainMarkers == null) {
                this.foregroundDomainMarkers = new ArrayList();
            }
            this.foregroundDomainMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        } else if (layer == Layer.BACKGROUND) {
            if (this.backgroundDomainMarkers == null) {
                this.backgroundDomainMarkers = new ArrayList();
            }
            this.backgroundDomainMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void clearDomainMarkers() {
        if (this.foregroundDomainMarkers != null) {
            this.foregroundDomainMarkers.clear();
        }
        if (this.backgroundDomainMarkers != null) {
            this.backgroundDomainMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addSecondaryDomainMarker(Marker marker) {
        this.addSecondaryDomainMarker(0, marker, Layer.FOREGROUND);
    }

    public void addSecondaryDomainMarker(int index, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.secondaryForegroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.secondaryForegroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.secondaryBackgroundDomainMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.secondaryBackgroundDomainMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        if (layer == Layer.FOREGROUND) {
            if (this.foregroundRangeMarkers == null) {
                this.foregroundRangeMarkers = new ArrayList();
            }
            this.foregroundRangeMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        } else if (layer == Layer.BACKGROUND) {
            if (this.backgroundRangeMarkers == null) {
                this.backgroundRangeMarkers = new ArrayList();
            }
            this.backgroundRangeMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void clearRangeMarkers() {
        if (this.foregroundRangeMarkers != null) {
            this.foregroundRangeMarkers.clear();
        }
        if (this.backgroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addSecondaryRangeMarker(Marker marker) {
        this.addSecondaryRangeMarker(0, marker, Layer.FOREGROUND);
    }

    public void addSecondaryRangeMarker(int index, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.secondaryForegroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> markers = (ArrayList<Marker>)this.secondaryBackgroundRangeMarkers.get(new Integer(index));
            if (markers == null) {
                markers = new ArrayList<Marker>();
                this.secondaryBackgroundRangeMarkers.put(new Integer(index), markers);
            }
            markers.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeMarkers(int index) {
        Integer key = new Integer(index);
        Collection markers = (Collection)this.secondaryBackgroundRangeMarkers.get(key);
        if (markers != null) {
            markers.clear();
        }
        if ((markers = (Collection)this.secondaryForegroundRangeMarkers.get(key)) != null) {
            markers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addAnnotation(XYAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    protected AxisSpace calculateAxisSpace(Graphics2D g2, Rectangle2D plotArea) {
        AxisSpace space = new AxisSpace();
        space = this.calculateDomainAxisSpace(g2, plotArea, space);
        space = this.calculateRangeAxisSpace(g2, plotArea, space);
        return space;
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D g2, Rectangle2D plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    space.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                space.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block5;
            }
            if (this.domainAxis != null) {
                space = this.domainAxis.reserveSpace(g2, this, plotArea, this.getDomainAxisEdge(), space);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                ValueAxis secondaryDomainAxis = this.getSecondaryDomainAxis(i);
                if (secondaryDomainAxis == null) continue;
                RectangleEdge edge = this.getSecondaryDomainAxisEdge(i);
                space = ((Axis)secondaryDomainAxis).reserveSpace(g2, this, plotArea, edge, space);
            }
        }
        return space;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D g2, Rectangle2D plotArea, AxisSpace space) {
        block5: {
            block3: {
                block4: {
                    if (space == null) {
                        space = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    space.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                space.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                space.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            ValueAxis rangeAxis1 = this.rangeAxis;
            if (rangeAxis1 != null) {
                space = ((Axis)rangeAxis1).reserveSpace(g2, this, plotArea, this.getRangeAxisEdge(), space);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis secondaryRangeAxis = this.getSecondaryRangeAxis(i);
                if (secondaryRangeAxis == null) continue;
                RectangleEdge edge = this.getSecondaryRangeAxisEdge(i);
                space = ((Axis)secondaryRangeAxis).reserveSpace(g2, this, plotArea, edge, space);
            }
        }
        return space;
    }

    public void draw(Graphics2D g2, Rectangle2D area, PlotState parentState, PlotRenderingInfo state) {
        this.draw(g2, area, null, parentState, state);
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        Insets insets;
        boolean b2;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering draw() method, plot area = " + area.toString()));
        }
        boolean b1 = area.getWidth() <= 10.0;
        boolean bl = b2 = area.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (info != null) {
            info.setPlotArea(area);
        }
        if ((insets = this.getInsets()) != null) {
            area.setRect(area.getX() + (double)insets.left, area.getY() + (double)insets.top, area.getWidth() - (double)insets.left - (double)insets.right, area.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace space = this.calculateAxisSpace(g2, area);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Calculated axis space = " + space.toString()));
        }
        Rectangle2D dataArea = space.shrink(area, null);
        this.axisOffset.trim(dataArea);
        if (info != null) {
            info.setDataArea(dataArea);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Data area = " + dataArea.toString()));
        }
        this.drawBackground(g2, dataArea);
        Map axisStateMap = this.drawAxes(g2, area, dataArea, info);
        if (anchor != null && !dataArea.contains(anchor)) {
            anchor = null;
        }
        CrosshairState crosshairState = new CrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(anchor);
        crosshairState.setCrosshairX(this.getDomainCrosshairValue());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        if (this.renderer != null) {
            int i;
            int i2;
            AxisState rangeAxisState;
            Shape originalClip = g2.getClip();
            Composite originalComposite = g2.getComposite();
            g2.clip(dataArea);
            g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            AxisState domainAxisState = (AxisState)axisStateMap.get(this.getDomainAxis());
            if (domainAxisState == null && parentState != null) {
                domainAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getDomainAxis());
            }
            if (domainAxisState != null) {
                this.drawDomainTickBands(g2, dataArea, domainAxisState.getTicks());
                this.drawDomainGridlines(g2, dataArea, domainAxisState.getTicks());
            }
            if ((rangeAxisState = (AxisState)axisStateMap.get(this.getRangeAxis())) == null && parentState != null) {
                rangeAxisState = (AxisState)parentState.getSharedAxisStates().get(this.getRangeAxis());
            }
            if (rangeAxisState != null) {
                this.drawRangeTickBands(g2, dataArea, rangeAxisState.getTicks());
                this.drawRangeGridlines(g2, dataArea, rangeAxisState.getTicks());
            }
            for (i2 = 0; i2 < this.secondaryDomainAxes.size(); ++i2) {
                this.drawSecondaryDomainMarkers(g2, dataArea, i2, Layer.BACKGROUND);
            }
            for (i2 = 0; i2 < this.secondaryRangeAxes.size(); ++i2) {
                this.drawSecondaryRangeMarkers(g2, dataArea, i2, Layer.BACKGROUND);
            }
            this.drawDomainMarkers(g2, dataArea, Layer.BACKGROUND);
            this.drawRangeMarkers(g2, dataArea, Layer.BACKGROUND);
            DatasetRenderingOrder order = this.getDatasetRenderingOrder();
            if (order == DatasetRenderingOrder.STANDARD) {
                this.render2(g2, dataArea, info, crosshairState);
                this.render(g2, dataArea, info, crosshairState);
            } else if (order == DatasetRenderingOrder.REVERSE) {
                this.render(g2, dataArea, info, crosshairState);
                this.render2(g2, dataArea, info, crosshairState);
            }
            for (i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                this.drawSecondaryDomainMarkers(g2, dataArea, i, Layer.FOREGROUND);
            }
            for (i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                this.drawSecondaryRangeMarkers(g2, dataArea, i, Layer.FOREGROUND);
            }
            this.drawDomainMarkers(g2, dataArea, Layer.FOREGROUND);
            this.drawRangeMarkers(g2, dataArea, Layer.FOREGROUND);
            this.drawAnnotations(g2, dataArea, info);
            g2.setClip(originalClip);
            g2.setComposite(originalComposite);
        }
        this.drawOutline(g2, dataArea);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Leaving draw() method.");
        }
    }

    public void drawDomainTickBands(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        Paint bandPaint = this.getDomainTickBandPaint();
        if (bandPaint != null) {
            boolean fillBand = false;
            ValueAxis xAxis = this.getDomainAxis();
            double previous = xAxis.getLowerBound();
            Iterator iterator = ticks.iterator();
            while (iterator.hasNext()) {
                ValueTick tick = (ValueTick)iterator.next();
                double current = tick.getValue();
                if (fillBand) {
                    this.renderer.fillDomainGridBand(g2, this, xAxis, dataArea, previous, current);
                }
                previous = current;
                fillBand = !fillBand;
            }
            double end = xAxis.getUpperBound();
            if (fillBand) {
                this.renderer.fillDomainGridBand(g2, this, xAxis, dataArea, previous, end);
            }
        }
    }

    public void drawRangeTickBands(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        Paint bandPaint = this.getRangeTickBandPaint();
        if (bandPaint != null) {
            boolean fillBand = false;
            ValueAxis axis = this.getRangeAxis();
            double previous = axis.getLowerBound();
            Iterator iterator = ticks.iterator();
            while (iterator.hasNext()) {
                ValueTick tick = (ValueTick)iterator.next();
                double current = tick.getValue();
                if (fillBand) {
                    this.renderer.fillRangeGridBand(g2, this, axis, dataArea, previous, current);
                }
                previous = current;
                fillBand = !fillBand;
            }
            double end = axis.getUpperBound();
            if (fillBand) {
                this.renderer.fillRangeGridBand(g2, this, axis, dataArea, previous, end);
            }
        }
    }

    protected Map drawAxes(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, PlotRenderingInfo plotState) {
        AxisState info;
        ValueAxis axis;
        ValueAxis secondaryAxis;
        int index;
        AxisCollection axisCollection = new AxisCollection();
        if (this.domainAxis != null) {
            axisCollection.add(this.domainAxis, this.getDomainAxisEdge());
        }
        if (this.rangeAxis != null) {
            axisCollection.add(this.rangeAxis, this.getRangeAxisEdge());
        }
        for (index = 0; index < this.secondaryDomainAxes.size(); ++index) {
            secondaryAxis = (ValueAxis)this.secondaryDomainAxes.get(index);
            if (secondaryAxis == null) continue;
            axisCollection.add(secondaryAxis, this.getSecondaryDomainAxisEdge(index));
        }
        for (index = 0; index < this.secondaryRangeAxes.size(); ++index) {
            secondaryAxis = (ValueAxis)this.secondaryRangeAxes.get(index);
            if (secondaryAxis == null) continue;
            axisCollection.add(secondaryAxis, this.getSecondaryRangeAxisEdge(index));
        }
        HashMap<ValueAxis, AxisState> axisStateMap = new HashMap<ValueAxis, AxisState>();
        double cursor = dataArea.getMinY() - this.axisOffset.getTopSpace(dataArea.getHeight());
        Iterator iterator = axisCollection.getAxesAtTop().iterator();
        while (iterator.hasNext()) {
            axis = (ValueAxis)iterator.next();
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.TOP, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        cursor = dataArea.getMaxY() + this.axisOffset.getBottomSpace(dataArea.getHeight());
        iterator = axisCollection.getAxesAtBottom().iterator();
        while (iterator.hasNext()) {
            axis = (ValueAxis)iterator.next();
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.BOTTOM, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        cursor = dataArea.getMinX() - this.axisOffset.getLeftSpace(dataArea.getWidth());
        iterator = axisCollection.getAxesAtLeft().iterator();
        while (iterator.hasNext()) {
            axis = (ValueAxis)iterator.next();
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.LEFT, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        cursor = dataArea.getMaxX() + this.axisOffset.getRightSpace(dataArea.getWidth());
        iterator = axisCollection.getAxesAtRight().iterator();
        while (iterator.hasNext()) {
            axis = (ValueAxis)iterator.next();
            info = axis.draw(g2, cursor, plotArea, dataArea, RectangleEdge.RIGHT, plotState);
            cursor = info.getCursor();
            axisStateMap.put(axis, info);
        }
        return axisStateMap;
    }

    public void render(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, CrosshairState crosshairState) {
        XYDataset data = this.getDataset();
        if (!DatasetUtilities.isEmptyOrNull(data)) {
            XYItemRendererState state = this.renderer.initialise(g2, dataArea, this, data, info);
            int passCount = this.renderer.getPassCount();
            ValueAxis xAxis = this.getDomainAxis();
            ValueAxis yAxis = this.getRangeAxis();
            for (int pass = 0; pass < passCount; ++pass) {
                int seriesCount = data.getSeriesCount();
                for (int series = 0; series < seriesCount; ++series) {
                    int itemCount = data.getItemCount(series);
                    for (int item = 0; item < itemCount; ++item) {
                        this.renderer.drawItem(g2, state, dataArea, info, this, xAxis, yAxis, data, series, item, crosshairState, pass);
                    }
                }
            }
            PlotOrientation orient = this.getOrientation();
            this.setDomainCrosshairValue(crosshairState.getCrosshairX(), false);
            if (this.isDomainCrosshairVisible()) {
                double x = this.getDomainCrosshairValue();
                Paint paint = this.getDomainCrosshairPaint();
                Stroke stroke = this.getDomainCrosshairStroke();
                if (orient == PlotOrientation.HORIZONTAL) {
                    this.drawHorizontalLine(g2, dataArea, x, stroke, paint);
                } else if (orient == PlotOrientation.VERTICAL) {
                    this.drawVerticalLine(g2, dataArea, x, stroke, paint);
                }
            }
            this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
            if (this.isRangeCrosshairVisible() && yAxis.getRange().contains(this.getRangeCrosshairValue())) {
                double y = this.getRangeCrosshairValue();
                Paint paint = this.getRangeCrosshairPaint();
                Stroke stroke = this.getRangeCrosshairStroke();
                if (orient == PlotOrientation.HORIZONTAL) {
                    this.drawVerticalLine(g2, dataArea, y, stroke, paint);
                } else if (orient == PlotOrientation.VERTICAL) {
                    this.drawHorizontalLine(g2, dataArea, y, stroke, paint);
                }
            }
        } else {
            this.drawNoDataMessage(g2, dataArea);
        }
    }

    public ValueAxis getSecondaryDomainAxisMappedToDataset(int index) {
        if (index >= this.getSecondaryDatasetCount()) {
            throw new IllegalArgumentException();
        }
        ValueAxis valueAxis = null;
        Integer axisIndex = (Integer)this.secondaryDatasetDomainAxisMap.get(index);
        valueAxis = axisIndex == null ? this.getDomainAxis() : this.getSecondaryDomainAxis(axisIndex);
        return valueAxis;
    }

    public ValueAxis getSecondaryRangeAxisMappedToDataset(int index) {
        if (index >= this.getSecondaryDatasetCount()) {
            throw new IllegalArgumentException();
        }
        ValueAxis valueAxis = null;
        Integer axisIndex = (Integer)this.secondaryDatasetRangeAxisMap.get(index);
        valueAxis = axisIndex == null ? this.getRangeAxis() : this.getSecondaryRangeAxis(axisIndex);
        return valueAxis;
    }

    public void render2(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, CrosshairState crosshairState) {
        for (int i = 0; i < this.getSecondaryDatasetCount(); ++i) {
            XYItemRenderer renderer2;
            ValueAxis axis;
            ValueAxis axis2;
            XYDataset dataset2 = this.getSecondaryDataset(i);
            if (DatasetUtilities.isEmptyOrNull(dataset2)) continue;
            ValueAxis xAxis = this.getDomainAxis();
            Integer key = (Integer)this.secondaryDatasetDomainAxisMap.get(i);
            if (key != null && (axis2 = this.getSecondaryDomainAxis(key)) != null) {
                xAxis = axis2;
            }
            ValueAxis yAxis = this.getRangeAxis();
            Integer key2 = (Integer)this.secondaryDatasetRangeAxisMap.get(i);
            if (key2 != null && (axis = this.getSecondaryRangeAxis(key2)) != null) {
                yAxis = axis;
            }
            if ((renderer2 = this.getSecondaryRenderer(i)) == null) {
                renderer2 = this.getRenderer();
            }
            XYItemRendererState state = renderer2.initialise(g2, dataArea, this, dataset2, info);
            int passCount = renderer2.getPassCount();
            for (int pass = 0; pass < passCount; ++pass) {
                int seriesCount = dataset2.getSeriesCount();
                for (int series = 0; series < seriesCount; ++series) {
                    int itemCount = dataset2.getItemCount(series);
                    for (int item = 0; item < itemCount; ++item) {
                        renderer2.drawItem(g2, state, dataArea, info, this, xAxis, yAxis, dataset2, series, item, crosshairState, pass);
                    }
                }
            }
        }
    }

    protected void drawDomainGridlines(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        if (this.renderer == null) {
            return;
        }
        if (this.isDomainGridlinesVisible()) {
            Stroke gridStroke = this.getDomainGridlineStroke();
            Paint gridPaint = this.getDomainGridlinePaint();
            if (gridStroke != null && gridPaint != null) {
                Iterator iterator = ticks.iterator();
                while (iterator.hasNext()) {
                    ValueTick tick = (ValueTick)iterator.next();
                    this.renderer.drawDomainGridLine(g2, this, this.getDomainAxis(), dataArea, tick.getValue());
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D g2, Rectangle2D dataArea, List ticks) {
        if (this.isRangeGridlinesVisible()) {
            ValueAxis axis;
            Stroke gridStroke = this.getRangeGridlineStroke();
            Paint gridPaint = this.getRangeGridlinePaint();
            if (gridStroke != null && gridPaint != null && (axis = this.getRangeAxis()) != null) {
                Iterator iterator = ticks.iterator();
                while (iterator.hasNext()) {
                    ValueTick tick = (ValueTick)iterator.next();
                    this.renderer.drawRangeGridLine(g2, this, this.getRangeAxis(), dataArea, tick.getValue());
                }
            }
        }
    }

    public void drawAnnotations(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        if (this.annotations != null) {
            Iterator iterator = this.annotations.iterator();
            while (iterator.hasNext()) {
                XYAnnotation annotation = (XYAnnotation)iterator.next();
                annotation.draw(g2, this, dataArea, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawDomainMarkers(Graphics2D g2, Rectangle2D dataArea, Layer layer) {
        XYItemRenderer r = this.getRenderer();
        List markers = this.getDomainMarkers(layer);
        if (markers != null && r != null) {
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                r.drawDomainMarker(g2, this, this.getDomainAxis(), marker, dataArea);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D g2, Rectangle2D dataArea, Layer layer) {
        XYItemRenderer r = this.getRenderer();
        List markers = this.getRangeMarkers(layer);
        if (markers != null && r != null) {
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                r.drawRangeMarker(g2, this, this.getRangeAxis(), marker, dataArea);
            }
        }
    }

    protected void drawSecondaryDomainMarkers(Graphics2D g2, Rectangle2D dataArea, int index, Layer layer) {
        XYItemRenderer r = this.getSecondaryRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getSecondaryDomainMarkers(index, layer);
        ValueAxis axis = this.getSecondaryDomainAxis(index);
        if (markers != null && axis != null) {
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawDomainMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    protected void drawSecondaryRangeMarkers(Graphics2D g2, Rectangle2D dataArea, int index, Layer layer) {
        XYItemRenderer r = this.getSecondaryRenderer(index);
        if (r == null) {
            return;
        }
        Collection markers = this.getSecondaryRangeMarkers(index, layer);
        ValueAxis axis = this.getSecondaryRangeAxis(index);
        if (markers != null && axis != null) {
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(g2, this, axis, marker, dataArea);
            }
        }
    }

    public List getDomainMarkers(Layer layer) {
        if (layer == Layer.FOREGROUND) {
            return Collections.unmodifiableList(this.foregroundDomainMarkers);
        }
        if (layer == Layer.BACKGROUND) {
            return Collections.unmodifiableList(this.backgroundDomainMarkers);
        }
        throw new IllegalStateException("XYPlot.getDomainMarkers(..): layer?");
    }

    public List getRangeMarkers(Layer layer) {
        if (layer == Layer.FOREGROUND) {
            return Collections.unmodifiableList(this.foregroundRangeMarkers);
        }
        if (layer == Layer.BACKGROUND) {
            return Collections.unmodifiableList(this.backgroundRangeMarkers);
        }
        throw new IllegalStateException("XYPlot.getRangeMarkers(..): layer?");
    }

    public Collection getSecondaryDomainMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.secondaryForegroundDomainMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.secondaryBackgroundDomainMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    public Collection getSecondaryRangeMarkers(int index, Layer layer) {
        Collection result = null;
        Integer key = new Integer(index);
        if (layer == Layer.FOREGROUND) {
            result = (Collection)this.secondaryForegroundRangeMarkers.get(key);
        } else if (layer == Layer.BACKGROUND) {
            result = (Collection)this.secondaryBackgroundRangeMarkers.get(key);
        }
        if (result != null) {
            result = Collections.unmodifiableCollection(result);
        }
        return result;
    }

    protected void drawHorizontalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        ValueAxis axis = this.getRangeAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            axis = this.getDomainAxis();
        }
        if (axis.getRange().contains(value)) {
            double yy = axis.valueToJava2D(value, dataArea, RectangleEdge.LEFT);
            Line2D.Double line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
            g2.setStroke(stroke);
            g2.setPaint(paint);
            g2.draw(line);
        }
    }

    protected void drawVerticalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        ValueAxis axis = this.getDomainAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            axis = this.getRangeAxis();
        }
        if (axis.getRange().contains(value)) {
            double xx = axis.valueToJava2D(value, dataArea, RectangleEdge.BOTTOM);
            Line2D.Double line = new Line2D.Double(xx, dataArea.getMinY(), xx, dataArea.getMaxY());
            g2.setStroke(stroke);
            g2.setPaint(paint);
            g2.draw(line);
        }
    }

    public void handleClick(int x, int y, PlotRenderingInfo info) {
        Rectangle2D dataArea = info.getDataArea();
        if (dataArea.contains(x, y)) {
            ValueAxis ra;
            ValueAxis da = this.getDomainAxis();
            if (da != null) {
                double hvalue = da.java2DToValue(x, info.getDataArea(), this.getDomainAxisEdge());
                this.setDomainCrosshairValue(hvalue);
            }
            if ((ra = this.getRangeAxis()) != null) {
                double vvalue = ra.java2DToValue(y, info.getDataArea(), this.getRangeAxisEdge());
                this.setRangeCrosshairValue(vvalue);
            }
        }
    }

    public void zoom(double percent) {
        if (percent > 0.0) {
            ValueAxis domainAxis1 = this.getDomainAxis();
            Range range = domainAxis1.getRange();
            double center = range.getCentralValue();
            double length = range.getLength();
            double scaledRange = length * percent;
            domainAxis1.setRange(center - scaledRange / 2.0, center + scaledRange / 2.0);
            ValueAxis rangeAxis1 = this.getRangeAxis();
            range = rangeAxis1.getRange();
            center = range.getCentralValue();
            length = range.getLength();
            scaledRange = length * percent;
            rangeAxis1.setRange(center - scaledRange / 2.0, center + scaledRange / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    private List getSecondaryDatasetsMappedToDomainAxis(Integer index) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.secondaryDatasetDomainAxisMap.size(); ++i) {
            Integer m = (Integer)this.secondaryDatasetDomainAxisMap.get(i);
            if (m == null) {
                if (index != null) continue;
                result.add(this.secondaryDatasets.get(i));
                continue;
            }
            if (!m.equals(index)) continue;
            result.add(this.secondaryDatasets.get(i));
        }
        return result;
    }

    private List getSecondaryDatasetsMappedToRangeAxis(Integer index) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.secondaryDatasetRangeAxisMap.size(); ++i) {
            Integer m = (Integer)this.secondaryDatasetRangeAxisMap.get(i);
            if (m == null) {
                if (index != null) continue;
                result.add(this.secondaryDatasets.get(i));
                continue;
            }
            if (!m.equals(index)) continue;
            result.add(this.secondaryDatasets.get(i));
        }
        return result;
    }

    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        ArrayList<XYDataset> mappedDatasets = new ArrayList<XYDataset>();
        boolean isDomainAxis = true;
        if (axis == this.getDomainAxis()) {
            isDomainAxis = true;
            mappedDatasets.add(this.dataset);
            mappedDatasets.addAll(this.getSecondaryDatasetsMappedToDomainAxis(null));
        } else if (axis == this.getRangeAxis()) {
            isDomainAxis = false;
            mappedDatasets.add(this.dataset);
            mappedDatasets.addAll(this.getSecondaryDatasetsMappedToRangeAxis(null));
        } else {
            int rangeIndex;
            int domainIndex = this.secondaryDomainAxes.indexOf((Object)axis);
            if (domainIndex >= 0) {
                isDomainAxis = true;
                mappedDatasets.addAll(this.getSecondaryDatasetsMappedToDomainAxis(new Integer(domainIndex)));
            }
            if ((rangeIndex = this.secondaryRangeAxes.indexOf((Object)axis)) >= 0) {
                isDomainAxis = false;
                mappedDatasets.addAll(this.getSecondaryDatasetsMappedToRangeAxis(new Integer(rangeIndex)));
            }
        }
        Iterator iterator = mappedDatasets.iterator();
        while (iterator.hasNext()) {
            XYDataset d = (XYDataset)iterator.next();
            XYItemRenderer r = this.getRendererForDataset(d);
            if (isDomainAxis) {
                result = Range.combine(result, DatasetUtilities.getDomainExtent(d));
                continue;
            }
            if (r != null && r.getRangeType() == RangeType.STACKED) {
                result = Range.combine(result, DatasetUtilities.getStackedRangeExtent((TableXYDataset)d));
                continue;
            }
            result = Range.combine(result, DatasetUtilities.getRangeExtent(d));
        }
        return result;
    }

    public void datasetChanged(DatasetChangeEvent event) {
        int axisIndex;
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        for (axisIndex = 0; axisIndex < this.secondaryDomainAxes.size(); ++axisIndex) {
            ValueAxis secondaryDomainAxis = this.getSecondaryDomainAxis(axisIndex);
            if (secondaryDomainAxis == null) continue;
            secondaryDomainAxis.configure();
        }
        for (axisIndex = 0; axisIndex < this.secondaryRangeAxes.size(); ++axisIndex) {
            ValueAxis secondaryRangeAxis = this.getSecondaryRangeAxis(axisIndex);
            if (secondaryRangeAxis == null) continue;
            secondaryRangeAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(event);
        } else {
            PlotChangeEvent e = new PlotChangeEvent(this);
            this.notifyListeners(e);
        }
    }

    public void rendererChanged(RendererChangeEvent event) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean flag) {
        if (this.domainCrosshairVisible != flag) {
            this.domainCrosshairVisible = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean flag) {
        if (this.domainCrosshairLockedOnData != flag) {
            this.domainCrosshairLockedOnData = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double value) {
        this.setDomainCrosshairValue(value, true);
    }

    public void setDomainCrosshairValue(double value, boolean notify) {
        this.domainCrosshairValue = value;
        if (this.isDomainCrosshairVisible() && notify) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        this.domainCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        this.domainCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean flag) {
        if (this.rangeCrosshairVisible != flag) {
            this.rangeCrosshairVisible = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean flag) {
        if (this.rangeCrosshairLockedOnData != flag) {
            this.rangeCrosshairLockedOnData = flag;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double value) {
        this.setRangeCrosshairValue(value, true);
    }

    public void setRangeCrosshairValue(double value, boolean notify) {
        this.rangeCrosshairValue = value;
        if (this.isRangeCrosshairVisible() && notify) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace space) {
        this.fixedDomainAxisSpace = space;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace space) {
        this.fixedRangeAxisSpace = space;
    }

    public void zoomHorizontalAxes(double factor) {
        block5: {
            PlotOrientation orient;
            block4: {
                orient = this.getOrientation();
                if (orient != PlotOrientation.HORIZONTAL) break block4;
                ValueAxis rangeAxis1 = this.getRangeAxis();
                if (rangeAxis1 != null) {
                    rangeAxis1.resizeRange(factor);
                }
                for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                    ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                    if (rangeAxis2 == null) continue;
                    rangeAxis2.resizeRange(factor);
                }
                break block5;
            }
            if (orient != PlotOrientation.VERTICAL) break block5;
            ValueAxis domainAxis1 = this.getDomainAxis();
            if (domainAxis1 != null) {
                domainAxis1.resizeRange(factor);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                ValueAxis domainAxis2 = (ValueAxis)this.secondaryDomainAxes.get(i);
                if (domainAxis2 == null) continue;
                domainAxis2.resizeRange(factor);
            }
        }
    }

    public void zoomHorizontalAxes(double lowerPercent, double upperPercent) {
        block5: {
            PlotOrientation orient;
            block4: {
                orient = this.getOrientation();
                if (orient != PlotOrientation.HORIZONTAL) break block4;
                ValueAxis rangeAxis1 = this.getRangeAxis();
                if (rangeAxis1 != null) {
                    rangeAxis1.zoomRange(lowerPercent, upperPercent);
                }
                for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                    ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                    if (rangeAxis2 == null) continue;
                    rangeAxis2.zoomRange(lowerPercent, upperPercent);
                }
                break block5;
            }
            if (orient != PlotOrientation.VERTICAL) break block5;
            ValueAxis domainAxis1 = this.getDomainAxis();
            if (domainAxis1 != null) {
                domainAxis1.zoomRange(lowerPercent, upperPercent);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                ValueAxis domainAxis2 = (ValueAxis)this.secondaryDomainAxes.get(i);
                if (domainAxis2 == null) continue;
                domainAxis2.zoomRange(lowerPercent, upperPercent);
            }
        }
    }

    public void zoomVerticalAxes(double factor) {
        block5: {
            PlotOrientation orient;
            block4: {
                orient = this.getOrientation();
                if (orient != PlotOrientation.HORIZONTAL) break block4;
                ValueAxis domainAxis1 = this.getDomainAxis();
                if (domainAxis1 != null) {
                    domainAxis1.resizeRange(factor);
                }
                for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                    ValueAxis domainAxis2 = (ValueAxis)this.secondaryDomainAxes.get(i);
                    if (domainAxis2 == null) continue;
                    domainAxis2.resizeRange(factor);
                }
                break block5;
            }
            if (orient != PlotOrientation.VERTICAL) break block5;
            ValueAxis rangeAxis1 = this.getRangeAxis();
            if (rangeAxis1 != null) {
                rangeAxis1.resizeRange(factor);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (rangeAxis2 == null) continue;
                rangeAxis2.resizeRange(factor);
            }
        }
    }

    public void zoomVerticalAxes(double lowerPercent, double upperPercent) {
        block5: {
            PlotOrientation orient;
            block4: {
                orient = this.getOrientation();
                if (orient != PlotOrientation.VERTICAL) break block4;
                ValueAxis rangeAxis1 = this.getRangeAxis();
                if (rangeAxis1 != null) {
                    rangeAxis1.zoomRange(lowerPercent, upperPercent);
                }
                for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                    ValueAxis rangeAxis2 = (ValueAxis)this.secondaryRangeAxes.get(i);
                    if (rangeAxis2 == null) continue;
                    rangeAxis2.zoomRange(lowerPercent, upperPercent);
                }
                break block5;
            }
            if (orient != PlotOrientation.HORIZONTAL) break block5;
            ValueAxis domainAxis1 = this.getDomainAxis();
            if (domainAxis1 != null) {
                domainAxis1.zoomRange(lowerPercent, upperPercent);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                ValueAxis domainAxis2 = (ValueAxis)this.secondaryDomainAxes.get(i);
                if (domainAxis2 == null) continue;
                domainAxis2.zoomRange(lowerPercent, upperPercent);
            }
        }
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.dataset != null) {
            result = this.dataset.getSeriesCount();
        }
        return result;
    }

    public LegendItemCollection getLegendItems() {
        XYItemRenderer renderer1;
        LegendItemCollection result = new LegendItemCollection();
        XYDataset dataset1 = this.getDataset();
        if (dataset1 != null && (renderer1 = this.getRenderer()) != null) {
            int seriesCount = dataset1.getSeriesCount();
            for (int i = 0; i < seriesCount; ++i) {
                LegendItem item = renderer1.getLegendItem(0, i);
                result.add(item);
            }
        }
        int count = this.secondaryDatasets.size();
        for (int datasetIndex = 0; datasetIndex < count; ++datasetIndex) {
            XYItemRenderer renderer2;
            XYDataset dataset2 = this.getSecondaryDataset(datasetIndex);
            if (dataset2 == null || (renderer2 = this.getSecondaryRenderer(datasetIndex)) == null) continue;
            int seriesCount = dataset2.getSeriesCount();
            for (int i = 0; i < seriesCount; ++i) {
                LegendItem item = renderer2.getLegendItem(datasetIndex + 1, i);
                result.add(item);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYPlot)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        XYPlot p = (XYPlot)obj;
        if (this.weight != p.weight) {
            return false;
        }
        if (this.orientation != p.orientation) {
            return false;
        }
        if (this.domainAxisLocation != p.domainAxisLocation) {
            return false;
        }
        if (!this.secondaryDomainAxes.equals((Object)p.secondaryDomainAxes)) {
            return false;
        }
        if (!this.secondaryDomainAxisLocations.equals((Object)p.secondaryDomainAxisLocations)) {
            return false;
        }
        if (this.rangeAxisLocation != p.rangeAxisLocation) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != p.rangeCrosshairLockedOnData) {
            return false;
        }
        if (this.domainGridlinesVisible != p.domainGridlinesVisible) {
            return false;
        }
        if (this.rangeGridlinesVisible != p.rangeGridlinesVisible) {
            return false;
        }
        if (this.domainCrosshairVisible != p.domainCrosshairVisible) {
            return false;
        }
        if (this.domainCrosshairValue != p.domainCrosshairValue) {
            return false;
        }
        if (this.domainCrosshairLockedOnData != p.domainCrosshairLockedOnData) {
            return false;
        }
        if (this.rangeCrosshairVisible != p.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != p.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.axisOffset, (Object)p.axisOffset)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.domainAxis, (Object)p.domainAxis)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.rangeAxis, (Object)p.rangeAxis)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.renderer, (Object)p.renderer)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryRangeAxes, (Object)p.secondaryRangeAxes)) {
            return false;
        }
        if (!this.secondaryRangeAxisLocations.equals((Object)p.secondaryRangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryDatasetDomainAxisMap, (Object)p.secondaryDatasetDomainAxisMap)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryDatasetRangeAxisMap, (Object)p.secondaryDatasetRangeAxisMap)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryRenderers, (Object)p.secondaryRenderers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.domainGridlineStroke, (Object)p.domainGridlineStroke)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.domainGridlinePaint, (Object)p.domainGridlinePaint)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.rangeGridlineStroke, (Object)p.rangeGridlineStroke)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.rangeGridlinePaint, (Object)p.rangeGridlinePaint)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.domainCrosshairStroke, (Object)p.domainCrosshairStroke)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.domainCrosshairPaint, (Object)p.domainCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.rangeCrosshairStroke, (Object)p.rangeCrosshairStroke)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.rangeCrosshairPaint, (Object)p.rangeCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.foregroundDomainMarkers, (Object)p.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.backgroundDomainMarkers, (Object)p.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.foregroundRangeMarkers, (Object)p.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.backgroundRangeMarkers, (Object)p.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryForegroundDomainMarkers, (Object)p.secondaryForegroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryBackgroundDomainMarkers, (Object)p.secondaryBackgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryForegroundRangeMarkers, (Object)p.secondaryForegroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.secondaryBackgroundRangeMarkers, (Object)p.secondaryBackgroundRangeMarkers)) {
            return false;
        }
        return ObjectUtils.equal((Object)this.annotations, (Object)p.annotations);
    }

    public Object clone() throws CloneNotSupportedException {
        ValueAxis clonedAxis;
        ValueAxis axis;
        int i;
        XYPlot clone = (XYPlot)super.clone();
        clone.domainAxis = (ValueAxis)ObjectUtils.clone((Object)this.domainAxis);
        if (clone.domainAxis != null) {
            clone.domainAxis.setPlot(clone);
            clone.domainAxis.addChangeListener(clone);
        }
        clone.secondaryDomainAxes = (ObjectList)ObjectUtils.clone((Object)this.secondaryDomainAxes);
        for (i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            axis = (ValueAxis)this.secondaryDomainAxes.get(i);
            if (axis == null) continue;
            clonedAxis = (ValueAxis)axis.clone();
            clone.secondaryDomainAxes.set(i, (Object)clonedAxis);
            clonedAxis.setPlot(clone);
            clonedAxis.addChangeListener(clone);
        }
        clone.secondaryDomainAxisLocations = (ObjectList)this.secondaryDomainAxisLocations.clone();
        clone.rangeAxis = (ValueAxis)ObjectUtils.clone((Object)this.rangeAxis);
        if (clone.rangeAxis != null) {
            clone.rangeAxis.setPlot(clone);
            clone.rangeAxis.addChangeListener(clone);
        }
        clone.secondaryRangeAxes = (ObjectList)ObjectUtils.clone((Object)this.secondaryRangeAxes);
        for (i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            axis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (axis == null) continue;
            clonedAxis = (ValueAxis)axis.clone();
            clone.secondaryRangeAxes.set(i, (Object)clonedAxis);
            clonedAxis.setPlot(clone);
            clonedAxis.addChangeListener(clone);
        }
        clone.secondaryRangeAxisLocations = (ObjectList)ObjectUtils.clone((Object)this.secondaryRangeAxisLocations);
        if (clone.dataset != null) {
            clone.dataset.addChangeListener(clone);
        }
        clone.secondaryDatasets = (ObjectList)ObjectUtils.clone((Object)this.secondaryDatasets);
        for (i = 0; i < clone.secondaryDatasets.size(); ++i) {
            XYDataset dataset2 = this.getSecondaryDataset(i);
            dataset2.addChangeListener(clone);
        }
        clone.secondaryDatasetDomainAxisMap = (ObjectList)ObjectUtils.clone((Object)this.secondaryDatasetDomainAxisMap);
        clone.secondaryDatasetRangeAxisMap = (ObjectList)ObjectUtils.clone((Object)this.secondaryDatasetRangeAxisMap);
        clone.renderer = (XYItemRenderer)ObjectUtils.clone((Object)this.renderer);
        clone.secondaryRenderers = (ObjectList)ObjectUtils.clone((Object)this.secondaryRenderers);
        for (i = 0; i < this.secondaryRenderers.size(); ++i) {
            XYItemRenderer renderer2 = (XYItemRenderer)this.secondaryRenderers.get(i);
            if (!(renderer2 instanceof PublicCloneable)) continue;
            PublicCloneable pc = (PublicCloneable)this.renderer;
            clone.secondaryRenderers.set(i, pc.clone());
        }
        clone.foregroundDomainMarkers = ObjectUtils.clone((List)this.foregroundDomainMarkers);
        clone.backgroundDomainMarkers = ObjectUtils.clone((List)this.backgroundDomainMarkers);
        clone.secondaryForegroundDomainMarkers = (Map)ObjectUtils.clone((Object)this.secondaryForegroundDomainMarkers);
        clone.secondaryBackgroundDomainMarkers = (Map)ObjectUtils.clone((Object)this.secondaryBackgroundDomainMarkers);
        clone.foregroundRangeMarkers = ObjectUtils.clone((List)this.foregroundRangeMarkers);
        clone.backgroundRangeMarkers = ObjectUtils.clone((List)this.backgroundRangeMarkers);
        clone.secondaryForegroundRangeMarkers = (Map)ObjectUtils.clone((Object)this.secondaryForegroundRangeMarkers);
        clone.secondaryBackgroundRangeMarkers = (Map)ObjectUtils.clone((Object)this.secondaryBackgroundRangeMarkers);
        clone.annotations = ObjectUtils.clone((List)this.annotations);
        clone.fixedDomainAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedDomainAxisSpace);
        clone.fixedRangeAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedRangeAxisSpace);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.domainGridlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.domainGridlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.rangeGridlineStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.rangeGridlinePaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.domainCrosshairStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.domainCrosshairPaint, (ObjectOutputStream)stream);
        SerialUtilities.writeStroke((Stroke)this.rangeCrosshairStroke, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.rangeCrosshairPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.domainTickBandPaint, (ObjectOutputStream)stream);
        SerialUtilities.writePaint((Paint)this.rangeTickBandPaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.domainGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.rangeGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.rangeGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.domainCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.domainCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)stream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.domainTickBandPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        this.rangeTickBandPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
        if (this.domainAxis != null) {
            this.domainAxis.setPlot(this);
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.setPlot(this);
            this.rangeAxis.addChangeListener(this);
        }
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
        this.foregroundDomainMarkers = new ArrayList();
        this.backgroundDomainMarkers = new ArrayList();
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundDomainMarkers = new HashMap();
        this.secondaryBackgroundDomainMarkers = new HashMap();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
    }

    public void clearSecondaryRangeMarkers() {
        this.clearSecondaryRangeMarkers(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

