/*
 * BcImage.java
 *
 * Created on 20. April 2004, 13:21
 */

package it.businesslogic.ireport.barcode;

/**
 *
 * @author  Heiko
 */

import java.awt.image.*;
import java.awt.*;
import net.sourceforge.barbecue.*;

public class BcImage {
	private static net.sourceforge.barbecue.Barcode bc = null;
	
	public static net.sourceforge.barbecue.Barcode getBarcode() {
		return bc;
	}
	
	public static BufferedImage getBarcodeImage(int type, Object aText, boolean showText, boolean checkSum) {
		// 2of7, 3of9, Bookland, Codabar, Code128, Code128A, Code128B, Code128C, Code39, EAN128, EAN13, GlobalTradeItemNumber, Int2of5, Int2of5, Monarch, NW7, PDF417, SCC14ShippingCode, ShipmentIdentificationNumber, SSCC18, Std2of5, Std2of5, UCC128, UPCA, USD3, USD4, USPS
		
		String text = new StringBuffer().append(aText).toString();

		try {
			switch (type) {
				case 0: bc = BarcodeFactory.create2of7(text); break;
				case 1: bc = BarcodeFactory.create3of9(text, checkSum);	break;
				case 2: bc = BarcodeFactory.createBookland(text); break;
				case 3: bc = BarcodeFactory.createCodabar(text); break;
				case 4: bc = BarcodeFactory.createCode128(text); break;
				case 5: bc = BarcodeFactory.createCode128A(text); break;
				case 6: bc = BarcodeFactory.createCode128B(text); break;
				case 7: bc = BarcodeFactory.createCode128C(text); break;
				case 8: bc = BarcodeFactory.createCode39(text, checkSum); break;
				case 9: bc = BarcodeFactory.createEAN128(text); break;
				case 10: bc = BarcodeFactory.createEAN13(text);	break;
				case 11: bc = BarcodeFactory.createGlobalTradeItemNumber(text);	break;
				case 12: bc = BarcodeFactory.createInt2of5(text, checkSum); break;
				case 13: bc = BarcodeFactory.createMonarch(text); break;
				case 14: bc = BarcodeFactory.createNW7(text); break;
				case 15: bc = BarcodeFactory.createPDF417(text); break;
				case 16: bc = BarcodeFactory.createSCC14ShippingCode(text); break;
				case 17: bc = BarcodeFactory.createShipmentIdentificationNumber(text); break;
				case 18: bc = BarcodeFactory.createSSCC18(text); break;
				case 19: bc = BarcodeFactory.createStd2of5(text, checkSum); break;
				case 20: bc = BarcodeFactory.createUCC128("", text); break;
				case 21: bc = BarcodeFactory.createUPCA(text); break;
				case 22: bc = BarcodeFactory.createUSD3(text, checkSum); break;
				case 23: bc = BarcodeFactory.createUSD4(text); break;
				case 24: bc = BarcodeFactory.createUSPS(text); break;
			}
			
			bc.setDrawingText(showText);
			return net.sourceforge.barbecue.BarcodeImageHandler.getImage(bc);
		}
		catch (Exception e) {
			
			//generate a runtime exception, invalid value passed. 
			//the user must be notified if fail 
			throw new RuntimeException(e.getMessage());
			//return null;
		}
	}
}


