/*
 * InsertElementOperation.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 *
 * Created on 19 giugno 2003, 23.23
 */

package it.businesslogic.ireport.undo;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;

import java.util.*;

/**
 *  This class handle the Insert operation.
 *  As all operations, the costructor take the JReportFrame (owner of the element)
 *  The ReportElement is not cloned, this can be a problem if not all undo operations
 *  are correctly logged and handled.
 * @author  Giulio Toffoli
 */
public class ReplacedElementsOperation implements it.businesslogic.ireport.UndoOperation {
    
    /*
     *  The report elements that was replaced.
     */
    private Vector elements = null; 
    
    private JReportFrame jrf = null;
    
    /** Creates a new instance of InsertElementOperation */
    public ReplacedElementsOperation(JReportFrame jrf) {
        this.elements = new Vector();
        this.jrf = jrf;
    }
    
    public void redo()
    {
        // We must remove our element...
        if (jrf == null) return;
        Enumeration e = this.getElements().elements();
        while ( e.hasMoreElements() )
        {
            ReplacedElementItem ei = (ReplacedElementItem)e.nextElement();
            ReportElement newElement = ei.getNewElement();
            ReportElement oldElement = ei.getOldElement();
              
            int index = jrf.getReport().getElements().indexOf( oldElement );
            jrf.getReport().getElements().remove( oldElement );
            jrf.getReport().getElements().add(index, newElement);
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, oldElement , ReportElementChangedEvent.REMOVED));   
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, newElement , ReportElementChangedEvent.ADDED)); 
        }
        jrf.getReportPanel().repaint();
    }
    
    public void undo()
    {
        // We must add our element...
        if (jrf == null) return;

        for (int i= this.getElements().size()-1; i>=0; --i)
        {
            ReplacedElementItem ei = (ReplacedElementItem)getElements().get(i);
            ReportElement newElement = ei.getNewElement();
            ReportElement oldElement = ei.getOldElement();
              
            int index = jrf.getReport().getElements().indexOf( newElement );
            jrf.getReport().getElements().remove( newElement );
            jrf.getReport().getElements().add(index, oldElement);
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, newElement , ReportElementChangedEvent.REMOVED));   
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, oldElement , ReportElementChangedEvent.ADDED));          
        }
        jrf.getReportPanel().repaint();
    }   
    
    public String toString()
    {
        return "Transformed element(s)";
    }
    
    /** Getter for property elements.
     * @return Value of property elements.
     *
     *  To add an element, use the addElement method. Don't access directly
     *  addElement from the vector elements 
     *  
     */
    public java.util.Vector getElements() {
        return elements;
    }
    
    /** Setter for property elements.
     * @param elements New value of property elements.
     *
     */
    public void setElements(java.util.Vector elements) {
        this.elements = elements;
    }
    
    /*
     *  Add an element to the list of elements handled by this
     *  undo operation. The position is relative to the z position
     *  in the elements vector.
     *  If the undo mechanism works fine, the requested position is
     *  ever available.
     *  The position value should be retrived when the element
     *  is added.
     */
     public void addElement(ReportElement oldEelement,ReportElement newElement ) {
         ReplacedElementItem ei = new ReplacedElementItem(oldEelement, newElement );
         getElements().add(ei);
    }
    
}




