/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfLine;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private PdfLine line;
    private ArrayList images;
    private float leading;
    private int rownumber;
    private int rowspan;
    private float cellspacing;
    private float cellpadding;
    private boolean header = false;
    private int groupNumber;

    public PdfCell(Cell cell, int n, float f, float f2, float f3, float f4, float f5) {
        super(f, f3, f2, f3);
        Object object;
        Object object2;
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.images = new ArrayList();
        this.leading = cell.leading();
        int n2 = cell.horizontalAlignment();
        f += f4 + f5;
        f2 -= f4 + f5;
        float f6 = this.leading + f5;
        float f7 = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                f6 *= f7;
                break;
            }
            case 5: {
                f6 = (float)((double)f6 * ((double)f7 / 1.5));
                break;
            }
            default: {
                f6 -= f5 * 0.4f;
            }
        }
        this.line = new PdfLine(f, f2, n2, f6);
        Object object3 = cell.getElements();
        block11: while (object3.hasNext()) {
            PdfChunk pdfChunk;
            PdfChunk pdfChunk2;
            Object object4;
            int n3;
            ArrayList arrayList;
            Element element = (Element)object3.next();
            switch (element.type()) {
                case 32: 
                case 34: 
                case 35: {
                    f6 = this.addImage((Image)element, f, f2, f6, n2);
                    continue block11;
                }
                case 14: {
                    if (this.line.size() > 0) {
                        this.line.resetAlignment();
                        this.lines.add(this.line);
                    }
                    arrayList = new ArrayList();
                    this.processActions(element, null, arrayList);
                    n3 = 0;
                    object2 = ((List)element).getItems().iterator();
                    while (object2.hasNext()) {
                        object = (ListItem)object2.next();
                        this.line = new PdfLine(f + ((Paragraph)object).indentationLeft(), f2, n2, this.leading);
                        this.line.setListItem((ListItem)object);
                        object4 = ((Phrase)object).getChunks().iterator();
                        while (object4.hasNext()) {
                            pdfChunk2 = new PdfChunk((Chunk)object4.next(), (PdfAction)arrayList.get(n3++));
                            while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                                this.lines.add(this.line);
                                this.line = new PdfLine(f + ((Paragraph)object).indentationLeft(), f2, n2, this.leading);
                                pdfChunk2 = pdfChunk;
                            }
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(f + ((Paragraph)object).indentationLeft(), f2, n2, this.leading);
                        }
                    }
                    this.line = new PdfLine(f, f2, n2, this.leading);
                    continue block11;
                }
            }
            arrayList = new ArrayList();
            this.processActions(element, null, arrayList);
            n3 = 0;
            object2 = element.getChunks().iterator();
            while (object2.hasNext()) {
                object4 = (Chunk)object2.next();
                pdfChunk2 = new PdfChunk((Chunk)object4, (PdfAction)arrayList.get(n3++));
                while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                    this.lines.add(this.line);
                    this.line = new PdfLine(f, f2, n2, this.leading);
                    pdfChunk2 = pdfChunk;
                }
            }
            switch (element.type()) {
                case 12: 
                case 13: 
                case 16: {
                    this.line.resetAlignment();
                    this.lines.add(this.line);
                    this.line = new PdfLine(f, f2, n2, this.leading);
                }
            }
        }
        if (this.line.size() > 0) {
            this.lines.add(this.line);
        }
        if (this.lines.size() > cell.getMaxLines()) {
            while (this.lines.size() > cell.getMaxLines()) {
                this.lines.remove(this.lines.size() - 1);
            }
            if (cell.getMaxLines() > 0 && (object3 = cell.getShowTruncation()) != null && ((String)object3).length() > 0) {
                object = (PdfLine)this.lines.get(this.lines.size() - 1);
                if (((PdfLine)object).size() >= 0) {
                    object2 = ((PdfLine)object).getChunk(((PdfLine)object).size() - 1);
                    float f8 = new PdfChunk((String)object3, (PdfChunk)object2).width();
                    while (((PdfChunk)object2).toString().length() > 0 && ((PdfChunk)object2).width() + f8 > f2 - f) {
                        ((PdfChunk)object2).setValue(((PdfChunk)object2).toString().substring(0, ((PdfChunk)object2).length() - 1));
                    }
                    ((PdfChunk)object2).setValue(((PdfChunk)object2).toString() + (String)object3);
                } else {
                    ((PdfLine)object).add(new PdfChunk(new Chunk((String)object3), null));
                }
            }
        }
        this.setBottom(f3 - this.leading * (float)(this.lines.size() - 1) - f5 - f6 - 2.0f * f4);
        this.cellpadding = f5;
        this.cellspacing = f4;
        this.rowspan = cell.rowspan();
        this.rownumber = n;
    }

    public float left() {
        return super.left(this.cellspacing);
    }

    public float right() {
        return super.right(this.cellspacing);
    }

    public float top() {
        return super.top(this.cellspacing);
    }

    public float bottom() {
        return super.bottom(this.cellspacing);
    }

    private float addImage(Image image, float f, float f2, float f3, int n) {
        Image image2 = Image.getInstance(image);
        if (image2.scaledWidth() > f2 - f) {
            image2.scaleToFit(f2 - f, Float.MAX_VALUE);
        }
        if (this.line.size() != 0) {
            this.lines.add(this.line);
        }
        this.line = new PdfLine(f, f2, n, image2.scaledHeight() + 0.4f * this.leading);
        this.lines.add(this.line);
        this.line = new PdfLine(f, f2, n, this.leading);
        if ((image2.alignment() & 2) == 2) {
            f = f2 - image2.scaledWidth();
        } else if ((image2.alignment() & 1) == 1) {
            f += (f2 - f - image2.scaledWidth()) / 2.0f;
        }
        image2.setAbsolutePosition(f, f3 + (float)(this.lines.size() - 2) * this.leading + image2.scaledHeight() + 0.4f * this.leading);
        this.images.add(image2);
        return f3 + image2.scaledHeight() + 0.4f * this.leading;
    }

    public ArrayList getLines(float f, float f2) {
        float f3 = Math.min(this.top(), f);
        this.setTop(f3 + this.cellspacing);
        ArrayList<PdfLine> arrayList = new ArrayList<PdfLine>();
        if (this.top() < f2) {
            return arrayList;
        }
        int n = this.lines.size();
        boolean bl = true;
        for (int i = 0; i < n && bl; ++i) {
            this.line = (PdfLine)this.lines.get(i);
            float f4 = this.line.height();
            if ((f3 -= f4) > f2 + this.cellpadding) {
                arrayList.add(this.line);
                continue;
            }
            bl = false;
        }
        float f5 = 0.0f;
        if (!this.header) {
            if (bl) {
                this.lines = new ArrayList();
            } else {
                n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    this.line = (PdfLine)this.lines.remove(0);
                    f5 += this.line.height();
                }
            }
        }
        if (f5 > 0.0f) {
            Iterator iterator = this.images.iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.setAbsolutePosition(image.absoluteX(), image.absoluteY() - f5 - this.leading);
            }
        }
        return arrayList;
    }

    public ArrayList getImages(float f, float f2) {
        if (this.top() < f2) {
            return new ArrayList();
        }
        f = Math.min(this.top(), f);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Iterator iterator = this.images.iterator();
        while (iterator.hasNext() && !this.header) {
            Image image = (Image)iterator.next();
            float f3 = image.absoluteY();
            if (!(f - f3 > f2 + this.cellpadding)) continue;
            image.setAbsolutePosition(image.absoluteX(), f - f3);
            arrayList.add(image);
            iterator.remove();
        }
        return arrayList;
    }

    boolean isHeader() {
        return this.header;
    }

    void setHeader() {
        this.header = true;
    }

    boolean mayBeRemoved() {
        return this.header || this.lines.size() == 0 && this.images.size() == 0;
    }

    public int size() {
        return this.lines.size();
    }

    public int remainingLines() {
        if (this.lines.size() == 0) {
            return 0;
        }
        int n = 0;
        int n2 = this.lines.size();
        for (int i = 0; i < n2; ++i) {
            PdfLine pdfLine = (PdfLine)this.lines.get(i);
            if (pdfLine.size() <= 0) continue;
            ++n;
        }
        return n;
    }

    public float remainingHeight() {
        float f = 0.0f;
        Iterator iterator = this.images.iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            f += image.scaledHeight();
        }
        return (float)this.remainingLines() * this.leading + 2.0f * this.cellpadding + this.cellspacing + f + this.leading / 2.5f;
    }

    public float leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    protected void processActions(Element element, PdfAction pdfAction, ArrayList arrayList) {
        Iterator iterator;
        if (element.type() == 17 && (iterator = ((Anchor)element).reference()) != null) {
            pdfAction = new PdfAction((String)((Object)iterator));
        }
        switch (element.type()) {
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                iterator = ((ArrayList)((Object)element)).iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            case 10: {
                arrayList.add(pdfAction);
                break;
            }
            case 14: {
                iterator = ((List)element).getItems().iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            default: {
                ArrayList arrayList2 = element.getChunks();
                int n = element.getChunks().size();
                while (n-- > 0) {
                    arrayList.add(pdfAction);
                }
                break block0;
            }
        }
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    void setGroupNumber(int n) {
        this.groupNumber = n;
    }

    public Rectangle rectangle(float f, float f2) {
        Rectangle rectangle = new Rectangle(this.left(), this.bottom(), this.right(), this.top());
        rectangle.setBorder(this.border);
        rectangle.setBorderWidth(this.borderWidth);
        rectangle.setBorderColor(this.color);
        rectangle.setBackgroundColor(this.background);
        rectangle.setGrayFill(this.grayFill);
        if (this.top() > f) {
            rectangle.setTop(f);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < f2) {
            rectangle.setBottom(f2);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }
}

