/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporter;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.util.JRLoader;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class JRAbstractExporter
implements JRExporter {
    protected Map parameters = new HashMap();
    protected JasperPrint jasperPrint = null;
    protected int startPageIndex = 0;
    protected int endPageIndex = 0;

    public void setParameter(JRExporterParameter parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    public Object getParameter(JRExporterParameter parameter) {
        return this.parameters.get(parameter);
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public abstract void exportReport() throws JRException;

    protected void setInput() throws JRException {
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
    }

    protected void setPageRange() throws JRException {
        Integer start;
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < 0 || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " of " + lastPageIndex);
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
    }

    protected void setOutput() {
    }
}

