/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.base;

import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRExpressionChunk;
import dori.jasper.engine.JRRuntimeException;
import dori.jasper.engine.base.JRBaseObjectFactory;
import dori.jasper.engine.util.JRClassLoader;
import java.io.Serializable;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 503L;
    protected String valueClassName = null;
    protected String name = null;
    protected int id = 0;
    protected transient Class valueClass = null;
    private JRExpressionChunk[] chunks = null;

    protected JRBaseExpression() {
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory) {
        factory.put(expression, this);
        this.valueClassName = expression.getValueClassName();
        this.name = expression.getName();
        this.id = expression.getId();
        JRExpressionChunk[] jrChunks = expression.getChunks();
        if (jrChunks != null && jrChunks.length > 0) {
            this.chunks = new JRExpressionChunk[jrChunks.length];
            int i = 0;
            while (i < this.chunks.length) {
                this.chunks[i] = factory.getExpressionChunk(jrChunks[i]);
                ++i;
            }
        }
    }

    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(this.valueClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    public String getText() {
        String text = "";
        this.chunks = this.getChunks();
        if (this.chunks != null && this.chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            int i = 0;
            while (i < this.chunks.length) {
                switch (this.chunks[i].getType()) {
                    case 2: {
                        sbuffer.append("$P{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        break;
                    }
                    case 3: {
                        sbuffer.append("$F{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        break;
                    }
                    case 4: {
                        sbuffer.append("$V{");
                        sbuffer.append(this.chunks[i].getText());
                        sbuffer.append("}");
                        break;
                    }
                    default: {
                        sbuffer.append(this.chunks[i].getText());
                    }
                }
                ++i;
            }
            text = sbuffer.toString();
        }
        return text;
    }
}

