/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.fill.JRByteAverageIncrementer;
import dori.jasper.engine.fill.JRByteCountIncrementer;
import dori.jasper.engine.fill.JRByteStandardDeviationIncrementer;
import dori.jasper.engine.fill.JRByteSumIncrementer;
import dori.jasper.engine.fill.JRByteVarianceIncrementer;
import dori.jasper.engine.fill.JRComparableIncrementerFactory;
import dori.jasper.engine.fill.JRDefaultIncrementerFactory;
import dori.jasper.engine.fill.JRIncrementer;
import dori.jasper.engine.fill.JRIncrementerFactory;

public class JRByteIncrementerFactory
implements JRIncrementerFactory {
    protected static final Byte ZERO = new Byte(0);
    private static JRByteIncrementerFactory mainInstance = new JRByteIncrementerFactory();

    private JRByteIncrementerFactory() {
    }

    public static JRByteIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRByteCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRByteSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRByteAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRByteStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRByteVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

