/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.util;

import dori.jasper.engine.JRException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JRImageSaver {
    public static void saveImageDataToFile(byte[] imageData, File file) throws JRException {
        FileOutputStream fos = null;
        ByteArrayInputStream bais = null;
        try {
            fos = new FileOutputStream(file);
            bais = new ByteArrayInputStream(imageData);
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = bais.read(bytes)) > 0) {
                fos.write(bytes, 0, ln);
            }
            fos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error saving image data : " + file, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveImageDataToOutputStream(byte[] imageData, OutputStream os) throws JRException {
        ByteArrayInputStream bais = null;
        try {
            try {
                bais = new ByteArrayInputStream(imageData);
                byte[] bytes = new byte[10000];
                int ln = 0;
                while (true) {
                    if ((ln = bais.read(bytes)) <= 0) {
                        os.flush();
                        break;
                    }
                    os.write(bytes, 0, ln);
                }
            }
            catch (IOException e) {
                throw new JRException("Error saving image data to output stream.", e);
            }
            Object var6_6 = null;
            if (bais == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bais == null) throw throwable;
            try {
                bais.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        bais.close();
        return;
    }
}

