/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.export.JRExportProgressMonitor;
import dori.jasper.engine.export.JRXmlExporterParameter;
import it.businesslogic.ireport.export.JRTxtExporterParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class JRTxtExporter
extends JRAbstractExporter {
    int PAGE_ROWS = 61;
    int PAGE_COLUMNS = 255;
    int CHAR_UNIT_H = 10;
    int CHAR_UNIT_V = 20;
    boolean ADD_FORM_FEED = true;
    protected String delimiter = null;
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        String page_rows;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setInput();
        this.setPageRange();
        String encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        this.PAGE_ROWS = (page_rows = (String)this.parameters.get((Object)JRTxtExporterParameter.PAGE_ROWS)) != null ? Integer.parseInt(page_rows) : this.jasperPrint.getPageHeight() / 20;
        String page_cols = (String)this.parameters.get((Object)JRTxtExporterParameter.PAGE_COLUMNS);
        this.PAGE_COLUMNS = page_cols != null ? Integer.parseInt(page_cols) : this.jasperPrint.getPageWidth() / this.CHAR_UNIT_H;
        String add_form_feed = (String)this.parameters.get((Object)JRTxtExporterParameter.ADD_FORM_FEED);
        this.ADD_FORM_FEED = add_form_feed != null ? add_form_feed.equalsIgnoreCase("false") : true;
        this.delimiter = ",";
        StringBuffer sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb != null) {
            try {
                try {
                    this.writer = new StringWriter();
                    this.exportReportToWriter();
                    sb.append(this.writer.toString());
                }
                catch (IOException e) {
                    throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), (Throwable)e);
                }
                Object var8_6 = null;
                if (this.writer == null) return;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (this.writer == null) throw throwable;
                try {
                    this.writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            this.writer.close();
            return;
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
                return;
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
                return;
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName == null) throw new JRException("No output specified for the exporter.");
            destFile = new File(fileName);
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
            Object var11_18 = null;
            if (this.writer == null) return;
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            if (this.writer == null) throw throwable;
            try {
                this.writer.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        this.writer.close();
        return;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        List pages = this.jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        Vector lines = this.layoutGrid(page);
        int y = 0;
        for (y = 0; y < lines.size(); ++y) {
            this.writer.write(("" + lines.elementAt(y)).trim());
            this.writer.write("\n");
        }
        while (y < this.PAGE_ROWS) {
            this.writer.write("\n");
            ++y;
        }
        if (this.ADD_FORM_FEED) {
            this.writer.write("\f");
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected Vector layoutGrid(JRPrintPage page) {
        int i;
        Vector<String> v_lines = new Vector<String>();
        String void_line = "";
        for (i = 0; i < this.PAGE_COLUMNS; ++i) {
            void_line = void_line + " ";
        }
        for (i = 0; i < this.PAGE_ROWS; ++i) {
            void_line = void_line + " ";
            v_lines.add(void_line);
        }
        ArrayList<Integer> yCuts = new ArrayList<Integer>();
        yCuts.add(new Integer(0));
        yCuts.add(new Integer(this.jasperPrint.getPageHeight()));
        Integer y = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (!(element instanceof JRPrintText)) continue;
            y = new Integer(element.getY());
            if (!yCuts.contains(y)) {
                yCuts.add(y);
            }
            if (yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            yCuts.add(y);
        }
        Collections.sort(yCuts);
        int yCellCount = yCuts.size() - 1;
        int real_line_num = 0;
        for (int j = 0; j < yCellCount; ++j) {
            if (v_lines.size() <= real_line_num) {
                v_lines.add(new String(void_line));
            }
            int actual_cut = (Integer)yCuts.get(j);
            int lines_used = 1;
            Iterator it2 = elems.iterator();
            while (it2.hasNext()) {
                JRPrintText pt;
                JRPrintElement element = (JRPrintElement)it2.next();
                if (!(element instanceof JRPrintText) || (pt = (JRPrintText)element).getY() != actual_cut) continue;
                int start_at = pt.getX() / this.CHAR_UNIT_H;
                int len = pt.getWidth() / this.CHAR_UNIT_H;
                String str = pt.getText();
                boolean line_height = false;
                if (pt.getHeight() <= this.CHAR_UNIT_V) {
                    if (str.length() > len) {
                        str = str.substring(0, len);
                    }
                    if (pt.getY() / this.CHAR_UNIT_V > real_line_num) {
                        real_line_num = pt.getY() / this.CHAR_UNIT_V;
                    }
                    if (v_lines.size() <= real_line_num) {
                        v_lines.add(new String(void_line));
                    }
                    String line = (String)v_lines.elementAt(real_line_num);
                    line = this.replaceLineRegion(line, start_at, len, str, pt.getTextAlignment());
                    v_lines.setElementAt(line, real_line_num);
                    continue;
                }
                boolean max_field_lines = true;
                Vector field_lines = this.getFieldLines(str, len);
                int nl = 0;
                for (nl = 0; nl < field_lines.size(); ++nl) {
                    String text = (String)field_lines.elementAt(nl);
                    while (v_lines.size() <= real_line_num + nl) {
                        v_lines.add(new String(void_line));
                    }
                    String line = (String)v_lines.elementAt(real_line_num + nl);
                    line = this.replaceLineRegion(line, start_at, len, text, pt.getTextAlignment());
                    v_lines.setElementAt(line, real_line_num + nl);
                    if (nl <= lines_used) continue;
                    lines_used = nl;
                }
            }
            real_line_num += lines_used;
        }
        return v_lines;
    }

    protected String replaceLineRegion(String line, int start_at, int len, String str, byte alignment) {
        int side = 0;
        if (alignment == 2 && (side = len - str.length()) > 0) {
            side /= 2;
        }
        for (int k = 0; k < side; ++k) {
            str = " " + str;
        }
        if (alignment == 3) {
            while (str.length() < len) {
                str = " " + str;
            }
        }
        while (str.length() < len) {
            str = str + " ";
        }
        return line.substring(0, start_at) + str + line.substring(start_at + len);
    }

    public Vector getFieldLines(String str, int row_len) {
        Vector<String> lines = new Vector<String>();
        StringTokenizer st = new StringTokenizer(str, "\n", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            while (token.length() > row_len) {
                String tmp_line = token.substring(0, row_len);
                int li = tmp_line.lastIndexOf(32);
                if (token.charAt(row_len) == ' ') {
                    lines.addElement(tmp_line);
                    token = token.substring(row_len).trim();
                    continue;
                }
                if (li == -1) {
                    lines.addElement(tmp_line);
                    token = token.substring(row_len).trim();
                    continue;
                }
                tmp_line = token.substring(0, li);
                lines.addElement(tmp_line);
                token = token.substring(li + 1).trim();
            }
            if (token.trim().length() <= 0) continue;
            if (lines.size() == 0) {
                lines.addElement(token);
                continue;
            }
            lines.addElement(token.trim());
        }
        return lines;
    }
}

