/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.gui.ConnectionDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ConnectionsDialog
extends JDialog {
    private JButton jButtonDeleteParameter;
    private JButton jButtonModifyParameter;
    private JButton jButtonNewParameter;
    private JPanel jPanelButtons;
    private JPanel jPanelParameters;
    private JScrollPane jScrollPane1;
    private JTable jTableParameters;

    public ConnectionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(490, 250);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ConnectionsDialog.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        Misc.centerFrame(this);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        Enumeration e = ((MainFrame)parent).getConnections().elements();
        while (e.hasMoreElements()) {
            IReportConnection con = (IReportConnection)e.nextElement();
            dtm.addRow(new Object[]{con, con.getDescription()});
        }
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Connections / Datasources");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectionsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelParameters.setLayout(new BorderLayout(2, 2));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setFont(new Font("Dialog", 0, 11));
        this.jTableParameters.setFont(new Font("Dialog", 0, 11));
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Datasource type"}){
            boolean[] canEdit = new boolean[]{false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        this.jPanelParameters.add((Component)this.jScrollPane1, "Center");
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jButtonNewParameter.setFont(new Font("Dialog", 0, 11));
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.jPanelButtons.add((Component)this.jButtonNewParameter, gridBagConstraints);
        this.jButtonModifyParameter.setFont(new Font("Dialog", 0, 11));
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonModifyParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        gridBagConstraints.anchor = 18;
        this.jPanelButtons.add((Component)this.jButtonModifyParameter, gridBagConstraints);
        this.jButtonDeleteParameter.setFont(new Font("Dialog", 0, 11));
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelButtons.add((Component)this.jButtonDeleteParameter, gridBagConstraints);
        this.jPanelParameters.add((Component)this.jPanelButtons, "East");
        this.getContentPane().add((Component)this.jPanelParameters, "Center");
        this.pack();
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            IReportConnection irc = null;
            try {
                irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
            }
            catch (Exception ex) {
                return;
            }
            if (MainFrame.getMainInstance().getProperties().get("DefaultConnection") == irc) {
                MainFrame.getMainInstance().getProperties().remove("DefaultConnection");
            }
            MainFrame.getMainInstance().getConnections().removeElement(irc);
            MainFrame.getMainInstance().saveiReportConfiguration();
            ((DefaultTableModel)this.jTableParameters.getModel()).removeRow(this.jTableParameters.getSelectedRow());
            this.jTableParameters.updateUI();
        }
    }

    private void jButtonModifyParameterActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        ConnectionDialog cd = new ConnectionDialog(parent, false);
        if (this.jTableParameters.getSelectedRow() < 0) {
            return;
        }
        IReportConnection irc = null;
        try {
            irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
        }
        catch (Exception ex) {
            return;
        }
        if (irc == null) {
            return;
        }
        cd.setIReportConnection(irc);
        cd.show();
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            try {
                this.jTableParameters.getModel().setValueAt(con, this.jTableParameters.getSelectedRow(), 0);
                this.jTableParameters.getModel().setValueAt(con.getDescription(), this.jTableParameters.getSelectedRow(), 1);
            }
            catch (Exception ex) {
                return;
            }
            if (MainFrame.getMainInstance().getProperties().get("DefaultConnection") == irc) {
                MainFrame.getMainInstance().getProperties().put("DefaultConnection", con);
            }
            MainFrame.getMainInstance().getConnections().setElementAt(con, MainFrame.getMainInstance().getConnections().indexOf(irc));
            MainFrame.getMainInstance().saveiReportConfiguration();
        }
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        Frame parent = Misc.frameFromComponent(this);
        ConnectionDialog cd = new ConnectionDialog(parent, false);
        cd.show();
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
            dtm.addRow(new Object[]{con, con.getDescription()});
            MainFrame.getMainInstance().getConnections().addElement(con);
            MainFrame.getMainInstance().saveiReportConfiguration();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new ValuesDialog((Frame)new JFrame(), true).show();
    }

    public void updateConnections() {
    }

    public void setVisible(boolean visible) {
        this.updateConnections();
    }
}

