/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class JRParameterDialog
extends JDialog {
    JRParameter tmpParameter = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxIsForPrompting;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionAreaDefaultExpression;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;
    private int dialogResult;

    public JRParameterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.setClassTypes();
        this.jComboBoxType.setSelectedItem("java.lang.String");
        this.jComboBoxType.setEditable(true);
    }

    public void setClassTypes() {
        this.jComboBoxType.addItem("java.lang.String");
        this.jComboBoxType.addItem("java.lang.Object");
        this.jComboBoxType.addItem("java.lang.Boolean");
        this.jComboBoxType.addItem("java.lang.Byte");
        this.jComboBoxType.addItem("java.util.Date");
        this.jComboBoxType.addItem("java.sql.Timestamp");
        this.jComboBoxType.addItem("java.sql.Time");
        this.jComboBoxType.addItem("java.lang.Double");
        this.jComboBoxType.addItem("java.lang.Float");
        this.jComboBoxType.addItem("java.lang.Integer");
        this.jComboBoxType.addItem("java.io.InputStream");
        this.jComboBoxType.addItem("java.lang.Long");
        this.jComboBoxType.addItem("java.lang.Short");
        this.jComboBoxType.addItem("java.math.BigDecimal");
        this.jComboBoxType.addItem("dori.jasper.engine.JREmptyDataSource");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jCheckBoxIsForPrompting = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jRTextExpressionAreaDefaultExpression = new JRTextExpressionArea();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify parameter");
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRParameterDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Parameter name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel2.setText("Parameter class type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBoxType.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jComboBoxType, gridBagConstraints);
        this.jCheckBoxIsForPrompting.setText("Is for prompting");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jCheckBoxIsForPrompting, gridBagConstraints);
        this.jLabel3.setText("Default value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Parameter description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setBorder(new EtchedBorder());
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(310, 60));
        this.jRTextExpressionAreaDefaultExpression.setMinimumSize(new Dimension(0, 0));
        this.jRTextExpressionAreaDefaultExpression.setElectricScroll(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid parameter name!", "Invalid parameter!", 2);
            return;
        }
        this.tmpParameter = new JRParameter(this.jTextFieldName.getText(), "java.lang.String", this.jCheckBoxIsForPrompting.isSelected(), this.jTextAreaDescription.getText());
        if (this.jComboBoxType.getSelectedItem().toString().trim().length() != 0) {
            this.tmpParameter.setClassType(this.jComboBoxType.getSelectedItem().toString().trim());
        }
        this.tmpParameter.setDefaultValueExpression(this.jRTextExpressionAreaDefaultExpression.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRParameter tmpParameter) {
        this.jTextFieldName.setText(new String(tmpParameter.getName()));
        this.jComboBoxType.setSelectedItem(new String(tmpParameter.getClassType()));
        this.jCheckBoxIsForPrompting.setSelected(tmpParameter.isIsForPrompting());
        this.jTextAreaDescription.setText(new String(tmpParameter.getDescription()));
        this.jRTextExpressionAreaDefaultExpression.setText(new String(tmpParameter.getDefaultValueExpression()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

