/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.DateRange;
import org.jfree.data.Range;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class DateAxis
extends ValueAxis
implements Cloneable,
Serializable {
    public static final DateRange DEFAULT_DATE_RANGE = new DateRange();
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE_IN_MILLISECONDS = 2.0;
    public static final DateTickUnit DEFAULT_DATE_TICK_UNIT = new DateTickUnit(2, 1, new SimpleDateFormat());
    public static final Date DEFAULT_ANCHOR_DATE = new Date();
    private DateTickUnit tickUnit;
    private DateFormat dateFormatOverride;
    private DateTickMarkPosition tickMarkPosition = DateTickMarkPosition.START;
    private static final Timeline DEFAULT_TIMELINE = new DefaultTimeline();
    private Timeline timeline;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DateAxis) {
            DateAxis axis = (DateAxis)object;
            boolean b0 = ObjectUtils.equal((Object)this.tickUnit, (Object)axis.tickUnit);
            boolean b1 = ObjectUtils.equal((Object)this.dateFormatOverride, (Object)axis.dateFormatOverride);
            boolean b2 = ObjectUtils.equal((Object)this.tickMarkPosition, (Object)axis.tickMarkPosition);
            boolean b3 = ObjectUtils.equal((Object)this.timeline, (Object)axis.timeline);
            return b0 && b1 && b2 && b3;
        }
        return false;
    }

    public DateAxis() {
        this(null);
    }

    public DateAxis(String label) {
        this(label, DEFAULT_TIMELINE);
    }

    public DateAxis(String label, Timeline timeline) {
        super(label, DateAxis.createStandardDateTickUnits());
        this.setTickUnit(DEFAULT_DATE_TICK_UNIT, false, false);
        this.setAutoRangeMinimumSize(2.0);
        this.setRange(DEFAULT_DATE_RANGE, false, false);
        this.dateFormatOverride = null;
        this.timeline = timeline;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void setTimeline(Timeline timeline) {
        if (this.timeline != timeline) {
            this.timeline = timeline;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateTickUnit unit) {
        this.setTickUnit(unit, true, true);
    }

    public void setTickUnit(DateTickUnit unit, boolean notify, boolean turnOffAutoSelection) {
        this.tickUnit = unit;
        if (turnOffAutoSelection) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (notify) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateFormat getDateFormatOverride() {
        return this.dateFormatOverride;
    }

    public void setDateFormatOverride(DateFormat formatter) {
        this.dateFormatOverride = formatter;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("DateAxis.setRange(...): null not permitted.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        this.setRange(range, true, true);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(Date lower, Date upper) {
        if (lower.getTime() >= upper.getTime()) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower not before upper.");
        }
        this.setRange(new DateRange(lower, upper));
    }

    public void setRange(double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower >= upper.");
        }
        this.setRange(new DateRange(lower, upper));
    }

    public Date getMinimumDate() {
        Date result = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange r = (DateRange)range;
            result = r.getLowerDate();
        } else {
            result = new Date((long)range.getLowerBound());
        }
        return result;
    }

    public void setMinimumDate(Date minimumDate) {
        this.setRange(new DateRange(minimumDate, this.getMaximumDate()), true, false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getMaximumDate() {
        Date result = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange r = (DateRange)range;
            result = r.getUpperDate();
        } else {
            result = new Date((long)range.getUpperBound());
        }
        return result;
    }

    public void setMaximumDate(Date maximumDate) {
        this.setRange(new DateRange(this.getMinimumDate(), maximumDate), true, false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public DateTickMarkPosition getTickMarkPosition() {
        return this.tickMarkPosition;
    }

    public void setTickMarkPosition(DateTickMarkPosition position) {
        this.tickMarkPosition = position;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public boolean isHiddenValue(long millis) {
        return !this.timeline.containsDomainValue(millis);
    }

    public double translateValueToJava2D(double value, Rectangle2D area, RectangleEdge edge) {
        return this.valueToJava2D(value, area, edge);
    }

    public double valueToJava2D(double value, Rectangle2D area, RectangleEdge edge) {
        value = this.timeline.toTimelineValue((long)value);
        DateRange range = (DateRange)this.getRange();
        double axisMin = this.timeline.toTimelineValue(range.getLowerDate().getTime());
        double axisMax = this.timeline.toTimelineValue(range.getUpperDate());
        double result = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            double minX = area.getX();
            double maxX = area.getMaxX();
            result = this.isInverted() ? maxX + (value - axisMin) / (axisMax - axisMin) * (minX - maxX) : minX + (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            double minY = area.getMinY();
            double maxY = area.getMaxY();
            result = this.isInverted() ? minY + (value - axisMin) / (axisMax - axisMin) * (maxY - minY) : maxY - (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
        }
        return result;
    }

    public double translateDateToJava2D(Date date, Rectangle2D area, RectangleEdge edge) {
        return this.dateToJava2D(date, area, edge);
    }

    public double dateToJava2D(Date date, Rectangle2D area, RectangleEdge edge) {
        double value = date.getTime();
        return this.translateValueToJava2D(value, area, edge);
    }

    public double translateJava2DToValue(double java2DValue, Rectangle2D area, RectangleEdge edge) {
        return this.java2DToValue(java2DValue, area, edge);
    }

    public double java2DToValue(double java2DValue, Rectangle2D area, RectangleEdge edge) {
        DateRange range = (DateRange)this.getRange();
        double axisMin = this.timeline.toTimelineValue(range.getLowerDate());
        double axisMax = this.timeline.toTimelineValue(range.getUpperDate());
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            min = area.getMaxY();
            max = area.getY();
        }
        double result = this.isInverted() ? axisMax - (java2DValue - min) / (max - min) * (axisMax - axisMin) : axisMin + (java2DValue - min) / (max - min) * (axisMax - axisMin);
        result = this.timeline.toTimelineValue((long)result);
        return result;
    }

    public Date calculateLowestVisibleTickValue(DateTickUnit unit) {
        return this.nextStandardDate(this.getMinimumDate(), unit);
    }

    public Date calculateHighestVisibleTickValue(DateTickUnit unit) {
        return this.previousStandardDate(this.getMaximumDate(), unit);
    }

    protected Date previousStandardDate(Date date, DateTickUnit unit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int count = unit.getCount();
        int current = calendar.get(unit.getCalendarField());
        int value = count * (current / count);
        switch (unit.getUnit()) {
            case 6: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                int hours = calendar.get(11);
                int minutes = calendar.get(12);
                int seconds = calendar.get(13);
                calendar.set(years, months, days, hours, minutes, seconds);
                calendar.set(14, value);
                return calendar.getTime();
            }
            case 5: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                int hours = calendar.get(11);
                int minutes = calendar.get(12);
                int milliseconds = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 500 : 999);
                calendar.set(14, milliseconds);
                calendar.set(years, months, days, hours, minutes, value);
                return calendar.getTime();
            }
            case 4: {
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                int hours = calendar.get(11);
                int seconds = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 30 : 59);
                calendar.clear(14);
                calendar.set(years, months, days, hours, value, seconds);
                return calendar.getTime();
            }
            case 3: {
                int seconds;
                int minutes;
                int years = calendar.get(1);
                int months = calendar.get(2);
                int days = calendar.get(5);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    minutes = 0;
                    seconds = 0;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    minutes = 30;
                    seconds = 0;
                } else {
                    minutes = 59;
                    seconds = 59;
                }
                calendar.clear(14);
                calendar.set(years, months, days, value, minutes, seconds);
                return calendar.getTime();
            }
            case 2: {
                int hours;
                int years = calendar.get(1);
                int months = calendar.get(2);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    hours = 0;
                    boolean minutes = false;
                    boolean seconds = false;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    hours = 12;
                    boolean minutes = false;
                    boolean seconds = false;
                } else {
                    hours = 23;
                    int minutes = 59;
                    int seconds = 59;
                }
                calendar.clear(14);
                calendar.set(years, months, value, hours, 0, 0);
                long result = calendar.getTime().getTime();
                if (result > date.getTime()) {
                    calendar.set(years, months, value - 1, hours, 0, 0);
                }
                return calendar.getTime();
            }
            case 1: {
                int years = calendar.get(1);
                calendar.clear(14);
                calendar.set(years, value, 1, 0, 0, 0);
                Month month = new Month(calendar.getTime());
                Date standardDate = this.calculateDateForPosition(month, this.tickMarkPosition);
                long millis = standardDate.getTime();
                if (millis > date.getTime()) {
                    month = (Month)month.previous();
                    standardDate = this.calculateDateForPosition(month, this.tickMarkPosition);
                }
                return standardDate;
            }
            case 0: {
                int months = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 6 : 12);
                calendar.clear(14);
                calendar.set(value, months, 1, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    private Date calculateDateForPosition(RegularTimePeriod period, DateTickMarkPosition position) {
        Date result = null;
        if (position == DateTickMarkPosition.START) {
            result = new Date(period.getFirstMillisecond());
        } else if (position == DateTickMarkPosition.MIDDLE) {
            result = new Date(period.getMiddleMillisecond());
        } else if (position == DateTickMarkPosition.END) {
            result = new Date(period.getLastMillisecond());
        }
        return result;
    }

    protected Date nextStandardDate(Date date, DateTickUnit unit) {
        Date previous = this.previousStandardDate(date, unit);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(previous);
        calendar.add(unit.getCalendarField(), unit.getCount());
        return calendar.getTime();
    }

    public static TickUnitSource createStandardDateTickUnits() {
        TickUnits units = new TickUnits();
        units.add(new DateTickUnit(6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 5, 6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 10, 6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 25, 6, 5, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 50, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 100, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 250, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(6, 500, 6, 50, new SimpleDateFormat("HH:mm:ss.SSS")));
        units.add(new DateTickUnit(5, 1, 6, 50, new SimpleDateFormat("HH:mm:ss")));
        units.add(new DateTickUnit(5, 5, 5, 1, new SimpleDateFormat("HH:mm:ss")));
        units.add(new DateTickUnit(5, 10, 5, 1, new SimpleDateFormat("HH:mm:ss")));
        units.add(new DateTickUnit(5, 30, 5, 5, new SimpleDateFormat("HH:mm:ss")));
        units.add(new DateTickUnit(4, 1, 5, 5, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(4, 2, 5, 10, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(4, 5, 4, 1, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(4, 10, 4, 1, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(4, 15, 4, 5, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(4, 20, 4, 5, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(4, 30, 4, 5, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(3, 1, 4, 5, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(3, 2, 4, 10, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(3, 4, 4, 30, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(3, 6, 3, 1, new SimpleDateFormat("HH:mm")));
        units.add(new DateTickUnit(3, 12, 3, 1, new SimpleDateFormat("d-MMM, HH:mm")));
        units.add(new DateTickUnit(2, 1, 3, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 2, 3, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 7, 2, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(2, 15, 2, 1, new SimpleDateFormat("d-MMM")));
        units.add(new DateTickUnit(1, 1, 2, 1, new SimpleDateFormat("MMM-yyyy")));
        units.add(new DateTickUnit(1, 2, 2, 1, new SimpleDateFormat("MMM-yyyy")));
        units.add(new DateTickUnit(1, 3, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        units.add(new DateTickUnit(1, 4, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        units.add(new DateTickUnit(1, 6, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        units.add(new DateTickUnit(0, 1, 1, 1, new SimpleDateFormat("yyyy")));
        units.add(new DateTickUnit(0, 2, 1, 3, new SimpleDateFormat("yyyy")));
        units.add(new DateTickUnit(0, 5, 0, 1, new SimpleDateFormat("yyyy")));
        units.add(new DateTickUnit(0, 10, 0, 1, new SimpleDateFormat("yyyy")));
        units.add(new DateTickUnit(0, 25, 0, 5, new SimpleDateFormat("yyyy")));
        units.add(new DateTickUnit(0, 50, 0, 10, new SimpleDateFormat("yyyy")));
        units.add(new DateTickUnit(0, 100, 0, 20, new SimpleDateFormat("yyyy")));
        return units;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            long lower;
            ValueAxisPlot vap = (ValueAxisPlot)((Object)plot);
            Range r = vap.getDataRange(this);
            if (r == null) {
                r = new DateRange();
            }
            long upper = this.timeline.toTimelineValue((long)r.getUpperBound());
            long fixedAutoRange = (long)this.getFixedAutoRange();
            if ((double)fixedAutoRange > 0.0) {
                lower = upper - fixedAutoRange;
            } else {
                long minRange;
                lower = this.timeline.toTimelineValue((long)r.getLowerBound());
                double range = upper - lower;
                if (range < (double)(minRange = (long)this.getAutoRangeMinimumSize())) {
                    long expand = (long)((double)minRange - range) / 2L;
                    upper += expand;
                    lower -= expand;
                }
                upper += (long)(range * this.getUpperMargin());
                lower -= (long)(range * this.getLowerMargin());
            }
            upper = this.timeline.toMillisecond(upper);
            lower = this.timeline.toMillisecond(lower);
            DateRange dr = new DateRange(new Date(lower), new Date(upper));
            this.setRange(dr, false, false);
        }
    }

    protected void selectAutoTickUnit(Graphics2D g2, Rectangle2D drawArea, Rectangle2D dataArea, RectangleEdge edge) {
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            this.selectHorizontalAutoTickUnit(g2, drawArea, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            this.selectVerticalAutoTickUnit(g2, drawArea, dataArea, edge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D g2, Rectangle2D drawArea, Rectangle2D dataArea, RectangleEdge edge) {
        double x2;
        double unit2Width;
        double x1;
        double candidate1UnitWidth;
        TickUnitSource tickUnits = this.getStandardTickUnits();
        double zero = this.translateValueToJava2D(0.0, dataArea, edge);
        double estimate1 = this.getRange().getLength() / 10.0;
        DateTickUnit candidate1 = (DateTickUnit)tickUnits.getCeilingTickUnit(estimate1);
        double labelWidth1 = this.estimateMaximumTickLabelWidth(g2, candidate1);
        double estimate2 = labelWidth1 / (candidate1UnitWidth = Math.abs((x1 = this.translateValueToJava2D(candidate1.getSize(), dataArea, edge)) - zero)) * candidate1.getSize();
        DateTickUnit candidate2 = (DateTickUnit)tickUnits.getCeilingTickUnit(estimate2);
        double labelWidth2 = this.estimateMaximumTickLabelWidth(g2, candidate2);
        DateTickUnit finalUnit = labelWidth2 < (unit2Width = Math.abs((x2 = this.translateValueToJava2D(candidate2.getSize(), dataArea, edge)) - zero)) ? candidate2 : (DateTickUnit)tickUnits.getLargerTickUnit(candidate2);
        this.setTickUnit(finalUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D g2, Rectangle2D drawArea, Rectangle2D dataArea, RectangleEdge edge) {
        double y2;
        double unit2Height;
        double y1;
        double candidate1UnitHeight;
        TickUnitSource tickUnits = this.getStandardTickUnits();
        double zero = this.translateValueToJava2D(0.0, dataArea, edge);
        double estimate1 = this.getRange().getLength() / 10.0;
        DateTickUnit candidate1 = (DateTickUnit)tickUnits.getCeilingTickUnit(estimate1);
        double labelHeight1 = this.estimateMaximumTickLabelHeight(g2, candidate1);
        double estimate2 = labelHeight1 / (candidate1UnitHeight = Math.abs((y1 = this.translateValueToJava2D(candidate1.getSize(), dataArea, edge)) - zero)) * candidate1.getSize();
        DateTickUnit candidate2 = (DateTickUnit)tickUnits.getCeilingTickUnit(estimate2);
        double labelHeight2 = this.estimateMaximumTickLabelHeight(g2, candidate2);
        DateTickUnit finalUnit = labelHeight2 < (unit2Height = Math.abs((y2 = this.translateValueToJava2D(candidate2.getSize(), dataArea, edge)) - zero)) ? candidate2 : (DateTickUnit)tickUnits.getLargerTickUnit(candidate2);
        this.setTickUnit(finalUnit, false, false);
    }

    private double estimateMaximumTickLabelWidth(Graphics2D g2, DateTickUnit unit) {
        Insets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.left + tickLabelInsets.right;
        Font tickLabelFont = this.getTickLabelFont();
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lm = tickLabelFont.getLineMetrics("ABCxyz", frc);
        if (this.isVerticalTickLabels()) {
            result += (double)lm.getHeight();
        } else {
            DateRange range = (DateRange)this.getRange();
            Date lower = range.getLowerDate();
            Date upper = range.getUpperDate();
            String lowerStr = null;
            String upperStr = null;
            DateFormat formatter = this.getDateFormatOverride();
            if (formatter != null) {
                lowerStr = formatter.format(lower);
                upperStr = formatter.format(upper);
            } else {
                lowerStr = this.tickUnit.dateToString(lower);
                upperStr = this.tickUnit.dateToString(upper);
            }
            FontMetrics fm = g2.getFontMetrics(tickLabelFont);
            double w1 = fm.stringWidth(lowerStr);
            double w2 = fm.stringWidth(upperStr);
            result += Math.max(w1, w2);
        }
        return result;
    }

    private double estimateMaximumTickLabelHeight(Graphics2D g2, DateTickUnit unit) {
        Insets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.top + tickLabelInsets.bottom;
        Font tickLabelFont = this.getTickLabelFont();
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics lm = tickLabelFont.getLineMetrics("ABCxyz", frc);
        if (!this.isVerticalTickLabels()) {
            result += (double)lm.getHeight();
        } else {
            DateRange range = (DateRange)this.getRange();
            Date lower = range.getLowerDate();
            Date upper = range.getUpperDate();
            String lowerStr = null;
            String upperStr = null;
            DateFormat formatter = this.getDateFormatOverride();
            if (formatter != null) {
                lowerStr = formatter.format(lower);
                upperStr = formatter.format(upper);
            } else {
                lowerStr = unit.dateToString(lower);
                upperStr = unit.dateToString(upper);
            }
            FontMetrics fm = g2.getFontMetrics(tickLabelFont);
            double w1 = fm.stringWidth(lowerStr);
            double w2 = fm.stringWidth(upperStr);
            result += Math.max(w1, w2);
        }
        return result;
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        List result = null;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            result = this.refreshTicksHorizontal(g2, state.getCursor(), plotArea, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            result = this.refreshTicksVertical(g2, state.getCursor(), plotArea, dataArea, edge);
        }
        return result;
    }

    public List refreshTicksHorizontal(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<DateTick> result = new ArrayList<DateTick>();
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, plotArea, dataArea, edge);
        }
        DateTickUnit unit = this.getTickUnit();
        Date tickDate = this.calculateLowestVisibleTickValue(unit);
        Date upperDate = this.getMaximumDate();
        block5: while (tickDate.before(upperDate)) {
            double angle;
            TextAnchor rotationAnchor;
            TextAnchor anchor;
            float y;
            float x;
            String tickLabel;
            if (!this.isHiddenValue(tickDate.getTime())) {
                double xx = this.translateDateToJava2D(tickDate, dataArea, edge);
                DateFormat formatter = this.getDateFormatOverride();
                tickLabel = formatter != null ? formatter.format(tickDate) : this.tickUnit.dateToString(tickDate);
                x = (float)xx;
                y = 0.0f;
                anchor = null;
                rotationAnchor = null;
                angle = 0.0;
                Insets tickLabelInsets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                    if (edge == RectangleEdge.TOP) {
                        y = (float)(cursor - (double)tickLabelInsets.right);
                        angle = 1.5707963267948966;
                    } else {
                        y = (float)(cursor + (double)tickLabelInsets.right);
                        angle = -1.5707963267948966;
                    }
                } else if (edge == RectangleEdge.TOP) {
                    y = (float)(cursor - (double)tickLabelInsets.bottom);
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    y = (float)(cursor + (double)tickLabelInsets.top);
                    anchor = TextAnchor.TOP_CENTER;
                    rotationAnchor = TextAnchor.TOP_CENTER;
                }
            } else {
                tickDate = unit.rollDate(tickDate);
                continue;
            }
            DateTick tick = new DateTick(tickDate, tickLabel, x, y, anchor, rotationAnchor, angle);
            result.add(tick);
            tickDate = unit.addToDate(tickDate);
            switch (unit.getUnit()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: {
                    tickDate = this.calculateDateForPosition(new Month(tickDate), this.tickMarkPosition);
                    continue block5;
                }
                case 0: {
                    tickDate = this.calculateDateForPosition(new Year(tickDate), this.tickMarkPosition);
                    continue block5;
                }
            }
        }
        return result;
    }

    public List refreshTicksVertical(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<DateTick> result = new ArrayList<DateTick>();
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, plotArea, dataArea, edge);
        }
        DateTickUnit unit = this.getTickUnit();
        Date tickDate = this.calculateLowestVisibleTickValue(unit);
        Date upperDate = this.getMaximumDate();
        while (tickDate.before(upperDate)) {
            if (!this.isHiddenValue(tickDate.getTime())) {
                double yy = this.translateDateToJava2D(tickDate, dataArea, edge);
                DateFormat formatter = this.getDateFormatOverride();
                String tickLabel = formatter != null ? formatter.format(tickDate) : this.tickUnit.dateToString(tickDate);
                float x = 0.0f;
                float y = (float)yy;
                TextAnchor anchor = null;
                TextAnchor rotationAnchor = null;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    anchor = TextAnchor.BOTTOM_CENTER;
                    rotationAnchor = TextAnchor.BOTTOM_CENTER;
                    if (edge == RectangleEdge.LEFT) {
                        x = (float)(cursor - (double)this.getTickLabelInsets().bottom);
                        angle = -1.5707963267948966;
                    } else {
                        x = (float)(cursor + (double)this.getTickLabelInsets().bottom);
                        angle = 1.5707963267948966;
                    }
                } else if (edge == RectangleEdge.LEFT) {
                    x = (float)(cursor - (double)this.getTickLabelInsets().right);
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    x = (float)(cursor + (double)this.getTickLabelInsets().left);
                    anchor = TextAnchor.CENTER_LEFT;
                    rotationAnchor = TextAnchor.CENTER_LEFT;
                }
                DateTick tick = new DateTick(tickDate, tickLabel, x, y, anchor, rotationAnchor, angle);
                result.add(tick);
                tickDate = unit.addToDate(tickDate);
                continue;
            }
            tickDate = unit.rollDate(tickDate);
        }
        return result;
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (!this.isVisible()) {
            AxisState state = new AxisState(cursor);
            List ticks = this.refreshTicks(g2, state, plotArea, dataArea, edge);
            state.setTicks(ticks);
            return state;
        }
        AxisState state = this.drawTickMarksAndLabels(g2, cursor, plotArea, dataArea, edge);
        state = this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, state);
        return state;
    }

    public Object clone() throws CloneNotSupportedException {
        DateAxis clone = (DateAxis)super.clone();
        if (this.dateFormatOverride != null) {
            clone.dateFormatOverride = (DateFormat)this.dateFormatOverride.clone();
        }
        return clone;
    }

    private static class DefaultTimeline
    implements Timeline,
    Serializable {
        private DefaultTimeline() {
        }

        public long toTimelineValue(long millisecond) {
            return millisecond;
        }

        public long toTimelineValue(Date date) {
            return date.getTime();
        }

        public long toMillisecond(long value) {
            return value;
        }

        public boolean containsDomainValue(long millisecond) {
            return true;
        }

        public boolean containsDomainValue(Date date) {
            return true;
        }

        public boolean containsDomainRange(long from, long to) {
            return true;
        }

        public boolean containsDomainRange(Date from, Date to) {
            return true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return object instanceof DefaultTimeline;
        }
    }
}

