/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.text.NumberFormat;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYZItemLabelGenerator;
import org.jfree.data.XYZDataset;

public class StandardXYZItemLabelGenerator
extends StandardXYItemLabelGenerator
implements XYZItemLabelGenerator {
    private NumberFormat zFormat;

    public StandardXYZItemLabelGenerator() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYZItemLabelGenerator(NumberFormat xFormat, NumberFormat yFormat, NumberFormat zFormat) {
        super("{0}: ({1}, {2})", "{2}", xFormat, yFormat);
        this.zFormat = zFormat;
    }

    public NumberFormat getZFormat() {
        return this.zFormat;
    }

    public String generateToolTip(XYZDataset data, int series, int item) {
        String result = data.getSeriesName(series) + ": ";
        Number x = data.getXValue(series, item);
        result = result + "x: " + this.getXFormat().format(x);
        Number y = data.getYValue(series, item);
        result = result + "y: " + this.getYFormat().format(y);
        Number z = data.getZValue(series, item);
        result = z != null ? result + ", z: " + this.zFormat.format(z) : result + ", z: null";
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof StandardXYZItemLabelGenerator) {
            StandardXYZItemLabelGenerator generator = (StandardXYZItemLabelGenerator)o;
            return this.getXFormat().equals(generator.getXFormat()) && this.getYFormat().equals(generator.getYFormat()) && this.getZFormat().equals(generator.getZFormat());
        }
        return false;
    }
}

