/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.Vector;

public class Tree
extends Panel {
    private static Font fFont = new Font("Dialog", 0, 12);
    private static FontMetrics fMetrics = Toolkit.getDefaultToolkit().getFontMetrics(fFont);
    private static int iRowHeight = Tree.getMaxHeight(fMetrics);
    private static int iIndentWidth = 12;
    private int iMaxTextLength;
    private Dimension dMinimum;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iFirstRow;
    private int iTreeWidth;
    private int iTreeHeight;
    private int iX;
    private int iY;
    private Vector vData = new Vector();
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;

    public Tree() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n4 - this.iSbHeight;
        this.iWidth = n3 - this.iSbWidth;
        this.sbHoriz.reshape(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.reshape(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void removeAll() {
        this.vData = new Vector();
        this.iRowCount = 0;
        this.adjustScroll();
        this.iMaxTextLength = 10;
        this.repaint();
    }

    public void addRow(String string, String string2, String string3, int n) {
        String[] stringArray = new String[4];
        if (string2 == null) {
            string2 = "";
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
        stringArray[3] = "" + n;
        this.vData.addElement(stringArray);
        int n2 = fMetrics.stringWidth(string2);
        if (n2 > this.iMaxTextLength) {
            this.iMaxTextLength = n2;
        }
        ++this.iRowCount;
    }

    public void addRow(String string, String string2) {
        this.addRow(string, string2, null, 0);
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        this.iTreeHeight = iRowHeight * (this.iRowCount + 1);
        this.iTreeWidth = this.iMaxTextLength * 2;
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iTreeWidth);
        int n = this.iY / iRowHeight;
        int n2 = this.iHeight / iRowHeight;
        this.sbVert.setValues(n, n2, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = iRowHeight * this.sbVert.getValue();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void paint(Graphics graphics) {
        if (graphics == null || this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(fFont);
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        int[] nArray = new int[100];
        String[] stringArray = new String[100];
        stringArray[0] = "";
        int n = 0;
        int n2 = iRowHeight;
        n2 -= this.iY;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.iRowCount) {
            String[] stringArray2 = (String[])this.vData.elementAt(n3);
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            String string3 = stringArray2[2];
            int n4 = n;
            while (n4 > 0) {
                if (string.startsWith(stringArray[n4])) break;
                --n4;
            }
            if (stringArray[n4].length() < string.length()) {
                ++n4;
            }
            if (!bl || n4 <= n) {
                bl = string3 != null && string3.equals("+");
                stringArray[n4] = string;
                int n5 = iIndentWidth * n4 - this.iX;
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(n5, n2, n5 + iIndentWidth, n2);
                this.gImage.drawLine(n5, n2, n5, nArray[n4]);
                nArray[n4 + 1] = n2;
                int n6 = n2 + iRowHeight / 3;
                int n7 = n5 + iIndentWidth * 2;
                if (string3 != null) {
                    int n8 = n4 + 1;
                    nArray[n8] = nArray[n8] + 4;
                    int n9 = Integer.parseInt(stringArray2[3]);
                    this.gImage.setColor(n9 == 0 ? Color.white : new Color(n9));
                    this.gImage.fillRect(n5 + iIndentWidth - 3, n2 - 3, 7, 7);
                    this.gImage.setColor(Color.black);
                    this.gImage.drawRect(n5 + iIndentWidth - 4, n2 - 4, 8, 8);
                    this.gImage.drawLine(n5 + iIndentWidth - 2, n2, n5 + iIndentWidth + 2, n2);
                    if (string3.equals("+")) {
                        this.gImage.drawLine(n5 + iIndentWidth, n2 - 2, n5 + iIndentWidth, n2 + 2);
                    }
                } else {
                    n7 -= iIndentWidth;
                }
                this.gImage.setColor(Color.black);
                this.gImage.drawString(string2, n7, n6);
                n = n4;
                n2 += iRowHeight;
            }
            ++n3;
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.minimumSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return this.dMinimum;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        String string;
        String[] stringArray;
        if (iRowHeight == 0 || n > this.iWidth || n2 > this.iHeight) {
            return true;
        }
        n2 += iRowHeight / 2;
        String[] stringArray2 = new String[100];
        stringArray2[0] = "";
        int n3 = 0;
        int n4 = iRowHeight;
        boolean bl = false;
        int n5 = 0;
        n2 += this.iY;
        while (n5 < this.iRowCount) {
            stringArray = (String[])this.vData.elementAt(n5);
            string = stringArray[0];
            String string2 = stringArray[2];
            int n6 = n3;
            while (n6 > 0) {
                if (string.startsWith(stringArray2[n6])) break;
                --n6;
            }
            if (stringArray2[n6].length() < string.length()) {
                ++n6;
            }
            if (!bl || n6 <= n3) {
                if (n4 <= n2 && n4 + iRowHeight > n2) break;
                stringArray2[n6] = string;
                bl = string2 != null && string2.equals("+");
                n3 = n6;
                n4 += iRowHeight;
            }
            ++n5;
        }
        if (n5 >= 0 && n5 < this.iRowCount) {
            stringArray = (String[])this.vData.elementAt(n5);
            string = stringArray[2];
            if (string != null && string.equals("+")) {
                string = "-";
            } else if (string != null && string.equals("-")) {
                string = "+";
            }
            stringArray[2] = string;
            this.vData.setElementAt(stringArray, n5);
            this.repaint();
        }
        return true;
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 2;
    }
}

