/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseDatasetParameter;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDatasetRun
implements JRDatasetRun,
Serializable {
    private static final long serialVersionUID = 10100L;
    protected String datasetName;
    protected JRExpression parametersMapExpression;
    protected JRDatasetParameter[] parameters;
    protected JRExpression connectionExpression;
    protected JRExpression dataSourceExpression;

    protected JRBaseDatasetRun() {
    }

    protected JRBaseDatasetRun(JRDatasetRun datasetRun, JRBaseObjectFactory factory) {
        if (factory != null) {
            factory.put(datasetRun, this);
        }
        this.datasetName = datasetRun.getDatasetName();
        this.parametersMapExpression = factory.getExpression(datasetRun.getParametersMapExpression());
        this.connectionExpression = factory.getExpression(datasetRun.getConnectionExpression());
        this.dataSourceExpression = factory.getExpression(datasetRun.getDataSourceExpression());
        JRDatasetParameter[] datasetParams = datasetRun.getParameters();
        if (datasetParams != null && datasetParams.length > 0) {
            this.parameters = new JRBaseDatasetParameter[datasetParams.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory != null ? factory.getDatasetParameter(datasetParams[i]) : new JRBaseDatasetParameter(datasetParams[i], null);
            }
        }
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }
}

