/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRCrosstabExpressionEvaluator;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabCell;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabMeasure;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jfree.data.general.Dataset;

public class JRFillCrosstab
extends JRFillElement
implements JRCrosstab {
    protected final JRCrosstab parentCrosstab;
    protected JRFillCrosstabDataset dataset;
    protected JRFillCrosstabRowGroup[] rowGroups;
    protected Map rowGroupsMap;
    protected JRFillCrosstabColumnGroup[] columnGroups;
    protected Map columnGroupsMap;
    protected JRFillCrosstabMeasure[] measures;
    protected BucketingService bucketingService;
    protected JRFillVariable[] variables;
    protected Map variablesMap;
    protected JRFillCrosstabParameter[] parameters;
    protected Map parametersMap;
    protected JRCrosstabExpressionEvaluator crosstabEvaluator;
    protected JRFillCrosstabCell[][] crossCells;
    protected JRFillCellContents whenNoDataCell;
    protected boolean hasData;
    protected HeaderCell[][] columnHeadersData;
    protected HeaderCell[][] rowHeadersData;
    protected CrosstabCell[][] cellData;
    protected MeasureDefinition.MeasureValue[] grandTotals;
    protected int[] rowYOffsets;
    protected int[] rowHeadersXOffsets;
    protected int[] columnXOffsets;
    protected int[] columnHeadersYOffsets;
    private boolean[] columnBreakable;
    private boolean[] rowBreakable;
    protected List printCells;
    protected int rowIndex;
    protected int columnIndex;
    protected int lastColumnIndex;
    private List fillColumnHeaders;
    private boolean percentage;

    public JRFillCrosstab(JRBaseFiller filler, JRCrosstab crosstab, JRFillObjectFactory factory) {
        super(filler, crosstab, factory);
        this.parentCrosstab = crosstab;
        this.loadEvaluator(filler.getJasperReport());
        JRFillObjectFactory crosstabFactory = new JRFillObjectFactory(filler, this);
        this.copyRowGroups(crosstab, crosstabFactory);
        this.setRowHeadersXOffsets();
        this.copyColumnGroups(crosstab, crosstabFactory);
        this.setColumnHeadersYOffsets();
        this.copyMeasures(crosstab, crosstabFactory);
        this.copyCells(crosstab, crosstabFactory);
        this.whenNoDataCell = crosstabFactory.getCell(crosstab.getWhenNoDataCell());
        this.dataset = factory.getCrosstabDataset(crosstab.getDataset(), this);
        this.copyParameters(crosstab, factory);
        this.initVariables();
        this.printCells = new ArrayList();
    }

    private void copyRowGroups(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        this.rowGroups = new JRFillCrosstabRowGroup[groups.length];
        this.rowGroupsMap = new HashMap();
        for (int i = 0; i < groups.length; ++i) {
            JRFillCrosstabRowGroup group;
            this.rowGroups[i] = group = factory.getCrosstabRowGroup(groups[i]);
            this.rowGroupsMap.put(group.getName(), new Integer(i));
        }
    }

    private void setRowHeadersXOffsets() {
        this.rowHeadersXOffsets = new int[this.rowGroups.length + 1];
        this.rowHeadersXOffsets[0] = 0;
        for (int i = 0; i < this.rowGroups.length; ++i) {
            this.rowHeadersXOffsets[i + 1] = this.rowHeadersXOffsets[i] + this.rowGroups[i].getWidth();
        }
    }

    private void copyColumnGroups(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        this.columnGroups = new JRFillCrosstabColumnGroup[groups.length];
        this.columnGroupsMap = new HashMap();
        for (int i = 0; i < groups.length; ++i) {
            JRFillCrosstabColumnGroup group;
            this.columnGroups[i] = group = factory.getCrosstabColumnGroup(groups[i]);
            this.columnGroupsMap.put(group.getName(), new Integer(i));
        }
    }

    private void setColumnHeadersYOffsets() {
        this.columnHeadersYOffsets = new int[this.columnGroups.length + 1];
        this.columnHeadersYOffsets[0] = 0;
        for (int i = 0; i < this.columnGroups.length; ++i) {
            this.columnHeadersYOffsets[i + 1] = this.columnHeadersYOffsets[i] + this.columnGroups[i].getHeight();
        }
    }

    private void copyMeasures(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabMeasure[] crossMeasures = crosstab.getMeasures();
        this.measures = new JRFillCrosstabMeasure[crossMeasures.length];
        for (int i = 0; i < crossMeasures.length; ++i) {
            this.measures[i] = factory.getCrosstabMeasure(crossMeasures[i]);
        }
    }

    private void copyParameters(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabParameter[] crossParams = crosstab.getParameters();
        this.parameters = new JRFillCrosstabParameter[crossParams.length];
        this.parametersMap = new HashMap();
        for (int i = 0; i < crossParams.length; ++i) {
            this.parameters[i] = factory.getCrosstabParameter(crossParams[i]);
            this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
        }
    }

    private void copyCells(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabCell[][] crosstabCells = crosstab.getCells();
        this.crossCells = new JRFillCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
        for (int i = 0; i <= this.rowGroups.length; ++i) {
            for (int j = 0; j <= this.columnGroups.length; ++j) {
                if (crosstabCells[i][j] == null) continue;
                this.crossCells[i][j] = factory.getCrosstabCell(crosstabCells[i][j]);
            }
        }
    }

    private void initVariables() {
        int i;
        this.variables = new JRFillVariable[this.rowGroups.length + this.columnGroups.length + this.measures.length];
        int c = 0;
        for (i = 0; i < this.rowGroups.length; ++i) {
            this.variables[c++] = this.rowGroups[i].getFillVariable();
        }
        for (i = 0; i < this.columnGroups.length; ++i) {
            this.variables[c++] = this.columnGroups[i].getFillVariable();
        }
        for (i = 0; i < this.measures.length; ++i) {
            this.variables[c++] = this.measures[i].getFillVariable();
        }
        this.variablesMap = new HashMap();
        for (i = 0; i < this.variables.length; ++i) {
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
    }

    protected void loadEvaluator(JasperReport jasperReport) {
        try {
            JREvaluator evaluator = JRDefaultCompiler.getInstance().loadEvaluator(jasperReport, this.parentCrosstab);
            this.crosstabEvaluator = new JRCrosstabExpressionEvaluator(evaluator);
        }
        catch (JRException e) {
            throw new JRRuntimeException("Could not load evaluator for crosstab " + this.getName(), e);
        }
    }

    private BucketingService createService(byte evaluation) throws JRException {
        ArrayList<BucketDefinition> rowBuckets = new ArrayList<BucketDefinition>(this.rowGroups.length);
        for (int i = 0; i < this.rowGroups.length; ++i) {
            rowBuckets.add(this.createServiceBucket(this.rowGroups[i], evaluation));
        }
        ArrayList<BucketDefinition> colBuckets = new ArrayList<BucketDefinition>(this.columnGroups.length);
        for (int i = 0; i < this.columnGroups.length; ++i) {
            colBuckets.add(this.createServiceBucket(this.columnGroups[i], evaluation));
        }
        this.percentage = false;
        ArrayList<MeasureDefinition> measureList = new ArrayList<MeasureDefinition>(this.measures.length);
        for (int i = 0; i < this.measures.length; ++i) {
            measureList.add(this.createServiceMeasure(this.measures[i]));
            this.percentage |= this.measures[i].getPercentageOfType() == 1;
        }
        return new BucketingService(rowBuckets, colBuckets, measureList, this.dataset.isDataPreSorted(), this.percentage);
    }

    private BucketDefinition createServiceBucket(JRCrosstabGroup group, byte evaluation) throws JRException {
        JRCrosstabBucket bucket = group.getBucket();
        Comparator comparator = null;
        JRExpression comparatorExpression = bucket.getComparatorExpression();
        if (comparatorExpression != null) {
            comparator = (Comparator)this.evaluateExpression(comparatorExpression, evaluation);
        }
        byte totalPosition = group.getTotalPosition();
        return new BucketDefinition(bucket.getExpression().getValueClass(), comparator, bucket.getOrder(), totalPosition);
    }

    private MeasureDefinition createServiceMeasure(JRFillCrosstabMeasure measure) {
        return new MeasureDefinition(measure.getValueClass(), measure.getCalculation(), measure.getIncrementerFactory());
    }

    public JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.crosstabEvaluator;
    }

    protected void reset() {
        super.reset();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].setValue(null);
            this.variables[i].setInitialized(true);
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.dataset.evaluateDatasetRun(evaluation);
            this.initEvaluator(evaluation);
            this.bucketingService.processData();
            this.hasData = this.bucketingService.hasData();
            if (this.hasData) {
                this.columnHeadersData = this.bucketingService.getColumnHeaders();
                this.rowHeadersData = this.bucketingService.getRowHeaders();
                this.cellData = this.bucketingService.getCrosstabCells();
                if (this.percentage) {
                    this.grandTotals = this.bucketingService.getGrandTotals();
                }
                this.columnXOffsets = JRFillCrosstab.computeOffsets(this.columnHeadersData, this.columnGroups, true);
                this.columnBreakable = JRFillCrosstab.computeBreakableHeaders(this.columnHeadersData, this.columnGroups, this.columnXOffsets, true);
                this.rowYOffsets = JRFillCrosstab.computeOffsets(this.rowHeadersData, this.rowGroups, false);
                this.rowBreakable = JRFillCrosstab.computeBreakableHeaders(this.rowHeadersData, this.rowGroups, this.rowYOffsets, false);
            }
            this.initFill();
        }
    }

    private void initFill() {
        this.rowIndex = 0;
        this.columnIndex = 0;
        this.lastColumnIndex = 0;
    }

    protected void initEvaluator(byte evaluation) throws JRException {
        Map parameterValues = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), evaluation, true);
        ResourceBundle resBdl = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (resBdl == null) {
            JRFillParameter resourceBundleParam = (JRFillParameter)this.filler.getParametersMap().get("REPORT_RESOURCE_BUNDLE");
            parameterValues.put("REPORT_RESOURCE_BUNDLE", resourceBundleParam.getValue());
        }
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        for (int i = 0; i < this.parameters.length; ++i) {
            Object value = parameterValues.get(this.parameters[i].getName());
            this.parameters[i].setValue(value);
        }
        JRFillParameter resourceBundleParam = (JRFillParameter)this.parametersMap.get("REPORT_RESOURCE_BUNDLE");
        this.crosstabEvaluator.init(this.parametersMap, this.variablesMap, resourceBundleParam, this.filler.getWhenResourceMissingType());
    }

    protected void initBucketingService() {
        if (this.bucketingService == null) {
            try {
                this.bucketingService = this.createService((byte)1);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Could not create bucketing service", e);
            }
        } else {
            this.bucketingService.clear();
        }
    }

    private static int[] computeOffsets(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, boolean width) {
        int[] offsets = new int[headersData[0].length + 1];
        offsets[0] = 0;
        for (int i = 0; i < headersData[0].length; ++i) {
            int size = 0;
            for (int j = groups.length - 1; j >= 0; --j) {
                JRFillCellContents cell;
                if (headersData[j][i] == null) continue;
                JRFillCellContents jRFillCellContents = cell = headersData[j][i].isTotal() ? groups[j].getFillTotalHeader() : groups[j].getFillHeader();
                size = cell == null ? 0 : (width ? cell.getWidth() : cell.getHeight());
                break;
            }
            offsets[i + 1] = offsets[i] + size;
        }
        return offsets;
    }

    private static boolean[] computeBreakableHeaders(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, int[] offsets, boolean width) {
        boolean[] breakable = new boolean[headersData[0].length];
        for (int i = 0; i < breakable.length; ++i) {
            breakable[i] = true;
        }
        for (int j = 0; j < groups.length; ++j) {
            JRFillCellContents fillHeader = groups[j].getFillHeader();
            if (fillHeader == null) continue;
            int size = width ? fillHeader.getWidth() : fillHeader.getHeight();
            for (int i = 0; i < headersData[0].length; ++i) {
                int k;
                HeaderCell headerCell = headersData[j][i];
                if (headerCell == null || headerCell.isTotal() || headerCell.getLevelSpan() <= 1) continue;
                int span = headerCell.getLevelSpan();
                for (k = i + 1; k < i + span && offsets[k] - offsets[i] < size; ++k) {
                    breakable[k] = false;
                }
                for (k = i + span - 1; k > i && offsets[i + span] - offsets[k] < size; --k) {
                    breakable[k] = false;
                }
            }
        }
        return breakable;
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean fillEnded;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        this.printCells.clear();
        boolean bl = fillEnded = !this.hasData || this.rowIndex >= this.rowHeadersData[0].length && this.columnIndex >= this.columnHeadersData[0].length;
        if (isOverflow && fillEnded && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return false;
            }
        }
        if (isOverflow && this.isPrintWhenDetailOverflows()) {
            this.setReprinted(true);
        }
        return this.fillVerticalCrosstab(availableStretchHeight, 0);
    }

    protected void fillNoDataCell() throws JRException {
        if (this.whenNoDataCell != null) {
            JRPrintFrame printCell = this.fillCellContents(this.whenNoDataCell, 0, 0);
            this.addPrintCell(printCell);
        }
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintRectangle printRectangle = null;
        printRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        printRectangle.setX(this.getX());
        printRectangle.setY(this.getRelativeY());
        printRectangle.setWidth(this.getWidth());
        printRectangle.setHeight(this.getStretchHeight());
        return printRectangle;
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        if (this.template == null) {
            JRDesignRectangle rectangle = new JRDesignRectangle();
            rectangle.setKey(this.getKey());
            rectangle.setPositionType(this.getPositionType());
            rectangle.setMode(this.getMode());
            rectangle.setX(this.getX());
            rectangle.setY(this.getY());
            rectangle.setWidth(this.getWidth());
            rectangle.setHeight(this.getHeight());
            rectangle.setRemoveLineWhenBlank(this.isRemoveLineWhenBlank());
            rectangle.setPrintInFirstWholeBand(this.isPrintInFirstWholeBand());
            rectangle.setPrintWhenDetailOverflows(this.isPrintWhenDetailOverflows());
            rectangle.setPrintWhenGroupChanges(this.getPrintWhenGroupChanges());
            rectangle.setForecolor(this.getForecolor());
            rectangle.setPen((byte)0);
            this.template = new JRTemplateRectangle(this.filler.getJasperPrint().getDefaultStyleProvider(), rectangle);
        }
        return (JRTemplateRectangle)this.template;
    }

    protected void rewind() throws JRException {
        this.initFill();
    }

    protected boolean fillVerticalCrosstab(int availableStretchHeight, int yOffset) throws JRException {
        boolean fillEnded;
        int rowHeadersXOffset;
        if (!this.hasData) {
            this.fillNoDataCell();
            return false;
        }
        boolean printRowHeaders = this.columnIndex == 0 || this.isRepeatRowHeaders();
        int n = rowHeadersXOffset = printRowHeaders ? this.rowHeadersXOffsets[this.rowGroups.length] : 0;
        if (this.columnIndex == this.lastColumnIndex) {
            int availableWidth = this.getWidth();
            this.fillColumnHeaders = JRFillCrosstab.getGroupHeaders(availableWidth - rowHeadersXOffset, this.columnXOffsets, this.columnBreakable, this.columnIndex, this.columnHeadersData, this.columnGroups);
            this.lastColumnIndex = this.columnIndex + this.fillColumnHeaders.size();
            if (this.columnIndex == this.lastColumnIndex) {
                throw new JRRuntimeException("Not enough space to render the crosstab.");
            }
        }
        boolean printColumnHeaders = this.rowIndex == 0 || this.isRepeatColumnHeaders();
        int columnHeadersYOffset = printColumnHeaders ? this.columnHeadersYOffsets[this.columnGroups.length] : 0;
        int availableHeight = this.getHeight() + availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY();
        List rowHeaders = JRFillCrosstab.getGroupHeaders(availableHeight - yOffset - columnHeadersYOffset, this.rowYOffsets, this.rowBreakable, this.rowIndex, this.rowHeadersData, this.rowGroups);
        int lastRowIndex = this.rowIndex + rowHeaders.size();
        if (lastRowIndex == this.rowIndex) {
            this.setStretchHeight(availableHeight);
            return true;
        }
        if (printColumnHeaders) {
            this.fillColumnHeaders(rowHeadersXOffset, yOffset);
        }
        if (printRowHeaders) {
            this.fillRowHeaders(rowHeaders, yOffset + columnHeadersYOffset);
        }
        this.fillDataCells(lastRowIndex, rowHeadersXOffset, yOffset + columnHeadersYOffset);
        int usedHeight = columnHeadersYOffset + this.rowYOffsets[lastRowIndex] - this.rowYOffsets[this.rowIndex];
        if (lastRowIndex >= this.rowHeadersData[0].length) {
            this.columnIndex = this.lastColumnIndex;
            if (this.columnIndex < this.columnHeadersData[0].length) {
                lastRowIndex = 0;
                this.rowIndex = 0;
                return this.fillVerticalCrosstab(availableStretchHeight, yOffset + usedHeight + this.getColumnBreakOffset());
            }
        }
        boolean bl = fillEnded = lastRowIndex >= this.rowHeadersData[0].length && this.lastColumnIndex >= this.columnHeadersData[0].length;
        if (fillEnded) {
            this.setStretchHeight(yOffset + usedHeight);
        } else {
            this.setStretchHeight(availableHeight);
        }
        this.rowIndex = lastRowIndex;
        return !fillEnded;
    }

    private static List getGroupHeaders(int available, int[] offsets, boolean[] breakable, int firstIndex, HeaderCell[][] headersData, JRFillCrosstabGroup[] groups) {
        int j;
        int lastIndex;
        ArrayList<HeaderCell[]> headers = new ArrayList<HeaderCell[]>();
        int maxOffset = available + offsets[firstIndex];
        for (lastIndex = firstIndex; lastIndex < headersData[0].length && offsets[lastIndex + 1] <= maxOffset; ++lastIndex) {
            HeaderCell[] groupHeaders = new HeaderCell[groups.length];
            for (j = 0; j < groups.length; ++j) {
                groupHeaders[j] = headersData[j][lastIndex];
            }
            headers.add(groupHeaders);
        }
        if (lastIndex < headersData[0].length) {
            while (lastIndex > firstIndex && !breakable[lastIndex]) {
                --lastIndex;
                headers.remove(headers.size() - 1);
            }
        }
        if (lastIndex > firstIndex) {
            if (firstIndex > 0) {
                HeaderCell[] firstHeaders = (HeaderCell[])headers.get(0);
                for (j = 0; j < groups.length; ++j) {
                    int spanIndex;
                    HeaderCell header = headersData[j][firstIndex];
                    if (header != null || (spanIndex = JRFillCrosstab.getSpanIndex(firstIndex, j, headersData)) < 0) continue;
                    HeaderCell spanCell = headersData[j][spanIndex];
                    firstHeaders[j] = HeaderCell.createLevelSpanCopy(spanCell, spanCell.getLevelSpan() - firstIndex + spanIndex);
                }
            }
            if (lastIndex < headersData[0].length) {
                for (int j2 = 0; j2 < groups.length; ++j2) {
                    int spanIndex;
                    HeaderCell header = headersData[j2][lastIndex];
                    if (header != null || (spanIndex = JRFillCrosstab.getSpanIndex(lastIndex, j2, headersData)) < firstIndex) continue;
                    HeaderCell spanCell = headersData[j2][spanIndex];
                    HeaderCell[] headerCells = (HeaderCell[])headers.get(spanIndex - firstIndex);
                    headerCells[j2] = HeaderCell.createLevelSpanCopy(spanCell, lastIndex - spanIndex);
                }
            }
        }
        return headers;
    }

    private static int getSpanIndex(int i, int j, HeaderCell[][] headersData) {
        HeaderCell spanCell;
        int span;
        int spanIndex;
        for (spanIndex = i - 1; spanIndex >= 0 && headersData[j][spanIndex] == null; --spanIndex) {
        }
        if (spanIndex >= 0 && (span = (spanCell = headersData[j][spanIndex]).getLevelSpan()) > i - spanIndex) {
            return spanIndex;
        }
        return -1;
    }

    protected void fillColumnHeaders(int xOffset, int yOffset) throws JRException {
        for (int i = 0; i < this.columnGroups.length; ++i) {
            JRFillCrosstabColumnGroup group = this.columnGroups[i];
            JRFillCellContents header = group.getFillHeader();
            JRFillCellContents totalHeader = group.getFillTotalHeader();
            byte position = group.getPosition();
            for (int j = this.columnIndex; j < this.lastColumnIndex; ++j) {
                HeaderCell[] headers = (HeaderCell[])this.fillColumnHeaders.get(j - this.columnIndex);
                HeaderCell cell = headers[i];
                if (cell == null) continue;
                JRFillCrosstab.setGroupVariables(this.columnGroups, cell.getBucketValues());
                JRFillCellContents contents = cell.isTotal() ? totalHeader : header;
                int width = this.columnXOffsets[j + cell.getLevelSpan()] - this.columnXOffsets[j];
                if (contents == null || width <= 0 || contents.getHeight() <= 0) continue;
                contents = JRFillCellContents.getTransformedContents(this.filler, this, contents, width, contents.getHeight(), position, (byte)1);
                if (j == this.columnIndex) {
                    contents = JRFillCellContents.getBoxContents(contents, true, false);
                }
                JRPrintFrame printCell = this.fillCellContents(contents, this.columnXOffsets[j] - this.columnXOffsets[this.columnIndex] + xOffset, this.columnHeadersYOffsets[i] + yOffset);
                this.addPrintCell(printCell);
            }
        }
        JRFillCrosstab.setGroupVariablesNull(this.columnGroups);
    }

    protected void addPrintCell(JRPrintFrame cell) {
        this.printCells.add(cell);
    }

    protected void fillRowHeaders(List rowHeaders, int yOffset) throws JRException {
        for (int i = 0; i < rowHeaders.size(); ++i) {
            HeaderCell[] headers = (HeaderCell[])rowHeaders.get(i);
            for (int j = 0; j < this.rowGroups.length; ++j) {
                JRFillCrosstabRowGroup group = this.rowGroups[j];
                HeaderCell cell = headers[j];
                if (cell == null) continue;
                JRFillCrosstab.setGroupVariables(this.rowGroups, cell.getBucketValues());
                JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
                int height = this.rowYOffsets[i + this.rowIndex + cell.getLevelSpan()] - this.rowYOffsets[i + this.rowIndex];
                if (contents == null || contents.getWidth() <= 0 || height <= 0) continue;
                contents = JRFillCellContents.getTransformedContents(this.filler, this, contents, contents.getWidth(), height, (byte)1, group.getPosition());
                if (i == 0) {
                    contents = JRFillCellContents.getBoxContents(contents, false, true);
                }
                JRPrintFrame printCell = this.fillCellContents(contents, this.rowHeadersXOffsets[j], this.rowYOffsets[i + this.rowIndex] - this.rowYOffsets[this.rowIndex] + yOffset);
                this.addPrintCell(printCell);
            }
        }
        JRFillCrosstab.setGroupVariablesNull(this.rowGroups);
    }

    private static void setGroupVariables(JRFillCrosstabGroup[] groups, BucketDefinition.Bucket[] bucketValues) {
        for (int i = 0; i < groups.length; ++i) {
            Object value = null;
            if (bucketValues[i] != null && !bucketValues[i].isTotal()) {
                value = bucketValues[i].getValue();
            }
            groups[i].getFillVariable().setValue(value);
        }
    }

    private static void setGroupVariablesNull(JRFillCrosstabGroup[] groups) {
        for (int i = 0; i < groups.length; ++i) {
            groups[i].getFillVariable().setValue(null);
        }
    }

    private void setMeasureVariables(MeasureDefinition.MeasureValue[] values) {
        for (int i = 0; i < this.measures.length; ++i) {
            Object value = this.measures[i].getPercentageOfType() == 1 ? (values[i].isInitialized() ? values[i].getValue() : this.measures[i].getPercentageCalculator().calculatePercentage(values[i], this.grandTotals[i])) : values[i].getValue();
            this.measures[i].getFillVariable().setValue(value);
        }
    }

    private void setMeasureVariablesNull() {
        for (int i = 0; i < this.measures.length; ++i) {
            this.measures[i].getFillVariable().setValue(null);
        }
    }

    private void fillDataCells(int lastRowIndex, int xOffset, int yOffset) throws JRException {
        boolean leftEmpty = this.columnIndex != 0 && !this.isRepeatRowHeaders();
        boolean topEmpty = this.rowIndex != 0 && !this.isRepeatColumnHeaders();
        for (int i = this.rowIndex; i < lastRowIndex; ++i) {
            for (int j = this.columnIndex; j < this.lastColumnIndex; ++j) {
                boolean top;
                JRFillCellContents contents;
                CrosstabCell data = this.cellData[i][j];
                JRFillCrosstabCell cell = this.crossCells[data.getRowTotalGroupIndex()][data.getColumnTotalGroupIndex()];
                JRFillCrosstab.setGroupVariables(this.rowGroups, data.getRowBucketValues());
                JRFillCrosstab.setGroupVariables(this.columnGroups, data.getColumnBucketValues());
                this.setMeasureVariables(data.getMesureValues());
                JRFillCellContents jRFillCellContents = contents = cell == null ? null : cell.getFillContents();
                if (contents == null || contents.getWidth() <= 0 || contents.getHeight() <= 0) continue;
                boolean left = leftEmpty && j == this.columnIndex;
                boolean bl = top = topEmpty && i == this.rowIndex;
                if (left || top) {
                    contents = JRFillCellContents.getBoxContents(contents, left, top);
                }
                JRPrintFrame printCell = this.fillCellContents(contents, this.columnXOffsets[j] - this.columnXOffsets[this.columnIndex] + xOffset, this.rowYOffsets[i] - this.rowYOffsets[this.rowIndex] + yOffset);
                this.addPrintCell(printCell);
            }
        }
        JRFillCrosstab.setGroupVariablesNull(this.rowGroups);
        JRFillCrosstab.setGroupVariablesNull(this.columnGroups);
        this.setMeasureVariablesNull();
    }

    private JRPrintFrame fillCellContents(JRFillCellContents contents, int x, int y) throws JRException {
        contents.evaluate((byte)3);
        return contents.fill(0, x, y);
    }

    protected List getPrintElements() {
        return this.printCells;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getCrosstab(this);
    }

    public void writeXml(JRXmlWriter writer) throws IOException {
        writer.writeCrosstab(this);
    }

    public String getName() {
        return this.parentCrosstab.getName();
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    public int getColumnBreakOffset() {
        return this.parentCrosstab.getColumnBreakOffset();
    }

    public boolean isRepeatColumnHeaders() {
        return this.parentCrosstab.isRepeatColumnHeaders();
    }

    public boolean isRepeatRowHeaders() {
        return this.parentCrosstab.isRepeatRowHeaders();
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public JRCrosstabParameter[] getParameters() {
        return this.parentCrosstab.getParameters();
    }

    public JRExpression getParametersMapExpression() {
        return this.parentCrosstab.getParametersMapExpression();
    }

    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    public class JRFillCrosstabDataset
    extends JRFillElementDataset
    implements JRCrosstabDataset {
        private Object[] bucketValues;
        private Object[] measureValues;

        public JRFillCrosstabDataset(JRCrosstabDataset dataset, JRFillObjectFactory factory) {
            super(dataset, factory);
            this.bucketValues = new Object[JRFillCrosstab.this.rowGroups.length + JRFillCrosstab.this.columnGroups.length];
            this.measureValues = new Object[JRFillCrosstab.this.measures.length];
        }

        protected void customInitialize() {
            JRFillCrosstab.this.initBucketingService();
        }

        protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
            int i;
            for (i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                this.bucketValues[i] = calculator.evaluate(JRFillCrosstab.this.rowGroups[i].getBucket().getExpression());
            }
            for (i = 0; i < JRFillCrosstab.this.columnGroups.length; ++i) {
                this.bucketValues[i + JRFillCrosstab.this.rowGroups.length] = calculator.evaluate(JRFillCrosstab.this.columnGroups[i].getBucket().getExpression());
            }
            for (i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                this.measureValues[i] = calculator.evaluate(JRFillCrosstab.this.measures[i].getValueExpression());
            }
        }

        protected void customIncrement() {
            try {
                JRFillCrosstab.this.bucketingService.addData(this.bucketValues, this.measureValues);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Error incrementing crosstab dataset", e);
            }
        }

        protected Dataset getCustomDataset() {
            return null;
        }

        public void collectExpressions(JRExpressionCollector collector) {
        }

        public boolean isDataPreSorted() {
            return ((JRCrosstabDataset)this.parent).isDataPreSorted();
        }
    }
}

