/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.chart.AvailableCharts;
import it.businesslogic.ireport.chart.DefaultChartFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ChartReportElement
extends ImageReportElement {
    private Properties props;

    public ChartReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setGraphicElementPen("Thin");
        this.setBgcolor(Color.WHITE);
        this.setFgcolor(Color.BLACK);
        this.setKey("chart");
        this.setImg(null);
        this.setIsUsingCache(false);
        this.setImageExpression("");
        this.setImageClass("java.awt.Image");
        this.setScaleImage("RetainShape");
        this.setGraphicElementPen("None");
        this.setHyperlinkType("None");
        this.setAnchorNameExpression("");
        this.setImg(AvailableCharts.getChartIcon("").getImage());
        this.props = new Properties();
        this.props.setProperty("width", "" + width);
        this.props.setProperty("height", "" + height);
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        if (this.getImg() == null) {
            this.updateChartImage();
        }
        super.drawObject(g, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void parseProperties(Vector reportProperties) {
        for (int i = 0; i < reportProperties.size(); ++i) {
            JRProperty property = (JRProperty)reportProperties.elementAt(i);
            if (!property.getName().startsWith("chart." + this.getName())) continue;
            this.props.setProperty(property.getName().substring(("chart." + this.getName() + ".").length()), property.getValue());
        }
    }

    public void updateChartImage() {
        try {
            String[] params_strings = null;
            params_strings = new String[this.getProps().size()];
            Enumeration<Object> enum_keys = this.getProps().keys();
            int i = 0;
            while (enum_keys.hasMoreElements()) {
                String key = (String)enum_keys.nextElement();
                String val = "" + this.getProps().get(key);
                if (key.startsWith("serie")) {
                    val = "";
                }
                params_strings[i] = key + "=" + val;
                ++i;
            }
            Image imgx = DefaultChartFactory.drawChart(params_strings, null);
            this.setImg(imgx);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateBounds() {
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
    }

    public Point trasform(Point delta, int type) {
        Point p = super.trasform(delta, type);
        this.getProps().setProperty("width", "" + this.width);
        this.getProps().setProperty("height", "" + this.height);
        this.updateChartImage();
        return p;
    }
}

