/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    private char groupingSeparator = (char)44;
    private char decimalSeparator = (char)46;

    public NumberDocument() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.groupingSeparator = dfs.getGroupingSeparator();
        this.decimalSeparator = dfs.getDecimalSeparator();
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        proposedResult = proposedResult.replaceAll("\\" + this.groupingSeparator + "", "");
        proposedResult = proposedResult.replace(this.decimalSeparator, '.');
        try {
            Double.parseDouble(proposedResult);
            super.insertString(offs, str, a);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs, currentText.length());
        String proposedResult = beforeOffset + afterOffset;
        proposedResult = proposedResult.replaceAll("\\" + this.groupingSeparator + "", "");
        proposedResult = proposedResult.replace(this.decimalSeparator, '.');
        try {
            if (proposedResult.length() != 0) {
                Double.parseDouble(proposedResult);
            }
            super.remove(offs, len);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }
}

