/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.logpane;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.gui.ElementPropertiesDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.logpane.LogPane;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LogTextArea
extends JPanel {
    private StringBuffer outputBuffer;
    private String title = null;
    private LogPane logPane = null;
    private boolean removable = false;
    private JEditorPane jEditorPaneOutput;
    private JMenuItem jMenuItemClearLog;
    private JMenuItem jMenuItemCloseLog;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemSelectAll;
    private JPopupMenu jPopupMenuLog;
    private JScrollPane jScrollPaneOutput;
    private JSeparator jSeparator1;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public LogTextArea(String title) {
        this.initComponents();
        this.outputBuffer = new StringBuffer();
        this.setTitle(title);
        this.jEditorPaneOutput.setContentType("text/html");
        this.jEditorPaneOutput.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !LogTextArea.this.parseError(e.getURL())) {
                    JOptionPane.showMessageDialog(MainFrame.getMainInstance(), " HyperlinkEvent " + e.getURL());
                }
            }
        });
        this.clearConsole();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseError(URL url) {
        if (url == null) {
            return false;
        }
        JInternalFrame[] frames = MainFrame.getMainInstance().getJMDIDesktopPane().getAllFrames();
        JReportFrame jrf = null;
        for (int k = 0; k < frames.length; ++k) {
            if (!(frames[k] instanceof JReportFrame) || ((JReportFrame)frames[k]).getWindowID() != url.getPort()) continue;
            jrf = (JReportFrame)frames[k];
            if (frames[k].isSelected()) continue;
            try {
                frames[k].setSelected(true);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (jrf == null) {
            return false;
        }
        try {
            if (url.getHost().equalsIgnoreCase("error")) {
                String expression = url.getFile();
                if (expression == null || expression.length() <= 0) return false;
                if (expression.startsWith("/textField_")) {
                    int index = 0;
                    int number = Integer.parseInt(expression.substring("/textField_".length()).trim());
                    Enumeration e = jrf.getReport().getElements().elements();
                    while (e.hasMoreElements()) {
                        ReportElement re = (ReportElement)e.nextElement();
                        if (!(re instanceof TextFieldReportElement) || ++index != number) continue;
                        jrf.setSelectedElement(re);
                        MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
                        ElementPropertiesDialog elementPropertiesDialog = MainFrame.getMainInstance().getElementPropertiesDialog();
                        MainFrame.getMainInstance().getElementPropertiesDialog();
                        elementPropertiesDialog.gotoTab(7);
                        return true;
                    }
                    return false;
                } else {
                    if (!expression.startsWith("/parameterDefaultValue_")) return false;
                    boolean index = false;
                    String name = expression.substring("/parameterDefaultValue_".length()).trim();
                    Enumeration e = jrf.getReport().getParameters().elements();
                    while (e.hasMoreElements()) {
                        JRParameter param = (JRParameter)e.nextElement();
                        if (!param.getName().equals(name)) continue;
                        MainFrame.getMainInstance().getValuesDialog().setVisible(true);
                        MainFrame.getMainInstance().getValuesDialog().modifyErrorParameter(param);
                        return true;
                    }
                }
                return false;
            }
            if (!url.getHost().equals("warning")) return false;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    private void initComponents() {
        this.jPopupMenuLog = new JPopupMenu();
        this.jMenuItemClearLog = new JMenuItem();
        this.jMenuItemCloseLog = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemSelectAll = new JMenuItem();
        this.jScrollPaneOutput = new JScrollPane();
        this.jEditorPaneOutput = new JEditorPane();
        this.jMenuItemClearLog.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemClearLog.setText("Clear log");
        this.jMenuItemClearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemClearLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemClearLog);
        this.jMenuItemCloseLog.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemCloseLog.setText("Close log");
        this.jMenuItemCloseLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemCloseLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCloseLog);
        this.jPopupMenuLog.add(this.jSeparator1);
        this.jMenuItemCopy.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemCopy.setText("Copy");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCopy);
        this.jMenuItemSelectAll.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemSelectAll.setText("Select all");
        this.jMenuItemSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemSelectAllActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemSelectAll);
        this.setLayout(new BorderLayout());
        this.jScrollPaneOutput.setHorizontalScrollBarPolicy(32);
        this.jScrollPaneOutput.setVerticalScrollBarPolicy(22);
        this.jScrollPaneOutput.setMinimumSize(new Dimension(22, 75));
        this.jScrollPaneOutput.setPreferredSize(new Dimension(3, 100));
        this.jEditorPaneOutput.setBackground(new Color(204, 204, 204));
        this.jEditorPaneOutput.setEditable(false);
        this.jEditorPaneOutput.setFont(new Font("Courier New", 0, 12));
        this.jEditorPaneOutput.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogTextArea.this.jEditorPaneOutputMouseClicked(evt);
            }
        });
        this.jScrollPaneOutput.setViewportView(this.jEditorPaneOutput);
        this.add((Component)this.jScrollPaneOutput, "Center");
    }

    private void jMenuItemSelectAllActionPerformed(ActionEvent evt) {
        this.jEditorPaneOutput.selectAll();
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        this.jEditorPaneOutput.copy();
    }

    private void jMenuItemCloseLogActionPerformed(ActionEvent evt) {
        this.getLogPane().removeLog(this);
    }

    private void jMenuItemClearLogActionPerformed(ActionEvent evt) {
        this.clearConsole();
    }

    private void jEditorPaneOutputMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenuLog.show(this, evt.getPoint().x, evt.getPoint().y);
        }
    }

    public void logOnConsole(String noHTML) {
        this.logOnConsole(noHTML, false);
    }

    public void logOnConsole(String s, boolean isHTML) {
        try {
            if (this.jEditorPaneOutput == null) {
                this.outputBuffer.append(s);
            } else {
                this.jEditorPaneOutput.setContentType("text/html");
                if (!isHTML) {
                    s = Misc.string_replace("&gt;", ">", s);
                    s = Misc.string_replace("&lt;", "<", s);
                    s = Misc.string_replace("&nbsp;", " ", s);
                    s = Misc.string_replace("&nbsp;&nbsp;&nbsp;&nbsp;", "\t", s);
                }
                HTMLDocument doc = (HTMLDocument)this.jEditorPaneOutput.getDocument();
                HTMLEditorKit editorKit = (HTMLEditorKit)this.jEditorPaneOutput.getEditorKit();
                if (!s.startsWith("<font") && !s.startsWith("<hr>")) {
                    s = "<font face=\"Courier New\" size=\"3\" >" + s + "</font>";
                }
                editorKit.insertHTML(doc, doc.getLength(), s, 0, 0, null);
                this.logPane.setActiveLog(this);
            }
        }
        catch (Exception exsx) {
            JOptionPane.showMessageDialog(this, "" + exsx.getMessage());
        }
    }

    public void clearConsole() {
        this.jEditorPaneOutput.setContentType("text/html");
        this.outputBuffer.setLength(0);
        this.jEditorPaneOutput.setText("");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, title));
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = LogTextArea.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = LogTextArea.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? LogTextArea.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public LogPane getLogPane() {
        return this.logPane;
    }

    public void setLogPane(LogPane logPane) {
        this.logPane = logPane;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

