/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.undo.PositionedElement;
import java.util.Enumeration;
import java.util.Vector;

public class ChangeEmentsOrderOperation
implements UndoOperation {
    private Vector elements = new Vector();
    private JReportFrame jrf = null;

    public ChangeEmentsOrderOperation(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getElements().elements();
        while (e.hasMoreElements()) {
            PositionedElement pe = (PositionedElement)e.nextElement();
            ReportElement element = pe.getElement();
            this.jrf.getReport().getElements().remove(pe.getOldPosition());
            this.jrf.getReport().getElements().insertElementAt(element, pe.getNewPosition());
            this.jrf.addSelectedElement(element, false);
        }
        this.jrf.fireSelectionChangedEvent();
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.setSelectedElement(null);
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            PositionedElement pe = (PositionedElement)this.getElements().get(i);
            ReportElement element = pe.getElement();
            this.jrf.getReport().getElements().remove(pe.getNewPosition());
            this.jrf.getReport().getElements().insertElementAt(element, pe.getOldPosition());
            this.jrf.addSelectedElement(element, false);
        }
        this.jrf.fireSelectionChangedEvent();
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "change element(s) order";
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void addElement(ReportElement element, int oldPosition, int newPostion) {
        PositionedElement pe = new PositionedElement(element, oldPosition, newPostion);
        this.getElements().add(pe);
    }
}

