/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class Initializer
extends FieldDeclaration {
    public Block block;
    public int lastVisibleFieldID;
    public int bodyStart;
    public int bodyEnd;
    public boolean errorInSignature = false;

    public Initializer(Block block, int modifiers) {
        this.block = block;
        this.modifiers = modifiers;
        this.declarationSourceStart = this.sourceStart = block.sourceStart;
    }

    public FlowInfo analyseCode(MethodScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.block.analyseCode(currentScope, flowContext, flowInfo);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.block.generateCode(currentScope, codeStream);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isField() {
        return false;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(Parser parser, TypeDeclaration typeDeclaration, CompilationUnitDeclaration unit) {
        parser.parse(this, typeDeclaration, unit);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        if (this.modifiers != 0) {
            ASTNode.printIndent(indent, output);
            ASTNode.printModifiers(this.modifiers, output).append("{\n");
            this.block.printBody(indent, output);
            ASTNode.printIndent(indent, output).append('}');
            return output;
        }
        return this.block.printStatement(indent, output);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope scope) {
        FieldBinding previousField = scope.initializedField;
        int previousFieldID = scope.lastVisibleFieldID;
        try {
            SourceTypeBinding declaringType;
            scope.initializedField = null;
            scope.lastVisibleFieldID = this.lastVisibleFieldID;
            if (this.isStatic() && (declaringType = scope.enclosingSourceType()).isNestedType() && !declaringType.isStatic()) {
                scope.problemReporter().innerTypesCannotDeclareStaticInitializers(declaringType, this);
            }
            this.block.resolve(scope);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            scope.initializedField = previousField;
            scope.lastVisibleFieldID = previousFieldID;
            throw throwable;
        }
        {
            Object var5_7 = null;
            scope.initializedField = previousField;
            scope.lastVisibleFieldID = previousFieldID;
            return;
        }
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.block.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

