/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;

public class MenuItemIconFactory
implements Serializable {
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static final Dimension menuCheckIconSize;

    static {
        menuCheckIconSize = new Dimension(10, 10);
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem item = (JMenuItem)c;
            ButtonModel model = item.getModel();
            boolean isSelected = model.isSelected();
            if (!isSelected) {
                return;
            }
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(Theme.menuIconRolloverColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.menuIconColor[Theme.style].getColor());
                }
            } else {
                g.setColor(Theme.menuIconDisabledColor[Theme.style].getColor());
            }
            g.drawLine(2, 4, 2, 6);
            g.drawLine(3, 5, 3, 7);
            g.drawLine(4, 6, 4, 8);
            g.drawLine(5, 5, 5, 7);
            g.drawLine(6, 4, 6, 6);
            g.drawLine(7, 3, 7, 5);
            g.drawLine(8, 2, 8, 4);
            if (!isEnabled) {
                g.setColor(Theme.menuIconShadowColor[Theme.style].getColor());
                g.drawLine(9, 3, 9, 5);
                g.drawLine(8, 5, 8, 6);
                g.drawLine(7, 6, 7, 7);
                g.drawLine(6, 7, 6, 8);
                g.drawLine(5, 8, 5, 9);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    g.setColor(Theme.menuIconRolloverColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.menuIconColor[Theme.style].getColor());
                }
            } else {
                g.setColor(Theme.menuIconDisabledColor[Theme.style].getColor());
            }
            g.drawLine(3, 0, 6, 0);
            g.drawLine(9, 3, 9, 6);
            g.drawLine(3, 9, 6, 9);
            g.drawLine(0, 3, 0, 6);
            g.drawLine(1, 1, 2, 1);
            g.drawLine(7, 1, 8, 1);
            g.drawLine(1, 8, 2, 8);
            g.drawLine(7, 8, 8, 8);
            g.drawLine(1, 2, 1, 2);
            g.drawLine(8, 2, 8, 2);
            g.drawLine(1, 7, 1, 7);
            g.drawLine(8, 7, 8, 7);
            if (isSelected) {
                g.drawLine(4, 3, 5, 3);
                g.drawLine(3, 4, 6, 4);
                g.drawLine(3, 5, 6, 5);
                g.drawLine(4, 6, 5, 6);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }
}

