/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import org.codehaus.groovy.ast.Type;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.objectweb.asm.Label;

public class Variable {
    private int index;
    private Type type;
    private String name;
    private boolean holder;
    private boolean property;
    private Label startLabel = null;
    private Label endLabel = null;

    public Variable(int index, Type type, String name) {
        this.index = index;
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isHolder() {
        return this.holder;
    }

    public void setHolder(boolean holder) {
        this.holder = holder;
    }

    public boolean isProperty() {
        return this.property;
    }

    public void setProperty(boolean property) {
        this.property = property;
    }

    public Label getStartLabel() {
        return this.startLabel;
    }

    public void setStartLabel(Label startLabel) {
        this.startLabel = startLabel;
    }

    public Label getEndLabel() {
        return this.endLabel;
    }

    public void setEndLabel(Label endLabel) {
        this.endLabel = endLabel;
    }

    public String toString() {
        return super.toString() + "[" + this.type + " " + this.name + " (" + this.index + ")";
    }

    public Variable deriveBoxedVersion() {
        if (BytecodeHelper.isPrimitiveType(this.getTypeName())) {
            Type t = new Type(BytecodeHelper.getObjectTypeForPrimitive(this.getTypeName()));
            return new Variable(this.index, t, this.name);
        }
        return this;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setDynamic(boolean b) {
        this.type.setDynamic(b);
    }
}

