/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.plaf.metal.MetalCheckBoxIcon;

public class TinyCheckBoxIcon
extends MetalCheckBoxIcon {
    protected int getControlSize() {
        return this.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        Color col = null;
        col = !button.isEnabled() ? Theme.buttonDisabledColor[Theme.style].getColor() : (button.getModel().isPressed() ? (button.getModel().isRollover() ? Theme.buttonPressedColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()) : (button.getModel().isRollover() && Theme.buttonRollover[Theme.style] ? Theme.buttonRolloverBgColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()));
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCheck(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                break;
            }
            case 1: {
                this.drawWinCheck(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                break;
            }
            case 2: {
                this.drawXpCheck(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
            }
        }
        if (!button.isSelected()) {
            return;
        }
        if (!button.isEnabled()) {
            g.setColor(Theme.buttonCheckDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonCheckColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCheckMark(g, button, col, x, y);
                break;
            }
            case 1: {
                this.drawWinCheckMark(g, x, y);
                break;
            }
            case 2: {
                this.drawXpCheckMark(g, x, y);
            }
        }
    }

    private void drawTinyCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
    }

    private void drawWinCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        if (b.getModel().isPressed() && b.getModel().isRollover()) {
            g.drawLine(x + 0, y + 12, x + 12, y + 12);
            g.drawLine(x + 12, y + 0, x + 12, y + 11);
        } else {
            g.fillRect(x, y, w, h);
        }
        if (!b.isEnabled()) {
            g.setColor(ColorRoutines.getAverage(c, Theme.buttonDarkDisabledColor[Theme.style].getColor()));
        } else {
            g.setColor(ColorRoutines.getAverage(c, Theme.buttonDarkColor[Theme.style].getColor()));
        }
        g.drawLine(x + 0, y + 0, x + 11, y + 0);
        g.drawLine(x + 0, y + 1, x + 0, y + 11);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y + 1, x + 10, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 10);
        g.setColor(Theme.backColor[Theme.style].getColor());
        g.drawLine(x + 1, y + 11, x + 11, y + 11);
        g.drawLine(x + 11, y + 1, x + 11, y + 10);
    }

    private void drawXpCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        if (b.getModel().isPressed() && b.getModel().isRollover()) {
            c = Theme.backColor[Theme.style].getColor();
            g.setColor(c);
        } else {
            g.setColor(Color.WHITE);
        }
        g.fillRect(x + 1, y + 1, w - 2, h - 2);
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        if (!b.isEnabled()) {
            spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
            spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        }
        float spreadStep1 = 10.0f * (float)spread1 / 20.0f;
        float spreadStep2 = 10.0f * (float)spread2 / 20.0f;
        if (b.getModel().isPressed() && b.getModel().isRollover()) {
            spreadStep2 *= 3.0f;
            spreadStep1 *= 0.5f;
        }
        int y1 = y + 1;
        Color c1 = null;
        c1 = ColorRoutines.darken(c, (int)(6.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, y1, x + w - 2, y1);
        c1 = ColorRoutines.darken(c, (int)(7.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.darken(c, (int)(4.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.darken(c, (int)(3.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.darken(c, (int)(2.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.darken(c, (int)(1.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        g.setColor(ColorRoutines.getAlphaColor(c, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.lighten(c, (int)(2.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.lighten(c, (int)(4.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.lighten(c, (int)(7.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        c1 = ColorRoutines.lighten(c, (int)(10.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(x + 1, ++y1, x + w - 2, y1);
        y1 = x + 1;
        c1 = ColorRoutines.darken(c, (int)(6.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.darken(c, (int)(5.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.darken(c, (int)(4.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.darken(c, (int)(3.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.darken(c, (int)(2.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.darken(c, (int)(1.0f * spreadStep2));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        g.setColor(ColorRoutines.getAlphaColor(c, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.lighten(c, (int)(2.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.lighten(c, (int)(4.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.lighten(c, (int)(7.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        c1 = ColorRoutines.lighten(c, (int)(10.0f * spreadStep1));
        g.setColor(ColorRoutines.getAlphaColor(c1, 128));
        g.drawLine(++y1, y + 1, y1, y + h - 2);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
            g.drawRect(x, y, w - 1, h - 1);
        } else {
            g.setColor(Theme.buttonBorderColor[Theme.style].getColor());
            g.drawRect(x, y, w - 1, h - 1);
            if (b.getModel().isRollover() && Theme.buttonRollover[Theme.style] && !b.getModel().isPressed()) {
                DrawRoutines.drawRolloverCheckBorder(g, Theme.disColor[Theme.style].getColor(), x, y, w, h);
            }
        }
    }

    private void drawTinyCheckMark(Graphics g, AbstractButton b, Color c, int x, int y) {
        g.drawLine(x + 2, y + 5, x + 3, y + 5);
        g.drawLine(x + 3, y + 6, x + 4, y + 6);
        g.drawLine(x + 4, y + 7, x + 6, y + 7);
        g.drawLine(x + 5, y + 8, x + 5, y + 8);
        g.drawLine(x + 6, y + 6, x + 7, y + 6);
        g.drawLine(x + 7, y + 5, x + 8, y + 5);
        g.drawLine(x + 8, y + 4, x + 9, y + 4);
        g.drawLine(x + 9, y + 3, x + 10, y + 3);
        g.drawLine(x + 10, y + 2, x + 10, y + 2);
        g.drawLine(x + 12, y + 1, x + 12, y + 1);
        if (!b.isEnabled()) {
            g.setColor(ColorRoutines.darken(c, 10));
        } else {
            g.setColor(ColorRoutines.darken(c, 20));
        }
        g.drawLine(x + 3, y + 7, x + 3, y + 7);
        g.drawLine(x + 4, y + 8, x + 4, y + 8);
        g.drawLine(x + 6, y + 9, x + 6, y + 9);
        g.drawLine(x + 7, y + 8, x + 7, y + 8);
        g.drawLine(x + 8, y + 7, x + 8, y + 7);
        g.drawLine(x + 9, y + 6, x + 9, y + 6);
        g.drawLine(x + 12, y + 3, x + 12, y + 3);
        g.drawLine(x + 13, y + 2, x + 13, y + 2);
        if (!b.isEnabled()) {
            g.setColor(ColorRoutines.darken(c, 20));
        } else {
            g.setColor(ColorRoutines.darken(c, 40));
        }
        g.drawLine(x + 5, y + 9, x + 5, y + 9);
        g.drawLine(x + 6, y + 8, x + 6, y + 8);
        g.drawLine(x + 7, y + 7, x + 7, y + 7);
        g.drawLine(x + 8, y + 6, x + 8, y + 6);
        g.drawLine(x + 9, y + 5, x + 9, y + 5);
        g.drawLine(x + 12, y + 2, x + 12, y + 2);
    }

    private void drawWinCheckMark(Graphics g, int x, int y) {
        g.drawLine(x + 3, y + 5, x + 3, y + 7);
        g.drawLine(x + 4, y + 6, x + 4, y + 8);
        g.drawLine(x + 5, y + 7, x + 5, y + 9);
        g.drawLine(x + 6, y + 6, x + 6, y + 8);
        g.drawLine(x + 7, y + 5, x + 7, y + 7);
        g.drawLine(x + 8, y + 4, x + 8, y + 6);
        g.drawLine(x + 9, y + 3, x + 9, y + 5);
    }

    private void drawXpCheckMark(Graphics g, int x, int y) {
        g.drawLine(x + 3, y + 5, x + 3, y + 7);
        g.drawLine(x + 4, y + 6, x + 4, y + 8);
        g.drawLine(x + 5, y + 7, x + 5, y + 9);
        g.drawLine(x + 6, y + 6, x + 6, y + 8);
        g.drawLine(x + 7, y + 5, x + 7, y + 7);
        g.drawLine(x + 8, y + 4, x + 8, y + 6);
        g.drawLine(x + 9, y + 3, x + 9, y + 5);
    }

    public int getIconWidth() {
        return Theme.checkSize[Theme.derivedStyle[Theme.style]].width;
    }

    public int getIconHeight() {
        return Theme.checkSize[Theme.derivedStyle[Theme.style]].height;
    }
}

