/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class DrawRoutines {
    static GraphicsConfiguration conf;
    public static Color lightenColor0;
    public static Color lightenColor1;
    public static Color lightenColor2;
    public static Color lightenColor3;
    protected static Color rolloverColor1;
    protected static Color rolloverColor2;

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        conf = ge.getDefaultScreenDevice().getDefaultConfiguration();
        lightenColor0 = new Color(255, 255, 255, 219);
        lightenColor1 = new Color(255, 255, 255, 168);
        lightenColor2 = new Color(255, 255, 255, 132);
        lightenColor3 = new Color(255, 255, 255, 61);
        rolloverColor1 = new Color(229, 151, 0);
        rolloverColor2 = new Color(248, 179, 48);
    }

    public static void drawBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawRect(x, y, w - 1, h - 1);
    }

    public static void drawEditableComboBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawLine(x, y, x, h - 1);
        g.drawLine(x, y, w - 1, y);
        g.drawLine(x, h - 1, w - 1, h - 1);
    }

    public static void drawRoundedBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawLine(x + 2, y, x + w - 3, y);
        g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
        g.drawLine(x, y + 2, x, y + h - 3);
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
        Color ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 56);
        g.setColor(ecken);
        g.drawLine(x, y, x, y);
        g.drawLine(x + w - 1, y, x + w - 1, y);
        g.drawLine(x, y + h - 1, x, y + h - 1);
        g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + h - 1);
        ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 183);
        g.setColor(ecken);
        g.drawLine(x + 1, y, x + 1, y);
        g.drawLine(x + w - 2, y, x + w - 2, y);
        g.drawLine(x, y + 1, x, y + 1);
        g.drawLine(x, y + h - 2, x, y + h - 2);
        g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
        g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
        g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
        g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
        ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 76);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
        g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
        g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
    }

    public static void drawRolloverBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
        g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
        g.setColor(ColorRoutines.lighten(c, 30));
        g.drawRect(x + 2, y + 2, w - 5, h - 5);
        g.setColor(Theme.backColor[Theme.style].getColor());
        g.drawLine(x + 2, y + 1, x + w - 3, y + 1);
        g.setColor(ColorRoutines.lighten(c, 60));
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
    }

    public static void drawDefaultBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
        g.drawRect(x + 2, y + 2, w - 5, h - 5);
        g.setColor(ColorRoutines.lighten(c, 30));
        g.drawLine(x + 2, y + 1, x + w - 3, y + 1);
        g.setColor(ColorRoutines.darken(c, 30));
        g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
    }

    public static void drawRolloverCheckBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(Theme.buttonRolloverColor[Theme.style].getColor());
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 3, y + h - 2);
        g.setColor(ColorRoutines.lighten(Theme.buttonRolloverColor[Theme.style].getColor(), 30));
        g.drawRect(x + 2, y + 2, w - 5, h - 5);
        g.setColor(ColorRoutines.lighten(Theme.buttonRolloverColor[Theme.style].getColor(), 60));
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
        g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
    }

    public static void drawSelectedXpTabBorder(Graphics g, Color c, int x, int y, int w, int h, int tabPlacement) {
        Color c2 = SBChooser.getAdjustedColor(Theme.tabRolloverColor[Theme.style].getColor(), 20, -30);
        g.setColor(c2);
        Color ecken = ColorRoutines.getAverage(Theme.backColor[Theme.style].getColor(), c2);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x, y + 2, x, y + --h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x + 2, y, x + 2, y);
                g.drawLine(x + 2, y + h - 1, x + 2, y + h - 1);
                g.setColor(Theme.tabRolloverColor[Theme.style].getColor());
                g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
                g.drawLine(x + 2, y + 1, x + 2, y + h - 2);
                g.setColor(ecken);
                g.drawLine(x, y + 1, x, y + 1);
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x, y + h - 2, x, y + h - 2);
                g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                g.setColor(c);
                g.drawLine(x + 3, y, x + w - 2, y);
                g.drawLine(x + 3, y + h - 1, x + w - 2, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + --h - 3);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 3, y, x + w - 3, y);
                g.drawLine(x + w - 3, y + h - 1, x + w - 3, y + h - 1);
                g.setColor(Theme.tabRolloverColor[Theme.style].getColor());
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.drawLine(x + w - 3, y + 1, x + w - 3, y + h - 2);
                g.setColor(ecken);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                g.drawLine(x + w - 2, y, x + w - 2, y);
                g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                g.setColor(c);
                g.drawLine(x, y, x + w - 4, y);
                g.drawLine(x, y + h - 1, x + w - 4, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x + 2, y + h - 1, x + --w - 3, y + h - 1);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x, y + h - 3, x, y + h - 3);
                g.drawLine(x + w - 1, y + h - 3, x + w - 1, y + h - 3);
                g.setColor(Theme.tabRolloverColor[Theme.style].getColor());
                g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + 1, y + h - 3, x + w - 2, y + h - 3);
                g.setColor(c);
                g.drawLine(x, y, x, y + h - 4);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 4);
                g.setColor(ecken);
                g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                g.drawLine(x, y + h - 2, x, y + h - 2);
                g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                break;
            }
            default: {
                g.drawLine(x + 2, y, x + --w - 3, y);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x, y + 2, x, y + 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + 2);
                g.setColor(Theme.tabRolloverColor[Theme.style].getColor());
                g.drawLine(x + 2, y + 1, x + w - 3, y + 1);
                g.drawLine(x + 1, y + 2, x + w - 2, y + 2);
                g.setColor(ecken);
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x, y + 1, x, y + 1);
                g.drawLine(x + w - 2, y, x + w - 2, y);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                g.setColor(c);
                g.drawLine(x, y + 3, x, y + h - 1);
                g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 1);
            }
        }
    }

    public static void drawXpTabBorder(Graphics g, Color c, int x, int y, int w, int h, int tabPlacement) {
        Color ecken = null;
        g.setColor(c);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 2, y, x + w - 1, y);
                g.drawLine(x + 2, y + --h - 1, x + w - 1, y + h - 1);
                g.drawLine(x, y + 2, x, y + h - 3);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 56);
                g.setColor(ecken);
                g.drawLine(x, y, x, y);
                g.drawLine(x, y + h - 1, x, y + h - 1);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 183);
                g.setColor(ecken);
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x, y + 1, x, y + 1);
                g.drawLine(x, y + h - 2, x, y + h - 2);
                g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 76);
                g.setColor(ecken);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.drawLine(x, y + --h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 56);
                g.setColor(ecken);
                g.drawLine(x + w - 1, y, x + w - 1, y);
                g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + h - 1);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 183);
                g.setColor(ecken);
                g.drawLine(x + w - 2, y, x + w - 2, y);
                g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 76);
                g.setColor(ecken);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                break;
            }
            case 3: {
                g.drawLine(x + 2, y + h - 1, x + --w - 3, y + h - 1);
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 56);
                g.setColor(ecken);
                g.drawLine(x, y + h - 1, x, y + h - 1);
                g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + h - 1);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 183);
                g.setColor(ecken);
                g.drawLine(x, y + h - 2, x, y + h - 2);
                g.drawLine(x + 1, y + h - 1, x + 1, y + h - 1);
                g.drawLine(x + w - 2, y + h - 1, x + w - 2, y + h - 1);
                g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + h - 2);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 76);
                g.setColor(ecken);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                break;
            }
            default: {
                g.drawLine(x + 2, y, x + --w - 3, y);
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 56);
                g.setColor(ecken);
                g.drawLine(x, y, x, y);
                g.drawLine(x + w - 1, y, x + w - 1, y);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 183);
                g.setColor(ecken);
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x + w - 2, y, x + w - 2, y);
                g.drawLine(x, y + 1, x, y + 1);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                ecken = new Color(c.getRed(), c.getGreen(), c.getBlue(), 76);
                g.setColor(ecken);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    public static void drawWinTabBorder(Graphics g, Color c, int x, int y, int w, int h, int tabPlacement) {
        Object ecken = null;
        g.setColor(Color.WHITE);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 2, y, x + w - 1, y);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.setColor(c);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(ColorRoutines.darken(c, 50));
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                break;
            }
            case 4: {
                g.drawLine(x + w - 3, y, x, y);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.setColor(c);
                g.drawLine(x + w - 3, y + h - 2, x, y + h - 2);
                g.setColor(ColorRoutines.darken(c, 50));
                g.drawLine(x + w - 3, y + h - 1, x, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                break;
            }
            case 3: {
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x, y + h - 3, x, y);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(c);
                g.drawLine(x + w - 2, y + h - 3, x + w - 2, y);
                g.setColor(ColorRoutines.darken(c, 50));
                g.drawLine(x + w - 1, y + h - 3, x + w - 1, y);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                break;
            }
            default: {
                g.drawLine(x + 2, y, x + w - 3, y);
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.setColor(c);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                g.setColor(ColorRoutines.darken(c, 50));
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    public static void drawXpRadioRolloverBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawLine(x + 6, y, x + 6, y);
        g.drawLine(x + 6, y + h - 1, x + 6, y + h - 1);
        g.drawLine(x, y + 6, x, y + 6);
        g.drawLine(x + w - 1, y + 6, x + w - 1, y + 6);
        g.setColor(ColorRoutines.lighten(c, 4));
        g.drawLine(x + 5, y, x + 5, y);
        g.drawLine(x + 7, y, x + 7, y);
        g.drawLine(x, y + 5, x, y + 5);
        g.drawLine(x, y + 7, x, y + 7);
        g.drawLine(x + 5, y + h - 1, x + 5, y + h - 1);
        g.drawLine(x + 7, y + h - 1, x + 7, y + h - 1);
        g.drawLine(x + w - 1, y + 5, x + w - 1, y + 5);
        g.drawLine(x + w - 1, y + 7, x + w - 1, y + 7);
        g.drawLine(x + 3, y + 1, x + 3, y + 1);
        g.drawLine(x + 2, y + 2, x + 2, y + 2);
        g.drawLine(x + 1, y + 3, x + 1, y + 3);
        g.drawLine(x + 1, y + 9, x + 1, y + 9);
        g.drawLine(x + 2, y + 10, x + 2, y + 10);
        g.drawLine(x + 3, y + 11, x + 3, y + 11);
        g.drawLine(x + 11, y + 9, x + 11, y + 9);
        g.drawLine(x + 10, y + 10, x + 10, y + 10);
        g.drawLine(x + 9, y + 11, x + 9, y + 11);
        g.drawLine(x + 9, y + 1, x + 9, y + 1);
        g.drawLine(x + 10, y + 2, x + 10, y + 2);
        g.drawLine(x + 11, y + 3, x + 11, y + 3);
        g.setColor(ColorRoutines.getAlphaColor(c, 122));
        g.drawLine(x + 3, y, x + 3, y);
        g.drawLine(x + 9, y, x + 9, y);
        g.drawLine(x, y + 3, x, y + 3);
        g.drawLine(x, y + 9, x, y + 9);
        g.drawLine(x + 3, y + h - 1, x + 3, y + h - 1);
        g.drawLine(x + 9, y + h - 1, x + 9, y + h - 1);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
        g.drawLine(x + w - 1, y + 9, x + w - 1, y + 9);
        g.setColor(ColorRoutines.getAlphaColor(c, 194));
        g.drawLine(x + 4, y, x + 4, y);
        g.drawLine(x + 8, y, x + 8, y);
        g.drawLine(x, y + 4, x, y + 4);
        g.drawLine(x, y + 8, x, y + 8);
        g.drawLine(x + 4, y + h - 1, x + 4, y + h - 1);
        g.drawLine(x + 8, y + h - 1, x + 8, y + h - 1);
        g.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
        g.drawLine(x + w - 1, y + 8, x + w - 1, y + 8);
        g.drawLine(x + 2, y + 1, x + 2, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 2);
        g.drawLine(x + 1, y + 10, x + 1, y + 10);
        g.drawLine(x + 2, y + 11, x + 2, y + 11);
        g.drawLine(x + 10, y + 1, x + 10, y + 1);
        g.drawLine(x + 11, y + 2, x + 11, y + 2);
        g.drawLine(x + 11, y + 10, x + 11, y + 10);
        g.drawLine(x + 10, y + 11, x + 10, y + 11);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 199));
        g.drawLine(x + 3, y + 2, x + 3, y + 2);
        g.drawLine(x + 2, y + 3, x + 2, y + 3);
        g.drawLine(x + 2, y + 9, x + 2, y + 9);
        g.drawLine(x + 3, y + 10, x + 3, y + 10);
        g.drawLine(x + 9, y + 2, x + 9, y + 2);
        g.drawLine(x + 10, y + 3, x + 10, y + 3);
        g.drawLine(x + 9, y + 10, x + 9, y + 10);
        g.drawLine(x + 10, y + 9, x + 10, y + 9);
        g.drawLine(x + 6, y + 1, x + 6, y + 1);
        g.drawLine(x + 6, y + 11, x + 6, y + 11);
        g.drawLine(x + 1, y + 6, x + 1, y + 6);
        g.drawLine(x + 11, y + 6, x + 11, y + 6);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 178));
        g.drawLine(x + 4, y + 1, x + 5, y + 1);
        g.drawLine(x + 7, y + 1, x + 8, y + 1);
        g.drawLine(x + 4, y + 11, x + 5, y + 11);
        g.drawLine(x + 7, y + 11, x + 8, y + 11);
        g.drawLine(x + 1, y + 4, x + 1, y + 5);
        g.drawLine(x + 1, y + 7, x + 1, y + 8);
        g.drawLine(x + 11, y + 4, x + 11, y + 5);
        g.drawLine(x + 11, y + 7, x + 11, y + 8);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 163));
        g.drawLine(x + 3, y + 3, x + 3, y + 3);
        g.drawLine(x + 9, y + 3, x + 9, y + 3);
        g.drawLine(x + 3, y + 9, x + 3, y + 9);
        g.drawLine(x + 9, y + 9, x + 9, y + 9);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 168));
        g.drawLine(x + 4, y + 2, x + 5, y + 2);
        g.drawLine(x + 7, y + 2, x + 8, y + 2);
        g.drawLine(x + 2, y + 4, x + 2, y + 5);
        g.drawLine(x + 10, y + 4, x + 10, y + 5);
        g.drawLine(x + 4, y + 10, x + 5, y + 10);
        g.drawLine(x + 7, y + 10, x + 8, y + 10);
        g.drawLine(x + 2, y + 7, x + 2, y + 8);
        g.drawLine(x + 10, y + 7, x + 10, y + 8);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 178));
        g.drawLine(x + 6, y + 2, x + 6, y + 2);
        g.drawLine(x + 6, y + 10, x + 6, y + 10);
        g.drawLine(x + 2, y + 6, x + 2, y + 6);
        g.drawLine(x + 10, y + 6, x + 10, y + 6);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 138));
        g.drawLine(x + 4, y + 3, x + 4, y + 3);
        g.drawLine(x + 8, y + 3, x + 8, y + 3);
        g.drawLine(x + 3, y + 4, x + 3, y + 4);
        g.drawLine(x + 9, y + 4, x + 9, y + 4);
        g.drawLine(x + 4, y + 9, x + 4, y + 9);
        g.drawLine(x + 8, y + 9, x + 8, y + 9);
        g.drawLine(x + 3, y + 8, x + 3, y + 8);
        g.drawLine(x + 9, y + 8, x + 9, y + 8);
        g.setColor(ColorRoutines.getAlphaColor(Theme.buttonRolloverColor[Theme.style].getColor(), 112));
        g.drawLine(x + 5, y + 3, x + 5, y + 3);
        g.drawLine(x + 7, y + 3, x + 7, y + 3);
        g.drawLine(x + 3, y + 5, x + 3, y + 5);
        g.drawLine(x + 9, y + 5, x + 9, y + 5);
        g.drawLine(x + 5, y + 9, x + 5, y + 9);
        g.drawLine(x + 7, y + 9, x + 7, y + 9);
        g.drawLine(x + 3, y + 7, x + 3, y + 7);
        g.drawLine(x + 9, y + 7, x + 9, y + 7);
    }

    public static void drawXpRadioBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawLine(x + 6, y, x + 6, y);
        g.drawLine(x + 3, y + 1, x + 3, y + 1);
        g.drawLine(x + 9, y + 1, x + 9, y + 1);
        g.drawLine(x + 1, y + 3, x + 1, y + 3);
        g.drawLine(x + 11, y + 3, x + 11, y + 3);
        g.drawLine(x, y + 6, x, y + 6);
        g.drawLine(x + 12, y + 6, x + 12, y + 6);
        g.drawLine(x + 1, y + 9, x + 1, y + 9);
        g.drawLine(x + 11, y + 9, x + 11, y + 9);
        g.drawLine(x + 3, y + 11, x + 3, y + 11);
        g.drawLine(x + 9, y + 11, x + 9, y + 11);
        g.drawLine(x + 6, y + 12, x + 6, y + 12);
        g.setColor(ColorRoutines.getAlphaColor(c, 193));
        g.drawLine(x + 5, y, x + 5, y);
        g.drawLine(x + 7, y, x + 7, y);
        g.drawLine(x + 4, y + 1, x + 4, y + 1);
        g.drawLine(x + 8, y + 1, x + 8, y + 1);
        g.drawLine(x + 2, y + 2, x + 2, y + 2);
        g.drawLine(x + 10, y + 2, x + 10, y + 2);
        g.drawLine(x + 1, y + 4, x + 1, y + 4);
        g.drawLine(x + 11, y + 4, x + 11, y + 4);
        g.drawLine(x, y + 5, x, y + 5);
        g.drawLine(x + 12, y + 5, x + 12, y + 5);
        g.drawLine(x, y + 7, x, y + 7);
        g.drawLine(x + 12, y + 7, x + 12, y + 7);
        g.drawLine(x + 1, y + 8, x + 1, y + 8);
        g.drawLine(x + 11, y + 8, x + 11, y + 8);
        g.drawLine(x + 2, y + 10, x + 2, y + 10);
        g.drawLine(x + 10, y + 10, x + 10, y + 10);
        g.drawLine(x + 4, y + 11, x + 4, y + 11);
        g.drawLine(x + 8, y + 11, x + 8, y + 11);
        g.drawLine(x + 5, y + 12, x + 5, y + 12);
        g.drawLine(x + 7, y + 12, x + 7, y + 12);
        g.setColor(ColorRoutines.getAlphaColor(c, 110));
        g.drawLine(x + 4, y, x + 4, y);
        g.drawLine(x + 8, y, x + 8, y);
        g.drawLine(x + 2, y + 1, x + 2, y + 1);
        g.drawLine(x + 10, y + 1, x + 10, y + 1);
        g.drawLine(x + 5, y + 1, x + 5, y + 1);
        g.drawLine(x + 7, y + 1, x + 7, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 2);
        g.drawLine(x + 11, y + 2, x + 11, y + 2);
        g.drawLine(x + 3, y + 2, x + 3, y + 2);
        g.drawLine(x + 9, y + 2, x + 9, y + 2);
        g.drawLine(x, y + 4, x, y + 4);
        g.drawLine(x + 12, y + 4, x + 12, y + 4);
        g.drawLine(x, y + 8, x, y + 8);
        g.drawLine(x + 12, y + 8, x + 12, y + 8);
        g.drawLine(x + 2, y + 9, x + 2, y + 9);
        g.drawLine(x + 10, y + 9, x + 10, y + 9);
        g.drawLine(x + 1, y + 10, x + 1, y + 10);
        g.drawLine(x + 11, y + 10, x + 11, y + 10);
        g.drawLine(x + 3, y + 10, x + 3, y + 10);
        g.drawLine(x + 9, y + 10, x + 9, y + 10);
        g.drawLine(x + 2, y + 11, x + 2, y + 11);
        g.drawLine(x + 10, y + 11, x + 10, y + 11);
        g.drawLine(x + 5, y + 11, x + 5, y + 11);
        g.drawLine(x + 7, y + 11, x + 7, y + 11);
        g.drawLine(x + 4, y + 12, x + 4, y + 12);
        g.drawLine(x + 8, y + 12, x + 8, y + 12);
        g.setColor(ColorRoutines.getAlphaColor(c, 43));
        g.drawLine(x + 3, y, x + 3, y);
        g.drawLine(x + 9, y, x + 9, y);
        g.drawLine(x, y + 3, x, y + 3);
        g.drawLine(x + 12, y + 3, x + 12, y + 3);
        g.drawLine(x, y + 9, x, y + 9);
        g.drawLine(x + 12, y + 9, x + 12, y + 9);
        g.drawLine(x + 3, y + 12, x + 3, y + 12);
        g.drawLine(x + 9, y + 12, x + 9, y + 12);
    }

    public static ImageIcon colorize(Image img, Color c) {
        ColorRoutines nc = new ColorRoutines(c);
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bufferedImg = conf.createCompatibleImage(w, h, 3);
        int[] pixels = new int[w * h];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("PixelGrabber interrupted waiting for pixels");
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored.");
        } else {
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    bufferedImg.setRGB(x, y, DrawRoutines.colorize(pixels[y * w + x], nc));
                    ++x;
                }
                ++y;
            }
        }
        return new ImageIcon(bufferedImg);
    }

    protected static int colorize(int px, ColorRoutines nc) {
        int a = px >> 24 & 0xFF;
        if (a == 0) {
            return px;
        }
        int r = px >> 16 & 0xFF;
        int g = px >> 8 & 0xFF;
        int b = px & 0xFF;
        if (r == g && r == b) {
            return px;
        }
        return nc.colorize(r, g, b, a);
    }

    public static BufferedImage getBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage img2 = conf.createCompatibleImage(w, h);
        Graphics g = img2.getGraphics();
        g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
        return img2;
    }
}

