/*
 * CategorySeriesDialog.java
 *
 * Created on 17 agosto 2005, 11.19
 */

package it.businesslogic.ireport.chart;

/**
 *
 * @author  Administrator
 */
public class XYZSeriesDialog extends javax.swing.JDialog {
    
    private String seriesExpression = "";
    private String xValueExpression = "";
    private String yValueExpression = "";
    private String zValueExpression = "";
    
    private int dialogResult = javax.swing.JOptionPane.CANCEL_OPTION;
    
    /** Creates new form CategorySeriesDialog */
    public XYZSeriesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        applyI18n();
        
        this.setSize(500,500);
        it.businesslogic.ireport.util.Misc.centerFrame(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jLabelSeriesExpression = new javax.swing.JLabel();
        jLabelXValueExpression = new javax.swing.JLabel();
        jLabelYValueExpression = new javax.swing.JLabel();
        jLabelZValueExpression = new javax.swing.JLabel();
        jRTextExpressionSeries = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionXValue = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionYValue = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionZValue = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel6 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("XYZ series");
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabelSeriesExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelSeriesExpression.setText("Series expression (required)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jLabelSeriesExpression, gridBagConstraints);

        jLabelXValueExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelXValueExpression.setText("X value expression (required)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jLabelXValueExpression, gridBagConstraints);

        jLabelYValueExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelYValueExpression.setText("Y value expression (required)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jLabelYValueExpression, gridBagConstraints);

        jLabelZValueExpression.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelZValueExpression.setText("Z value expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jLabelZValueExpression, gridBagConstraints);

        jRTextExpressionSeries.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionSeries.setElectricScroll(0);
        jRTextExpressionSeries.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionSeries.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionSeries, gridBagConstraints);

        jRTextExpressionXValue.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionXValue.setElectricScroll(0);
        jRTextExpressionXValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionXValue.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionXValue, gridBagConstraints);

        jRTextExpressionYValue.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionYValue.setElectricScroll(0);
        jRTextExpressionYValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionYValue.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionYValue, gridBagConstraints);

        jRTextExpressionZValue.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionZValue.setElectricScroll(0);
        jRTextExpressionZValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionZValue.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionZValue, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jPanel1, gridBagConstraints);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add(jPanel7, gridBagConstraints);

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel6.add(jButtonOK, gridBagConstraints);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel6.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel6, gridBagConstraints);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed

        seriesExpression = jRTextExpressionSeries.getText();
        setXValueExpression(jRTextExpressionXValue.getText());
        setYValueExpression(jRTextExpressionYValue.getText());
        setZValueExpression(jRTextExpressionZValue.getText());
         
       
        java.text.MessageFormat formatter = new java.text.MessageFormat( it.businesslogic.ireport.util.I18n.getString("gui.notvalidexp","{0} cannot be blank!") );

        if (seriesExpression.trim().length() == 0) {
            
           javax.swing.JOptionPane.showMessageDialog(this, formatter.format(new Object[]{it.businesslogic.ireport.util.I18n.getString("charts.seriesExpression","Series expression")}) ,"Invalid expression",javax.swing.JOptionPane.ERROR_MESSAGE);
           return;
        } 
        
        if (xValueExpression.trim().length() == 0) {
           javax.swing.JOptionPane.showMessageDialog(this, formatter.format(new Object[]{it.businesslogic.ireport.util.I18n.getString("charts.yValueExpression","X Value expression")}) ,"Invalid expression",javax.swing.JOptionPane.ERROR_MESSAGE);
           return;
        }  
        
        if (yValueExpression.trim().length() == 0) {
           javax.swing.JOptionPane.showMessageDialog(this, formatter.format(new Object[]{it.businesslogic.ireport.util.I18n.getString("charts.yValueExpression","Y Value expression")}) ,"Invalid expression",javax.swing.JOptionPane.ERROR_MESSAGE);
           return;
        } 
        
        this.setDialogResult(javax.swing.JOptionPane.OK_OPTION);
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CategorySeriesDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }

    public String getSeriesExpression() {
        return seriesExpression;
    }

    public void setSeriesExpression(String seriesExpression) {
        this.seriesExpression = seriesExpression;
        jRTextExpressionSeries.setText( seriesExpression );
    }

 
    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabelSeriesExpression;
    private javax.swing.JLabel jLabelXValueExpression;
    private javax.swing.JLabel jLabelYValueExpression;
    private javax.swing.JLabel jLabelZValueExpression;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionSeries;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionXValue;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionYValue;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionZValue;
    // End of variables declaration//GEN-END:variables
    
        public void applyI18n()
        {
            jButtonOK.setText( it.businesslogic.ireport.util.I18n.getString("ok","Ok"));
            jButtonCancel.setText( it.businesslogic.ireport.util.I18n.getString("cancel","Cancel"));
             
            jLabelSeriesExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.seriesExpression","Series expression"));
            jLabelXValueExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.xValueExpression","X Value expression"));
            jLabelYValueExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.yValueExpression","Y Value expression"));
            jLabelZValueExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.zValueExpression","Z Value expression"));

            
            this.getRootPane().updateUI();
        }

    public String getXValueExpression() {
        return xValueExpression;
    }

    public void setXValueExpression(String xValueExpression) {
        this.xValueExpression = xValueExpression;
        jRTextExpressionXValue.setText( xValueExpression );
    }

    public String getYValueExpression() {
        return yValueExpression;
    }

    public void setYValueExpression(String yValueExpression) {
        this.yValueExpression = yValueExpression;
        jRTextExpressionYValue.setText( yValueExpression );
    }

    public String getZValueExpression() {
        return zValueExpression;
    }

    public void setZValueExpression(String zValueExpression) {
        this.zValueExpression = zValueExpression;
        jRTextExpressionZValue.setText( zValueExpression );
    }
}
