/*
 * FormatCommandAlignCenter.java
 *
 * Center the selected items in the center of the band, between the margins.
 *
 * Created on 9 mei 2005, 21:36
 */
package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;

import java.awt.Point;


public class FormatCommandAlignCenter
    extends FormatCommand
{

    /**
     * Creates a new FormatCommandAlignCenter object.
     */
    FormatCommandAlignCenter()
    {
        operationType = OperationType.ALIGN_CENTER;
    }

    int centerx;

    /**
     * DOCUMENT ME!
     */
    public void preparation()
    {
        centerx = 10 + jrf.getReport().getWidth() / 2;
    }

    /**
     * DOCUMENT ME!
     */
    public void modify()
    {

        int centery = jrf.getReport().getBandYLocation(re.getBand()) + 10 + 
                      re.getBand().getHeight() / 2;
        re.setPosition(new Point(centerx - (re.getWidth() / 2), 
                                 centery - (re.getHeight() / 2)));
    }

    /**
     * Returns the value of centerx.
     * @return centerx!
     */
    public int getCenterx()
    {

        return centerx;
    }

    /**
     * Sets the value of centerx.
     * 
     * @param centerx The value to assign centerx.
     */
    public void setCenterx(int centerx)
    {
        this.centerx = centerx;
    }
}
