/*
 * ComboBoxSheetProperty.java
 *
 * Created on 16 febbraio 2005, 19.13
 */

package it.businesslogic.ireport.gui.sheet;

import java.util.*;
import javax.swing.*;
import it.businesslogic.ireport.util.*;

public class ExpressionSheetProperty extends SheetProperty {
    
    private ExpressionSheetPropertyComponent editor = null;
    
    public ExpressionSheetProperty(String key, String name) {
        super( key, name, SheetProperty.STRING, "");
    }
    
    public JComponent getEditor()
    {
        if (editor != null) return editor;
        editor = new ExpressionSheetPropertyComponent();
        editor.addActionListener( this );
        return editor;
    }
    
    public Object getEditorValue(JComponent component)
    {
        return editor.getExpression();
    }
    
    public void setEditorValue(JComponent component, Object str)
    {
        try {
            getEditor(); // In this way we are sure that editor is not null.
            
            if (str != null)
            {
                editor.setExpression(""+str);
            }
            else
            {
                editor.setExpression("");
            }
        } catch (Exception ex) {}
    }
}