/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class TinyButtonUI
extends MetalButtonUI {
    public static final boolean HINT_DO_NOT_PAINT_TOOLBARBUTTON_IF_NO_MOUSE_OVER = true;
    private static final TinyButtonUI buttonUI = new TinyButtonUI();
    private static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private boolean graphicsTranslated;
    private boolean isToolBarButton;
    private boolean isDefault;

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        if (!ControlPanel.isInstantiated) {
            return;
        }
        button.setForeground(Theme.buttonFontColor[Theme.style].getColor());
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.isToolBarButton && !Theme.toolFocus[Theme.style] || !Theme.buttonFocus[Theme.style]) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle focusRect = b.getBounds();
        g.setColor(Color.black);
        g2d.setStroke(focusStroke);
        int x1 = 2;
        int y1 = 2;
        int x2 = x1 + focusRect.width - 5;
        int y2 = y1 + focusRect.height - 5;
        if (Theme.derivedStyle[Theme.style] == 1) {
            if (!this.isToolBarButton) {
                ++x1;
                ++y1;
                --x2;
                --y2;
            }
            if (this.graphicsTranslated) {
                g.translate(-1, -1);
            }
        }
        g2d.drawLine(x1, y1, x2, y1);
        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1, y2, x2, y2);
        g2d.drawLine(x2, y1, x2, y2);
    }

    public static ComponentUI createUI(final JComponent c) {
        if (Theme.buttonRollover[Theme.style]) {
            if (c instanceof JButton) {
                JButton b = (JButton)c;
                b.setRolloverEnabled(true);
            } else if (c instanceof JToggleButton) {
                JToggleButton b = (JToggleButton)c;
                b.setRolloverEnabled(true);
            }
        }
        c.setOpaque(false);
        c.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                c.setOpaque(false);
            }
        });
        return buttonUI;
    }

    protected void paintButtonPressed(Graphics g, AbstractButton button) {
        if (this.isToolBarButton) {
            return;
        }
        Color col = null;
        col = !button.getBackground().equals(Theme.backColor[Theme.style].getColor()) ? ColorRoutines.darken(button.getBackground(), 10) : Theme.buttonPressedColor[Theme.style].getColor();
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button, col, true);
                break;
            }
            case 1: {
                this.drawWinButton(g, button, col, true);
                break;
            }
            case 2: {
                this.drawXpButton(g, button, col, true);
            }
        }
        if (Theme.derivedStyle[Theme.style] == 1) {
            g.translate(1, 1);
            this.graphicsTranslated = true;
        }
    }

    public void paintToolBarButton(Graphics g, AbstractButton button) {
        Color col = null;
        if (!button.isEnabled()) {
            return;
        }
        if (button.getModel().isPressed()) {
            col = Theme.toolButtPressedColor[Theme.style].getColor();
        } else if (button.getModel().isRollover()) {
            col = button.isSelected() || Theme.toolRollover[Theme.style] ? Theme.toolButtRolloverColor[Theme.style].getColor() : Theme.toolButtColor[Theme.style].getColor();
        } else if (button.isSelected()) {
            col = Theme.toolButtColor[Theme.style].getColor();
        } else {
            return;
        }
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyToolBarButton(g, button, col, false);
                break;
            }
            case 1: {
                this.drawWinToolBarButton(g, button, col, false);
                break;
            }
            case 2: {
                this.drawXpToolBarButton(g, button, col, false);
            }
        }
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (this.isToolBarButton) {
            this.paintToolBarButton(g, button);
            super.paint(g, c);
            return;
        }
        if (button instanceof JToggleButton && button.isSelected()) {
            this.paintButtonPressed(g, button);
            super.paint(g, c);
            return;
        }
        this.isDefault = c instanceof JButton && ((JButton)c).isDefaultButton();
        Color col = null;
        col = !button.isEnabled() ? Theme.buttonDisabledColor[Theme.style].getColor() : (button.getModel().isPressed() ? Theme.buttonNormalColor[Theme.style].getColor() : (button.getModel().isRollover() && Theme.buttonRollover[Theme.style] ? Theme.buttonRolloverBgColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()));
        if (!c.getBackground().equals(Theme.backColor[Theme.style].getColor())) {
            col = c.getBackground();
        }
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button, col, false);
                break;
            }
            case 1: {
                this.drawWinButton(g, button, col, false);
                break;
            }
            case 2: {
                this.drawXpButton(g, button, col, false);
            }
        }
        super.paint(g, c);
    }

    public void update(Graphics g, JComponent c) {
        this.isToolBarButton = c.getClientProperty("JToolBar.isToolbarButton") == Boolean.TRUE;
        this.paint(g, c);
        this.graphicsTranslated = false;
    }

    private void drawTinyButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        g.fillRect(2, 2, w - 3, h - 3);
    }

    private void drawWinButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        int x = 0;
        int y = 0;
        if (b.isContentAreaFilled()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
        if (b.getBorder() == null || !b.isBorderPainted()) {
            return;
        }
        if (isPressed) {
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
            g.drawRect(1, 1, w - 3, h - 3);
            return;
        }
        if (this.isDefault && b.isEnabled()) {
            g.setColor(Theme.buttonDefaultColor[Theme.style].getColor());
            g.drawRect(0, 0, w - 1, h - 1);
            ++x;
            ++y;
            --w;
            --h;
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        g.drawLine(x, y, w - 2, y);
        g.drawLine(x, y + 1, x, h - 2);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonBorderColor[Theme.style].getColor());
        }
        g.drawLine(x, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, y, w - 1, h - 1);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 1, w - 2, h - 2);
    }

    private void drawXpButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled()) {
            int spread1 = Theme.buttonSpreadLight[Theme.style];
            int spread2 = Theme.buttonSpreadDark[Theme.style];
            if (!b.isEnabled()) {
                spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
                spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
            }
            float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 3);
            float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 3);
            int halfY = h / 2;
            int y = 1;
            while (y < h - 1) {
                int yd;
                if (y < halfY) {
                    yd = halfY - y;
                    g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                } else if (y == halfY) {
                    g.setColor(c);
                } else {
                    yd = y - halfY;
                    g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                }
                g.drawLine(2, y, w - 3, y);
                if (y == 1 && b.isEnabled()) {
                    g.drawLine(1, 2, 1, h - 3);
                } else if (y == h - 2) {
                    g.drawLine(w - 2, 2, w - 2, h - 3);
                }
                ++y;
            }
        }
        if (b.getBorder() == null || !b.isBorderPainted()) {
            return;
        }
        if (!b.isEnabled()) {
            DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderDisabledColor[Theme.style].getColor(), 0, 0, w, h);
        } else {
            DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderColor[Theme.style].getColor(), 0, 0, w, h);
            if (isPressed) {
                return;
            }
            if (b.getModel().isRollover() && Theme.buttonRollover[Theme.style]) {
                DrawRoutines.drawRolloverBorder(g, Theme.buttonRolloverColor[Theme.style].getColor(), 0, 0, w, h);
            } else if (this.isDefault) {
                DrawRoutines.drawDefaultBorder(g, Theme.buttonDefaultColor[Theme.style].getColor(), 0, 0, w, h);
            }
        }
    }

    private void drawTinyToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        g.fillRect(1, 1, w - 2, h - 2);
    }

    private void drawWinToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
        if (b.getBorder() == null || !b.isBorderPainted()) {
            return;
        }
        g.setColor(Theme.toolBorderLightColor[Theme.style].getColor());
        if (b.isSelected() || b.getModel().isPressed() && b.getModel().isRollover()) {
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        } else {
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
        }
        g.setColor(Theme.toolBorderDarkColor[Theme.style].getColor());
        if (b.isSelected() || b.getModel().isPressed() && b.getModel().isRollover()) {
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
        } else {
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }
        if (b.isSelected() || b.getModel().isPressed()) {
            g.translate(1, 1);
            this.graphicsTranslated = true;
        }
    }

    private void drawXpToolBarButton(Graphics g, AbstractButton b, Color c, boolean isPressed) {
        int w = b.getWidth();
        int h = b.getHeight();
        if (b.isContentAreaFilled()) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
        if (b.getBorder() == null || !b.isBorderPainted()) {
            return;
        }
        Color col = null;
        col = b.getModel().isPressed() && b.getModel().isRollover() ? Theme.toolBorderPressedColor[Theme.style].getColor() : (b.isSelected() ? Theme.toolBorderSelectedColor[Theme.style].getColor() : Theme.toolBorderColor[Theme.style].getColor());
        DrawRoutines.drawRoundedBorder(g, col, 0, 0, b.getWidth(), b.getHeight());
    }
}

