/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import java.awt.Graphics2D;

public abstract class GraphicReportElement
extends ReportElement {
    public String graphicElementPen;
    public String fill;

    public GraphicReportElement(int x, int y, int width, int height) {
        super(x, y, Math.abs(width), Math.abs(height));
        this.setGraphicElementPen("Thin");
        this.fill = "Solid";
        this.stretchType = "NoStretch";
        this.setKey("graphic");
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        super.drawGraphicsElement(g, this.graphicElementPen, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public String getFill() {
        return this.fill;
    }

    public void setFill(String fill) {
        this.fill = fill;
    }

    public String getGraphicElementPen() {
        return this.graphicElementPen;
    }

    public void setGraphicElementPen(String graphicElementPen) {
        this.graphicElementPen = graphicElementPen;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof GraphicReportElement && source instanceof GraphicReportElement) {
            ((GraphicReportElement)destination).setFill(new String(((GraphicReportElement)source).getFill()));
            ((GraphicReportElement)destination).setGraphicElementPen(new String(((GraphicReportElement)source).getGraphicElementPen()));
            ((GraphicReportElement)destination).setStretchType(new String(((GraphicReportElement)source).getStretchType()));
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            this.setFill(style.getAttributeString("fill", this.getFill(), true));
            this.setGraphicElementPen(style.getAttributeString("pen", this.getGraphicElementPen(), true));
        }
    }
}

