/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.logpane;

import it.businesslogic.ireport.gui.logpane.LogTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class LogPane
extends JPanel
implements ActionListener {
    private LogTextArea mainLogTextArea;
    private Vector logsComponents = new Vector();
    private LogTextArea pointedLogTextArea = null;
    private JMenuItem jMenuItemClearLog;
    private JMenuItem jMenuItemCloseLog;
    private JMenuItem jMenuItemKeepLog;
    private JPopupMenu jPopupMenuLog;
    private JTabbedPane jTabbedPaneLogs;

    public LogPane() {
        this.initComponents();
        this.mainLogTextArea = new LogTextArea("Main console");
        this.mainLogTextArea.setLogPane(this);
        this.mainLogTextArea.addActionListener(this);
        this.updateLogTabs();
    }

    protected void updateLogTabs() {
        if (this.logsComponents.size() > 0) {
            this.jTabbedPaneLogs.removeAll();
            this.jTabbedPaneLogs.add(this.mainLogTextArea.getTitle(), this.mainLogTextArea);
            for (int i = 0; i < this.logsComponents.size(); ++i) {
                this.jTabbedPaneLogs.add(((LogTextArea)this.logsComponents.elementAt(i)).getTitle(), (LogTextArea)this.logsComponents.elementAt(i));
            }
            if (this.getComponentCount() == 0 || this.getComponent(0) != this.jTabbedPaneLogs) {
                this.remove(this.mainLogTextArea);
                this.add((Component)this.jTabbedPaneLogs, "Center");
            }
        } else if (this.getComponentCount() == 0 || this.getComponent(0) == this.jTabbedPaneLogs) {
            if (this.getComponentCount() > 0) {
                this.remove(this.jTabbedPaneLogs);
            }
            this.add((Component)this.mainLogTextArea, "Center");
        }
        this.updateUI();
    }

    private void initComponents() {
        this.jPopupMenuLog = new JPopupMenu();
        this.jMenuItemClearLog = new JMenuItem();
        this.jMenuItemCloseLog = new JMenuItem();
        this.jMenuItemKeepLog = new JMenuItem();
        this.jTabbedPaneLogs = new JTabbedPane();
        this.jMenuItemClearLog.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemClearLog.setText("Clear log");
        this.jMenuItemClearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPane.this.jMenuItemClearLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemClearLog);
        this.jMenuItemCloseLog.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemCloseLog.setText("Close log");
        this.jMenuItemCloseLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPane.this.jMenuItemCloseLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCloseLog);
        this.jMenuItemKeepLog.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemKeepLog.setText("Keep log");
        this.jMenuItemKeepLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPane.this.jMenuItemKeepLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemKeepLog);
        this.setLayout(new BorderLayout());
        this.jTabbedPaneLogs.setFont(new Font("Dialog", 0, 11));
        this.jTabbedPaneLogs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogPane.this.jTabbedPaneLogsMouseClicked(evt);
            }
        });
        this.add((Component)this.jTabbedPaneLogs, "Center");
    }

    private void jMenuItemKeepLogActionPerformed(ActionEvent evt) {
        this.pointedLogTextArea.setRemovable(false);
    }

    private void jMenuItemCloseLogActionPerformed(ActionEvent evt) {
        if (this.pointedLogTextArea != this.getMainLogTextArea()) {
            this.removeLog(this.pointedLogTextArea);
        }
    }

    private void jTabbedPaneLogsMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenuLog.show(this, evt.getPoint().x, evt.getPoint().y);
            this.pointedLogTextArea = (LogTextArea)this.jTabbedPaneLogs.getSelectedComponent();
        }
    }

    private void jMenuItemClearLogActionPerformed(ActionEvent evt) {
        this.pointedLogTextArea.clearConsole();
    }

    public LogTextArea createNewLog() {
        LogTextArea lta = new LogTextArea("Log");
        lta.setLogPane(this);
        lta.addActionListener(this);
        this.logsComponents.addElement(lta);
        for (int i = 0; i < this.logsComponents.size(); ++i) {
            if (!((LogTextArea)this.logsComponents.elementAt(i)).isRemovable()) continue;
            this.logsComponents.removeElementAt(i);
            --i;
        }
        this.updateLogTabs();
        return lta;
    }

    public void removeLog(int logIndex) {
        this.logsComponents.removeElementAt(logIndex);
        this.updateLogTabs();
    }

    public void removeLog(LogTextArea logTextArea) {
        this.logsComponents.removeElement(logTextArea);
        this.updateLogTabs();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == null) {
            return;
        }
        for (int i = 0; i < this.jTabbedPaneLogs.getComponentCount(); ++i) {
            LogTextArea lta = (LogTextArea)this.jTabbedPaneLogs.getComponent(i);
            if (lta != actionEvent.getSource()) continue;
            this.jTabbedPaneLogs.setTitleAt(i, lta.getTitle());
            break;
        }
    }

    public LogTextArea getMainLogTextArea() {
        return this.mainLogTextArea;
    }

    public void setMainLogTextArea(LogTextArea mainLogTextArea) {
        this.mainLogTextArea = mainLogTextArea;
    }

    public void setActiveLog(LogTextArea logTextArea) {
        try {
            this.jTabbedPaneLogs.setSelectedComponent(logTextArea);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

