/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.FontSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StyleDialog
extends JDialog
implements SheetPropertyValueChangedListener {
    private Style style = null;
    private CategorySheetPanel sheetPanel = null;
    private boolean insertMode = true;
    private IReportFont ireportFont = null;
    private Report currentReport = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JPanel jPanel1;
    private JPanel jPanelProperties;
    private int dialogResult;

    public StyleDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public StyleDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.style = new Style();
        this.setSize(420, 620);
        Misc.centerFrame(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, -1, -1, -1);
        this.sheetPanel = new CategorySheetPanel();
        this.sheetPanel.addSheetPropertyValueChangedListener(this);
        this.jPanelProperties.add((Component)this.sheetPanel, gridBagConstraints);
        SheetProperty customizerClassProperty = new SheetProperty("name", "Style name", 0);
        this.sheetPanel.addSheetProperty("Style", customizerClassProperty);
        SheetProperty isDefaultProperty = new SheetProperty("isDefault", "Default style", 4);
        this.sheetPanel.addSheetProperty("Style", isDefaultProperty);
        SheetProperty modeProperty = new SheetProperty("mode", "Mode", 2);
        modeProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Opaque", "Opaque"), new Tag("Transparent", "Transparent")});
        this.sheetPanel.addSheetProperty("Common", modeProperty);
        SheetProperty forecolorProperty = new SheetProperty("forecolor", "Forecolor", 3);
        forecolorProperty.setValue(null);
        this.sheetPanel.addSheetProperty("Common", forecolorProperty);
        SheetProperty backcolorProperty = new SheetProperty("backcolor", "Backcolor", 3);
        backcolorProperty.setValue(null);
        this.sheetPanel.addSheetProperty("Common", backcolorProperty);
        ComboBoxSheetProperty styleProperty = new ComboBoxSheetProperty("style", "Parent style");
        this.sheetPanel.addSheetProperty("Style", styleProperty);
        SheetProperty penProperty = new SheetProperty("pen", "Pen", 2);
        penProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Common", penProperty);
        SheetProperty fillProperty = new SheetProperty("fill", "Fill", 2);
        fillProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Solid", "Solid")});
        this.sheetPanel.addSheetProperty("Common", fillProperty);
        SheetProperty radiusProperty = new SheetProperty("radius", "Radius", 6);
        this.sheetPanel.addSheetProperty("Graphics", radiusProperty);
        SheetProperty scaleImageProperty = new SheetProperty("scaleImage", "Scale image", 2);
        scaleImageProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Clip", "Clip"), new Tag("FillFrame", "FillFrame"), new Tag("RetainShape", "RetainShape")});
        this.sheetPanel.addSheetProperty("Graphics", scaleImageProperty);
        SheetProperty hAlignProperty = new SheetProperty("hAlign", "Horizontal align", 2);
        hAlignProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Left", "Left"), new Tag("Center", "Center"), new Tag("Right", "Right"), new Tag("Justified", "Justified")});
        this.sheetPanel.addSheetProperty("Graphics", hAlignProperty);
        SheetProperty vAlignProperty = new SheetProperty("vAlign", "Vertical align", 2);
        vAlignProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Top", "Top"), new Tag("Middle", "Middle"), new Tag("Bottom", "Bottom")});
        this.sheetPanel.addSheetProperty("Graphics", vAlignProperty);
        SheetProperty borderProperty = new SheetProperty("border", "Border", 2);
        borderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", borderProperty);
        SheetProperty borderColorProperty = new SheetProperty("borderColor", "Border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", borderColorProperty);
        SheetProperty paddingProperty = new SheetProperty("padding", "Padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", paddingProperty);
        SheetProperty topBorderProperty = new SheetProperty("topBorder", "Top border", 2);
        topBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", topBorderProperty);
        SheetProperty topBorderColorProperty = new SheetProperty("topBorderColor", "Top border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", topBorderColorProperty);
        SheetProperty topPaddingProperty = new SheetProperty("topPadding", "Top padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", topPaddingProperty);
        SheetProperty leftBorderProperty = new SheetProperty("leftBorder", "Left border", 2);
        leftBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", leftBorderProperty);
        SheetProperty leftBorderColorProperty = new SheetProperty("leftBorderColor", "Left border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", leftBorderColorProperty);
        SheetProperty leftPaddingProperty = new SheetProperty("leftPadding", "Left padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", leftPaddingProperty);
        SheetProperty bottomBorderProperty = new SheetProperty("bottomBorder", "Bottom border", 2);
        bottomBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", bottomBorderProperty);
        SheetProperty bottomBorderColorProperty = new SheetProperty("bottomBorderColor", "Bottom border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", bottomBorderColorProperty);
        SheetProperty bottomPaddingProperty = new SheetProperty("bottomPadding", "Bottom padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", bottomPaddingProperty);
        SheetProperty rightBorderProperty = new SheetProperty("rightBorder", "Right border", 2);
        rightBorderProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Thin", "Thin"), new Tag("1Point", "1Point"), new Tag("2Point", "2Point"), new Tag("4Point", "4Point"), new Tag("Dotted", "Dotted")});
        this.sheetPanel.addSheetProperty("Border and padding", rightBorderProperty);
        SheetProperty rightBorderColorProperty = new SheetProperty("rightBorderColor", "Right border color", 3);
        this.sheetPanel.addSheetProperty("Border and padding", rightBorderColorProperty);
        SheetProperty rightPaddingProperty = new SheetProperty("rightPadding", "Right padding", 6);
        this.sheetPanel.addSheetProperty("Border and padding", rightPaddingProperty);
        SheetProperty rotationProperty = new SheetProperty("rotation", "Rotation", 2);
        rotationProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("None", "None"), new Tag("Left", "Left"), new Tag("Right", "Right")});
        this.sheetPanel.addSheetProperty("Text properties", rotationProperty);
        SheetProperty patternProperty = new SheetProperty("pattern", "Pattern", 0);
        this.sheetPanel.addSheetProperty("Text properties", patternProperty);
        SheetProperty isBlankWhenNullProperty = new SheetProperty("isBlankWhenNull", "Is Blank when Null", 4);
        this.sheetPanel.addSheetProperty("Text properties", isBlankWhenNullProperty);
        FontSheetProperty theFontSpacingProperty = new FontSheetProperty("style.font", "Font");
        theFontSpacingProperty.setFontMode(3);
        this.sheetPanel.addSheetProperty("Text properties", theFontSpacingProperty);
        SheetProperty lineSpacingProperty = new SheetProperty("lineSpacing", "Line spacing", 2);
        lineSpacingProperty.setTags(new Tag[]{new Tag(null, "Default"), new Tag("Single", "Single"), new Tag("1_1_2", "1_1_2"), new Tag("Double", "Double")});
        this.sheetPanel.addSheetProperty("Text properties", lineSpacingProperty);
        SheetProperty isStyledTextProperty = new SheetProperty("isStyledText", "Is Styled Text", 4);
        this.sheetPanel.addSheetProperty("Text properties", isStyledTextProperty);
        this.sheetPanel.recreateSheet();
        this.updateStyleValues();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanelProperties = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify Style");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StyleDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StyleDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanelProperties.setLayout(new GridBagLayout());
        this.jPanelProperties.setBorder(BorderFactory.createBevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanelProperties, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.sheetPanel.getPropertyValue("name") == null || (this.sheetPanel.getPropertyValue("name") + "").trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid name for the style!", "Invalid name!", 2);
            return;
        }
        String newName = this.sheetPanel.getPropertyValue("name") + "";
        Enumeration e = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements();
        while (e.hasMoreElements()) {
            Style st = (Style)e.nextElement();
            if (!st.getAttributeString("name", "").equals(newName) || st == this.getStyle()) continue;
            JOptionPane.showMessageDialog(this, "The name \"" + newName + "\" is already in use!\nPlease change it.", "Invalid name!", 2);
            return;
        }
        Vector properties = this.sheetPanel.getProperties();
        this.getStyle().getAttributes().clear();
        for (int i = 0; i < properties.size(); ++i) {
            SheetProperty sp = (SheetProperty)properties.get(i);
            if (sp.getValue() == null) continue;
            this.getStyle().getAttributes().put(sp.getKeyName(), sp.getValue());
        }
        HashMap hashMap = this.getStyle().getAttributes();
        this.getStyle();
        if (hashMap.get("style") != null) {
            HashMap hashMap2 = this.getStyle().getAttributes();
            this.getStyle();
            if (!(hashMap2.get("style") instanceof Style)) {
                StringBuffer stringBuffer = new StringBuffer().append("");
                HashMap hashMap3 = this.getStyle().getAttributes();
                this.getStyle();
                String sname = stringBuffer.append(hashMap3.get("style")).toString();
                for (int j = 0; j < this.currentReport.getStyles().size(); ++j) {
                    Style sparent = (Style)this.currentReport.getStyles().elementAt(j);
                    if (!sparent.getName().equals(sname)) continue;
                    HashMap hashMap4 = this.getStyle().getAttributes();
                    this.getStyle();
                    hashMap4.put("style", sparent);
                }
            }
        }
        Style style = this.getStyle();
        this.getStyle();
        if (style.getAttributeBoolean("isDefault", false)) {
            Enumeration enum_s = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().elements();
            while (enum_s.hasMoreElements()) {
                Style tmp_s = (Style)enum_s.nextElement();
                if (tmp_s == this.getStyle()) continue;
                HashMap hashMap5 = tmp_s.getAttributes();
                this.getStyle();
                hashMap5.remove("isDefault");
            }
        }
        if (this.ireportFont != null) {
            this.getStyle().getAttributes().put("fontName", this.ireportFont.getFontName());
            this.getStyle().getAttributes().put("fontSize", new Integer(this.ireportFont.getFontSize()));
            this.getStyle().getAttributes().put("isBold", new Boolean(this.ireportFont.isBold()));
            this.getStyle().getAttributes().put("isItalic", new Boolean(this.ireportFont.isItalic()));
            this.getStyle().getAttributes().put("isUnderline", new Boolean(this.ireportFont.isUnderline()));
            this.getStyle().getAttributes().put("isStrikeThrough", new Boolean(this.ireportFont.isStrikeTrought()));
            this.getStyle().getAttributes().put("isPdfEmbedded", new Boolean(this.ireportFont.isPdfEmbedded()));
            this.getStyle().getAttributes().put("pdfFontName", this.ireportFont.getPDFFontName());
        }
        if (this.isInsertMode()) {
            MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles().add(this.getStyle());
        }
        MainFrame.getMainInstance().getActiveReportFrame().getReport().fireStyleChangedListenerStyleChanged(new StyleChangedEvent(MainFrame.getMainInstance().getActiveReportFrame().getReport(), this.isInsertMode() ? 0 : 1, this.getStyle(), this.getStyle()));
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).show();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public CategorySheetPanel getSheetPanel() {
        return this.sheetPanel;
    }

    public void setSheetPanel(CategorySheetPanel sheetPanel) {
        this.sheetPanel = sheetPanel;
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals("style.font")) {
            this.setIreportFont((IReportFont)evt.getNewValue());
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void updateStyleValues() {
        this.sheetPanel.setPropertyValue("name", this.getStyle().getAttribute("name"));
        this.sheetPanel.setPropertyValue("backcolor", this.getStyle().getAttribute("backcolor"));
        this.sheetPanel.setPropertyValue("borderColor", this.getStyle().getAttribute("borderColor"));
        this.sheetPanel.setPropertyValue("border", this.getStyle().getAttribute("border"));
        this.sheetPanel.setPropertyValue("bottomBorderColor", this.getStyle().getAttribute("bottomBorderColor"));
        this.sheetPanel.setPropertyValue("bottomBorder", this.getStyle().getAttribute("bottomBorder"));
        this.sheetPanel.setPropertyValue("bottomPadding", this.getStyle().getAttribute("bottomPadding"));
        this.sheetPanel.setPropertyValue("fill", this.getStyle().getAttribute("fill"));
        this.sheetPanel.setPropertyValue("forecolor", this.getStyle().getAttribute("forecolor"));
        this.sheetPanel.setPropertyValue("hAlign", this.getStyle().getAttribute("hAlign"));
        this.sheetPanel.setPropertyValue("isBlankWhenNull", this.getStyle().getAttribute("isBlankWhenNull"));
        this.sheetPanel.setPropertyValue("isDefault", this.getStyle().getAttribute("isDefault"));
        this.sheetPanel.setPropertyValue("leftBorderColor", this.getStyle().getAttribute("leftBorderColor"));
        this.sheetPanel.setPropertyValue("leftBorder", this.getStyle().getAttribute("leftBorder"));
        this.sheetPanel.setPropertyValue("leftPadding", this.getStyle().getAttribute("leftPadding"));
        this.sheetPanel.setPropertyValue("lineSpacing", this.getStyle().getAttribute("lineSpacing"));
        this.sheetPanel.setPropertyValue("mode", this.getStyle().getAttribute("mode"));
        this.sheetPanel.setPropertyValue("padding", this.getStyle().getAttribute("padding"));
        this.sheetPanel.setPropertyValue("pattern", this.getStyle().getAttribute("pattern"));
        this.sheetPanel.setPropertyValue("pen", this.getStyle().getAttribute("pen"));
        this.sheetPanel.setPropertyValue("radius", this.getStyle().getAttribute("radius"));
        this.sheetPanel.setPropertyValue("rightBorderColor", this.getStyle().getAttribute("rightBorderColor"));
        this.sheetPanel.setPropertyValue("rightBorder", this.getStyle().getAttribute("rightBorder"));
        this.sheetPanel.setPropertyValue("rightPadding", this.getStyle().getAttribute("rightPadding"));
        this.sheetPanel.setPropertyValue("rotation", this.getStyle().getAttribute("rotation"));
        this.sheetPanel.setPropertyValue("scaleImage", this.getStyle().getAttribute("scaleImage"));
        this.sheetPanel.setPropertyValue("style", this.getStyle().getAttribute("style"));
        this.sheetPanel.setPropertyValue("isStyledText", this.getStyle().getAttribute("isStyledText"));
        this.sheetPanel.setPropertyValue("style.font", this.getIreportFont());
        this.sheetPanel.setPropertyValue("topBorderColor", this.getStyle().getAttribute("topBorderColor"));
        this.sheetPanel.setPropertyValue("topBorder", this.getStyle().getAttribute("topBorder"));
        this.sheetPanel.setPropertyValue("topPadding", this.getStyle().getAttribute("topPadding"));
        this.sheetPanel.setPropertyValue("vAlign", this.getStyle().getAttribute("vAlign"));
    }

    public void setStyle(Style myStyle) {
        this.style = myStyle;
        if (MainFrame.getMainInstance().getActiveReportFrame() != null && this.currentReport != MainFrame.getMainInstance().getActiveReportFrame().getReport()) {
            this.currentReport = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            Enumeration enum_styles = this.currentReport.getStyles().elements();
            Vector<Style> tags = new Vector<Style>();
            while (enum_styles.hasMoreElements()) {
                Style s = (Style)enum_styles.nextElement();
                if (s == myStyle) continue;
                tags.add(s);
            }
            ComboBoxSheetProperty sp = (ComboBoxSheetProperty)this.getSheetPanel().getSheetProperty("style");
            sp.updateValues(tags, true);
        }
        this.setIreportFont(new IReportFont());
        this.getIreportFont().setBold(myStyle.getAttributeBoolean("isBold", false));
        this.getIreportFont().setFontName(myStyle.getAttributeString("fontName", this.getIreportFont().getFontName()));
        this.getIreportFont().setFontSize(myStyle.getAttributeInteger("fontSize", this.getIreportFont().getFontSize()));
        this.getIreportFont().setItalic(myStyle.getAttributeBoolean("isItalic", false));
        this.getIreportFont().setPdfEmbedded(myStyle.getAttributeBoolean("isPdfEmbedded", false));
        this.getIreportFont().setPdfEncoding(myStyle.getAttributeString("pdfEncoding", this.getIreportFont().getPdfEncoding()));
        this.getIreportFont().setStrikeTrought(myStyle.getAttributeBoolean("isStrikeThrough", false));
        this.getIreportFont().setPDFFontName(myStyle.getAttributeString("pdfFontName", this.getIreportFont().getPDFFontName()));
        this.getIreportFont().setUnderline(myStyle.getAttributeBoolean("isUnderline", false));
        this.updateStyleValues();
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(boolean insertMode) {
        this.insertMode = insertMode;
    }

    public IReportFont getIreportFont() {
        return this.ireportFont;
    }

    public void setIreportFont(IReportFont ireportFont) {
        this.ireportFont = ireportFont;
    }
}

