/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class JRAbstractBeanDataSource
implements JRRewindableDataSource {
    protected PropertyNameProvider propertyNameProvider = null;

    public JRAbstractBeanDataSource(boolean isUseFieldDescription) {
        this.propertyNameProvider = isUseFieldDescription ? new PropertyNameProvider(){

            public String getPropertyName(JRField field) {
                if (field.getDescription() == null) {
                    return field.getName();
                }
                return field.getDescription();
            }
        } : new PropertyNameProvider(){

            public String getPropertyName(JRField field) {
                return field.getName();
            }
        };
    }

    protected Object getFieldValue(Object bean, JRField field) throws JRException {
        Object value;
        block6: {
            value = null;
            if (bean != null) {
                String propertyName = this.propertyNameProvider.getPropertyName(field);
                try {
                    value = PropertyUtils.getProperty((Object)bean, (String)propertyName);
                }
                catch (IllegalAccessException e) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, e);
                }
                catch (InvocationTargetException e) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, e);
                }
                catch (NoSuchMethodException e) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, e);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().startsWith("Null property value for ")) break block6;
                    throw e;
                }
            }
        }
        return value;
    }

    static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

