/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRCsvSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_CSV = ".csv";

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_CSV);
    }

    public String getDescription() {
        return "CSV (*.csv)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_CSV)) {
            file = new File(file.getAbsolutePath() + EXTENSION_CSV);
        }
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.exportReport();
    }
}

